/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.config.impl.internal;

import com.google.common.collect.BiMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.GuiModList;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pregenerator.ChunkPregenerator;
import pregenerator.config.api.IConfigChangeListener;
import pregenerator.config.config.ConfigHandler;
import pregenerator.config.gui.api.DataType;
import pregenerator.config.gui.api.ISuggestionRenderer;
import pregenerator.config.gui.config.ColorElement;
import pregenerator.config.gui.config.RegistryElement;
import pregenerator.config.gui.screen.ConfigScreenFactory;
import pregenerator.config.gui.widgets.SuggestionRenderers;
import pregenerator.config.gui.widgets.screen.CarbonScreen;
import pregenerator.config.impl.PerWorldProxy;
import pregenerator.config.impl.entries.ColorValue;
import pregenerator.config.impl.internal.ModConfigList;
import pregenerator.config.impl.internal.ModConfigs;
import pregenerator.config.networking.carbon.StateSyncPacket;
import pregenerator.config.networking.snyc.BulkSyncPacket;
import pregenerator.config.networking.snyc.SyncPacket;
import pregenerator.config.utils.SyncType;

public class EventHandler
implements IConfigChangeListener {
    public static final EventHandler INSTANCE = new EventHandler();
    boolean loaded = false;
    boolean allowFailed = true;
    Map<ModContainer, ModConfigs> configs = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectLinkedOpenHashMap());

    public static void onPlayerClientJoin() {
        INSTANCE.onPlayerClientJoinEvent();
    }

    @SideOnly(value=Side.CLIENT)
    public static void onPlayerClientLeave(IntegratedServer server) {
        INSTANCE.onPlayerClientLeaveEvent(server);
    }

    @Override
    public void onConfigCreated(ConfigHandler config) {
        this.initMinecraftDataTypes(config);
        if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
            return;
        }
        ModContainer container = Loader.instance().activeModContainer();
        if (container == null) {
            throw new IllegalStateException("Mod Configs Must be created (not loaded) during a Mod Loading Phase");
        }
        this.configs.computeIfAbsent(container, ModConfigs::new).addConfig(config);
    }

    public void initMinecraftDataTypes(ConfigHandler config) {
        config.addParser('C', ColorValue::parse);
        config.addTempParser('R');
        config.addTempParser('K');
    }

    @Override
    public void onConfigAdded(ConfigHandler config) {
    }

    @Override
    public void onConfigChanged(ConfigHandler config) {
        SyncPacket packet;
        if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
            SyncPacket packet2 = SyncPacket.create(config, SyncType.SERVER_TO_CLIENT, false);
            if (packet2 != null) {
                ChunkPregenerator.NETWORKING.sendToAllPlayers(packet2);
            }
            return;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null && (packet = SyncPacket.create(config, SyncType.SERVER_TO_CLIENT, false)) != null) {
            ChunkPregenerator.NETWORKING.sendToAllPlayers(packet);
        }
        if (ChunkPregenerator.NETWORKING.isInWorld() && (packet = SyncPacket.create(config, SyncType.CLIENT_TO_SERVER, false)) != null) {
            ChunkPregenerator.NETWORKING.sendToServer(packet);
        }
    }

    @Override
    public void onConfigErrored(ConfigHandler configHandler) {
    }

    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public void onServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.processEvents();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.processEvents();
        } else {
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof CarbonScreen) {
                ((CarbonScreen)screen).tick();
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGuiOpenedEvent(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiModList) {
            this.registerConfigs();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void registerConfigs() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        BiMap factory = (BiMap)ObfuscationReflectionHelper.getPrivateValue(FMLClientHandler.class, (Object)FMLClientHandler.instance(), (String[])new String[]{"guiFactories"});
        Object2ObjectLinkedOpenHashMap mappedConfigs = new Object2ObjectLinkedOpenHashMap();
        this.configs.forEach((arg_0, arg_1) -> EventHandler.lambda$registerConfigs$1(factory, (Object2ObjectMap)mappedConfigs, arg_0, arg_1));
        mappedConfigs.forEach((M, C) -> {
            IModGuiFactory cfr_ignored_0 = (IModGuiFactory)factory.put(M, (Object)new ConfigScreenFactory(ModConfigList.createMultiIfApplicable(M, C)));
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void onConfigsLoaded() {
        this.loadDefaultTypes();
    }

    @SideOnly(value=Side.CLIENT)
    private void loadDefaultTypes() {
        ISuggestionRenderer.Registry.register(Item.class, new SuggestionRenderers.ItemEntry());
        ISuggestionRenderer.Registry.register(Block.class, new SuggestionRenderers.ItemEntry());
        ISuggestionRenderer.Registry.register(Fluid.class, new SuggestionRenderers.FluidEntry());
        ISuggestionRenderer.Registry.register(Enchantment.class, new SuggestionRenderers.EnchantmentEntry());
        ISuggestionRenderer.Registry.register(ColorValue.ColorWrapper.class, new SuggestionRenderers.ColorEntry());
        ISuggestionRenderer.Registry.register(Potion.class, new SuggestionRenderers.PotionEntry());
        DataType.registerType(Item.class, RegistryElement.createForType(Item.class, "minecraft:air"));
        DataType.registerType(Block.class, RegistryElement.createForType(Block.class, "minecraft:air"));
        DataType.registerType(Fluid.class, RegistryElement.createForType(Fluid.class, "minecraft:water"));
        DataType.registerType(Enchantment.class, RegistryElement.createForType(Enchantment.class, "minecraft:fortune"));
        DataType.registerType(Potion.class, RegistryElement.createForType(Potion.class, "minecraft:luck"));
        DataType.registerType(ColorValue.ColorWrapper.class, new DataType(false, "0xFFFFFFFF", ColorElement::new, ColorElement::new));
    }

    public void onServerJoinPacket(EntityPlayer player) {
        ChunkPregenerator.NETWORKING.sendToPlayer(new StateSyncPacket(Side.SERVER), player);
        ChunkPregenerator.NETWORKING.onPlayerJoined(player, true);
        BulkSyncPacket packet = BulkSyncPacket.create(ChunkPregenerator.CONFIGS.getConfigsToSync(), SyncType.SERVER_TO_CLIENT, true);
        if (packet == null) {
            return;
        }
        ChunkPregenerator.NETWORKING.sendToPlayer(packet, player);
    }

    @SubscribeEvent
    public void onServerLeaveEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        ChunkPregenerator.NETWORKING.onPlayerLeft(event.player, true);
    }

    @SideOnly(value=Side.CLIENT)
    public void onPlayerClientJoinEvent() {
        if (Minecraft.func_71410_x().func_71401_C() == null) {
            this.loadMPConfigs();
        }
        ChunkPregenerator.NETWORKING.sendToServer(new StateSyncPacket(Side.CLIENT));
        ChunkPregenerator.onClientJoinEvent();
        BulkSyncPacket packet = BulkSyncPacket.create(ChunkPregenerator.CONFIGS.getConfigsToSync(), SyncType.CLIENT_TO_SERVER, true);
        if (packet == null) {
            return;
        }
        ChunkPregenerator.NETWORKING.sendToServer(packet);
    }

    @SideOnly(value=Side.CLIENT)
    public void onPlayerClientLeaveEvent(IntegratedServer server) {
        ChunkPregenerator.NETWORKING.onPlayerLeft(null, false);
        if (server == null) {
            for (ConfigHandler handler : ChunkPregenerator.CONFIGS.getAllConfigs()) {
                if (!PerWorldProxy.isProxy(handler.getProxy())) continue;
                handler.unload();
            }
        }
    }

    private void loadMPConfigs() {
        for (ConfigHandler handler : ChunkPregenerator.CONFIGS.getAllConfigs()) {
            if (!PerWorldProxy.isProxy(handler.getProxy())) continue;
            handler.load();
        }
    }

    private void processEvents() {
        ChunkPregenerator.CONFIGS.processFileSystemEvents();
    }

    private static /* synthetic */ void lambda$registerConfigs$1(BiMap factory, Object2ObjectMap mappedConfigs, ModContainer M, ModConfigs C) {
        if (factory.containsKey((Object)M)) {
            return;
        }
        ((List)mappedConfigs.computeIfAbsent((Object)M, T -> new ObjectArrayList())).add(C);
    }
}

