/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.config.impl.internal;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import pregenerator.config.api.ConfigType;
import pregenerator.config.config.ConfigHandler;
import pregenerator.config.gui.api.BackgroundTexture;
import pregenerator.config.gui.api.IModConfig;
import pregenerator.config.gui.api.IModConfigs;
import pregenerator.config.gui.impl.carbon.ModConfig;

public class ModConfigs
implements IModConfigs {
    ModContainer container;
    List<ConfigHandler> knownConfigs = new ObjectArrayList();

    public ModConfigs(ModContainer container) {
        this.container = container;
    }

    public static ModConfigs of() {
        return new ModConfigs(Loader.instance().activeModContainer());
    }

    public static ModConfigs of(String modId, ConfigHandler handler) {
        ModConfigs configs = new ModConfigs((ModContainer)Loader.instance().getIndexedModList().get(modId));
        configs.addConfig(handler);
        return configs;
    }

    public static ModConfigs of(ConfigHandler handler) {
        ModConfigs configs = new ModConfigs(Loader.instance().activeModContainer());
        configs.addConfig(handler);
        return configs;
    }

    @Override
    public String getModName() {
        return this.container.getName();
    }

    public void addConfig(ConfigHandler config) {
        this.knownConfigs.add(config);
    }

    @Override
    public List<IModConfig> getConfigInstances(ConfigType type) {
        ObjectArrayList instance = new ObjectArrayList();
        for (ConfigHandler handler : this.knownConfigs) {
            if (!handler.isRegistered() || handler.getConfigType() != type) continue;
            instance.add(new ModConfig(this.container.getModId(), handler));
        }
        instance.sort(Comparator.comparing(IModConfig::getConfigName, String.CASE_INSENSITIVE_ORDER));
        return instance;
    }

    @Override
    public BackgroundTexture.BackgroundHolder getBackground() {
        BackgroundTexture texture = IModConfigs.TEXTURE_REGISTRY.get(this.container);
        if (texture != null) {
            return texture.asHolder();
        }
        return ModConfigs.computeTexture(this.container).orElse(BackgroundTexture.DEFAULT).asHolder();
    }

    public static Optional<BackgroundTexture> computeTexture(ModContainer container) {
        String[] values = container.getCustomModProperties().getOrDefault("guiconfig", "").split(";");
        if (values.length < 2) {
            return Optional.empty();
        }
        Object2ObjectOpenHashMap arguments = new Object2ObjectOpenHashMap();
        int i = 0;
        int m = values.length;
        while (i + 1 < m) {
            arguments.put(values[i], values[i + 1]);
            i += 2;
        }
        if (arguments.containsKey("texture")) {
            BackgroundTexture.Builder builder = BackgroundTexture.of((String)arguments.get("texture"));
            if (arguments.containsKey("brightness")) {
                builder.withBrightness(Integer.parseInt((String)arguments.get("brightness")));
            }
            return Optional.of(builder.build());
        }
        if (arguments.containsKey("background")) {
            BackgroundTexture.Builder builder = BackgroundTexture.of((String)arguments.get("background"));
            if (arguments.containsKey("foreground")) {
                builder.withForeground((String)arguments.get("foreground"));
            }
            if (arguments.containsKey("brightness")) {
                builder.withBrightness(Integer.parseInt((String)arguments.get("brightness")));
            }
            if (arguments.containsKey("background_brightness")) {
                builder.withBackground(Integer.parseInt((String)arguments.get("background_brightness")));
            }
            if (arguments.containsKey("foreground_brightness")) {
                builder.withForeground(Integer.parseInt((String)arguments.get("foreground_brightness")));
            }
            return Optional.of(builder.build());
        }
        return Optional.empty();
    }
}

