/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.config.networking.carbon;

import io.netty.buffer.Unpooled;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.network.IPregenPacket;
import pregenerator.config.config.ConfigHandler;
import pregenerator.config.networking.carbon.ConfigAnswerPacket;
import pregenerator.config.utils.MultilinePolicy;

public class ConfigRequestPacket
implements IPregenPacket {
    UUID id;
    String identifier;

    public ConfigRequestPacket() {
    }

    public ConfigRequestPacket(UUID id, String identifier) {
        this.id = id;
        this.identifier = identifier;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_179252_a(this.id);
        buffer.func_180714_a(this.identifier);
    }

    @Override
    public void read(PacketBuffer buffer) {
        this.id = buffer.func_179253_g();
        this.identifier = buffer.func_150789_c(Short.MAX_VALUE);
    }

    @Override
    public void process(EntityPlayer player) {
        if (!ConfigRequestPacket.hasPermissions(player, 4)) {
            return;
        }
        ConfigHandler handler = ChunkPregenerator.CONFIGS.getConfig(this.identifier);
        if (handler == null) {
            return;
        }
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        buf.func_180714_a(handler.getConfig().serialize(MultilinePolicy.DISABLED));
        byte[] data = new byte[buf.writerIndex()];
        buf.readBytes(data);
        ChunkPregenerator.NETWORKING.sendToPlayer(new ConfigAnswerPacket(this.id, data), player);
    }

    private static boolean hasPermissions(EntityPlayer player, int value) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server.func_71264_H() && Objects.equals(player.func_146103_bH().getName(), server.func_71214_G())) {
            return true;
        }
        UserListOpsEntry entry = (UserListOpsEntry)server.func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH());
        return entry != null && entry.func_152644_a() >= value;
    }
}

