/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.config.networking.carbon;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.network.IPregenPacket;
import pregenerator.config.config.ConfigHandler;

public class SaveConfigPacket
implements IPregenPacket {
    String identifier;
    String data;

    public SaveConfigPacket() {
    }

    public SaveConfigPacket(String identifier, String data) {
        this.identifier = identifier;
        this.data = data;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_180714_a(this.identifier);
        buffer.func_180714_a(this.data);
    }

    @Override
    public void read(PacketBuffer buffer) {
        this.identifier = buffer.func_150789_c(Short.MAX_VALUE);
        this.data = buffer.func_150789_c(262144);
    }

    @Override
    public void process(EntityPlayer player) {
        if (!SaveConfigPacket.hasPermissions(player, 4)) {
            ChunkPregenerator.LOGGER.warn("Don't have Permission to Change configs");
            return;
        }
        ConfigHandler handler = ChunkPregenerator.CONFIGS.getConfig(this.identifier);
        if (handler == null) {
            return;
        }
        try {
            ConfigHandler.load(handler, handler.getConfig(), (List<String>)ObjectArrayList.wrap((Object[])this.data.split("\n")), false);
            handler.save();
            ChunkPregenerator.LOGGER.info("Saved [" + this.identifier + "] Config");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean hasPermissions(EntityPlayer player, int value) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server.func_71264_H() && Objects.equals(player.func_146103_bH().getName(), server.func_71214_G())) {
            return true;
        }
        UserListOpsEntry entry = (UserListOpsEntry)server.func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH());
        return entry != null && entry.func_152644_a() >= value;
    }
}

