/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.config.networking.snyc;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import pregenerator.base.api.network.IPregenPacket;
import pregenerator.config.config.ConfigHandler;
import pregenerator.config.impl.ReloadMode;
import pregenerator.config.networking.snyc.SyncPacket;
import pregenerator.config.utils.SyncType;

public class BulkSyncPacket
implements IPregenPacket {
    List<SyncPacket> packets = new ObjectArrayList();

    public BulkSyncPacket() {
    }

    public BulkSyncPacket(List<SyncPacket> packets) {
        this.packets = packets;
    }

    public static BulkSyncPacket create(Collection<ConfigHandler> toSync, SyncType type, boolean forceSync) {
        ObjectArrayList result = new ObjectArrayList();
        for (ConfigHandler handler : toSync) {
            SyncPacket packet = SyncPacket.create(handler, type, forceSync);
            if (packet == null) continue;
            result.add(packet);
        }
        return result.isEmpty() ? null : new BulkSyncPacket((List<SyncPacket>)result);
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_150787_b(this.packets.size());
        for (SyncPacket packet : this.packets) {
            packet.write(buffer);
        }
    }

    @Override
    public void read(PacketBuffer buffer) {
        int size = buffer.func_150792_a();
        for (int i = 0; i < size; ++i) {
            SyncPacket packet = new SyncPacket();
            packet.read(buffer);
            this.packets.add(packet);
        }
    }

    @Override
    public void process(EntityPlayer player) {
        ReloadMode result = null;
        for (SyncPacket packet : this.packets) {
            result = ReloadMode.or(result, packet.processEntry(player));
        }
        if (result != null) {
            player.func_145747_a(result.getName());
        }
    }
}

