/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client;

import java.awt.Desktop;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSleepMP;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import pregenerator.ChunkPregenerator;
import pregenerator.PregenConfig;
import pregenerator.base.api.misc.IRenderHelper;
import pregenerator.impl.client.ProcessorRenderer;
import pregenerator.impl.client.TrackerRenderer;
import pregenerator.impl.client.gui.PregenMenu;
import pregenerator.impl.client.gui.chat.ChatScreen;
import pregenerator.impl.client.gui.chat.IPregenChat;
import pregenerator.impl.client.gui.chat.MPChatScreen;
import pregenerator.impl.client.gui.chat.MultilineChatScreen;
import pregenerator.impl.client.preview.PreviewScreen;

@SideOnly(value=Side.CLIENT)
public class ClientHandler {
    public static KeyBinding UI_KEY;
    public static ClientHandler INSTANCE;
    public ProcessorRenderer processor = new ProcessorRenderer();
    public TrackerRenderer tracker = new TrackerRenderer();
    IRenderHelper helper;
    boolean replacedChat = false;
    boolean didOptifine = false;

    public void init() {
        ChunkPregenerator.BASE_API.registerTickEvent(this);
        UI_KEY = new KeyBinding("Options Gui", 23, "Chunk-Pregenerator");
        ClientRegistry.registerKeyBinding((KeyBinding)UI_KEY);
        this.helper = ChunkPregenerator.BASE_API.createRenderHelper();
    }

    public void onInfoPacketReceived(byte[] data) {
        this.processor.onInfoPacketReceived(data);
    }

    public void onTrackerPacketReceived(byte[] data) {
        this.tracker.onTrackerInfoReceived(data);
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        GuiScreen screen = event.getGui();
        Minecraft mc = Minecraft.func_71410_x();
        if (screen instanceof GuiMainMenu) {
            if (!this.replacedChat && !PregenConfig.INSTANCE.disableAdvChat.get()) {
                ReflectionHelper.setPrivateValue(GuiIngame.class, (Object)mc.field_71456_v, (Object)((Object)new MultilineChatScreen()), (String[])new String[]{"persistantChatGUI", "field_73840_e"});
                this.replacedChat = true;
            }
            if (!this.didOptifine && this.isOptifineNotReleased()) {
                this.didOptifine = true;
                event.setCanceled(true);
                mc.func_147108_a((GuiScreen)new GuiYesNo((K, V) -> mc.func_147108_a((GuiScreen)new GuiMainMenu()), ClientHandler.translate("gui.chunk_pregen.warnings.optifine.header"), ClientHandler.translate("gui.chunk_pregen.warnings.optifine.body"), ClientHandler.translate("gui.chunk_pregen.warnings.optifine.ok_button"), ClientHandler.translate("gui.chunk_pregen.warnings.optifine.no_button"), 0));
            } else if (Loader.isModLoaded((String)"forgeessentials") && !PregenConfig.INSTANCE.warnedForgeEssentials.get()) {
                PregenConfig.INSTANCE.warnedForgeEssentials.set(true);
                PregenConfig.INSTANCE.save();
                event.setCanceled(true);
                mc.func_147108_a((GuiScreen)new GuiYesNo((K, V) -> {
                    if (K) {
                        ClientHandler.openFolder(ChunkPregenerator.CONFIGS.getBasePath());
                    }
                    mc.func_147108_a((GuiScreen)new GuiMainMenu());
                }, ClientHandler.translate("gui.chunk_pregen.warnings.forge.header"), ClientHandler.translate("gui.chunk_pregen.warnings.forge.body"), ClientHandler.translate("gui.chunk_pregen.warnings.forge.ok"), ClientHandler.translate("gui.chunk_pregen.warnings.forge.not_ok"), 0));
            }
        } else if (screen instanceof GuiChat && !(screen instanceof IPregenChat)) {
            if (screen instanceof GuiSleepMP) {
                event.setCanceled(true);
                mc.func_147108_a((GuiScreen)new MPChatScreen());
            } else {
                event.setCanceled(true);
                mc.func_147108_a((GuiScreen)new ChatScreen((GuiChat)screen));
            }
        }
    }

    private static void openFolder(Path folder) {
        try {
            Desktop.getDesktop().browse(folder.toUri());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String translate(String key) {
        return I18n.func_135052_a((String)key, (Object[])new Object[0]).replace("\\n", "\n");
    }

    @SubscribeEvent
    public void onGuiOpened(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof GuiCreateWorld) {
            int width = event.getGui().field_146294_l / 2;
            event.getButtonList().add(new GuiButton(-100, width - 155, 187, 72, 20, ClientHandler.translate("gui.chunk_pregen.button.preview")));
        }
    }

    private boolean isOptifineNotReleased() {
        if (!FMLClientHandler.instance().hasOptifine()) {
            return false;
        }
        String version = (String)FMLClientHandler.instance().getAdditionalBrandingInformation().get(0);
        return version.contains("pre") && (version.contains("F3") || version.contains("F4")) || version.contains("E3");
    }

    @SubscribeEvent
    public void onButtonPressed(GuiScreenEvent.ActionPerformedEvent.Post event) {
        if (event.getGui() instanceof GuiCreateWorld && event.getButton().field_146127_k == -100) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new PreviewScreen((GuiCreateWorld)event.getGui()));
        }
    }

    @SubscribeEvent
    public void onKeyPressed(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (UI_KEY.func_151470_d() && mc.field_71462_r == null) {
            mc.func_147108_a(PregenMenu.MENU.get());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onInput(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (Mouse.getEventButton() == 0 && Mouse.getEventButtonState()) {
            int mouseY;
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution res = new ScaledResolution(mc);
            int mouseX = (int)((double)Mouse.getX() * (double)res.func_78326_a() / (double)mc.field_71443_c);
            if (this.processor.onClick(mouseX, mouseY = (int)((double)(mc.field_71440_d - Mouse.getY()) * (double)res.func_78328_b() / (double)mc.field_71440_d))) {
                event.setCanceled(true);
            } else if (this.tracker.onClick(mouseX, mouseY)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent.Post evt) {
        if (evt.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        this.processor.onUIRenderer(evt, this.helper);
        this.tracker.onUIRenderer(evt, this.helper);
    }

    @SubscribeEvent
    public void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        this.processor.update();
        this.tracker.update();
    }

    static {
        INSTANCE = new ClientHandler();
    }
}

