/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pregenerator.ChunkPregenerator;
import pregenerator.PregenConfig;
import pregenerator.base.api.Align;
import pregenerator.base.api.misc.IRenderHelper;
import pregenerator.impl.client.info.IProcessorInfo;
import pregenerator.impl.config.PregenOverlay;
import pregenerator.impl.network.OverlayPacket;

public class ProcessorRenderer {
    Map<Integer, IProcessorInfo> byType = new HashMap<Integer, IProcessorInfo>();
    Map<UUID, IProcessorInfo> byTaskId = new HashMap<UUID, IProcessorInfo>();
    List<Integer> infos = new ArrayList<Integer>();
    List<UUID> miniInfos = new ArrayList<UUID>();
    int ticker = 0;

    public void onInfoPacketReceived(byte[] data) {
        if (data.length <= 0) {
            this.byType.clear();
            this.infos.clear();
            this.byTaskId.clear();
            this.infos.clear();
            return;
        }
        PacketBuffer buffer = new PacketBuffer(Unpooled.wrappedBuffer((byte[])data));
        HashSet<Integer> found = new HashSet<Integer>();
        HashSet<UUID> foundMini = new HashSet<UUID>();
        boolean running = buffer.readBoolean();
        if (running) {
            int type = buffer.readInt();
            found.add(type);
            IProcessorInfo info = this.byType.get(type);
            if (info != null) {
                buffer.readByte();
                info.read(new PacketBuffer(Unpooled.wrappedBuffer((byte[])buffer.func_179251_a())));
            } else {
                info = IProcessorInfo.create(buffer.readByte());
                if (info != null) {
                    info.setDimension(type);
                    info.read(new PacketBuffer(Unpooled.wrappedBuffer((byte[])buffer.func_179251_a())));
                    this.byType.put(type, info);
                    this.infos.add(type);
                }
            }
        }
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            UUID id = buffer.func_179253_g();
            foundMini.add(id);
            IProcessorInfo info = this.byTaskId.get(id);
            if (info != null) {
                buffer.readByte();
                info.read(new PacketBuffer(Unpooled.wrappedBuffer((byte[])buffer.func_179251_a())));
                continue;
            }
            info = IProcessorInfo.create(buffer.readByte());
            if (info == null) continue;
            info.setTaskId(id);
            info.read(new PacketBuffer(Unpooled.wrappedBuffer((byte[])buffer.func_179251_a())));
            this.byTaskId.put(id, info);
            this.miniInfos.add(id);
        }
        this.infos.retainAll(found);
        this.byType.keySet().retainAll(found);
        this.miniInfos.retainAll(foundMini);
        this.byTaskId.keySet().retainAll(foundMini);
    }

    @SideOnly(value=Side.CLIENT)
    public void onUIRenderer(RenderGameOverlayEvent.Post event, IRenderHelper helper) {
        IProcessorInfo info;
        int i;
        if (!this.shouldRender()) {
            return;
        }
        if (!this.shouldRender()) {
            return;
        }
        int yLevel = 0;
        int m = this.infos.size();
        for (int i2 = 0; i2 < m; ++i2) {
            IProcessorInfo info2 = this.byType.get(this.infos.get(i2));
            yLevel += info2 != null ? info2.getHeight() : 0;
        }
        PregenOverlay overlay = PregenConfig.INSTANCE.pregenOverlay;
        float zoom = (float)overlay.getScale();
        float invZoom = 1.0f / zoom;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)250.0);
        if (zoom != 1.0f) {
            GlStateManager.func_179152_a((float)zoom, (float)zoom, (float)1.0f);
        }
        yLevel = this.calculateHeight(overlay.vAlign(), (int)((float)this.getScreenHeight() * invZoom), yLevel);
        int screenX = (int)((float)this.getScreenWidth() * invZoom);
        int m2 = this.infos.size();
        for (i = 0; i < m2; ++i) {
            info = this.byType.get(this.infos.get(i));
            if (info == null) continue;
            info.render(helper, this.calculateXOffset(overlay.hAlign(), screenX, info), yLevel, zoom);
            yLevel += info.getHeight();
        }
        m2 = this.miniInfos.size();
        for (i = 0; i < m2; ++i) {
            info = this.byTaskId.get(this.miniInfos.get(i));
            if (info == null) continue;
            info.render(helper, this.calculateXOffset(overlay.hAlign(), screenX, info), yLevel, zoom);
            yLevel += info.getHeight();
        }
        GlStateManager.func_179121_F();
    }

    public boolean onClick(int mouseX, int mouseY) {
        IProcessorInfo info;
        int i;
        if (!this.shouldRender()) {
            return false;
        }
        float scale = 1.0f / (float)PregenConfig.INSTANCE.pregenOverlay.getScale();
        mouseX = (int)((float)mouseX * scale);
        mouseY = (int)((float)mouseY * scale);
        int m = this.infos.size();
        for (i = 0; i < m; ++i) {
            info = this.byType.get(this.infos.get(i));
            if (info == null || !info.onClick(mouseX, mouseY)) continue;
            return true;
        }
        m = this.miniInfos.size();
        for (i = 0; i < m; ++i) {
            info = this.byTaskId.get(this.miniInfos.get(i));
            if (info == null || !info.onClick(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void update() {
        if (!this.shouldRender()) {
            return;
        }
        if (++this.ticker % PregenConfig.INSTANCE.pregenOverlay.getPollDelay() == 0) {
            ChunkPregenerator.NETWORKING.sendToServer(new OverlayPacket.Request());
        }
    }

    public boolean shouldRender() {
        return PregenConfig.INSTANCE.pregenOverlay.isEnabled();
    }

    public void setVisible(boolean value) {
        PregenConfig config = PregenConfig.INSTANCE;
        config.pregenOverlay.setEnabled(value);
        config.save();
    }

    @SideOnly(value=Side.CLIENT)
    private int getScreenHeight() {
        return new ScaledResolution(Minecraft.func_71410_x()).func_78328_b();
    }

    @SideOnly(value=Side.CLIENT)
    private int getScreenWidth() {
        return new ScaledResolution(Minecraft.func_71410_x()).func_78326_a();
    }

    @SideOnly(value=Side.CLIENT)
    private int calculateXOffset(Align align, int screenWidth, IProcessorInfo info) {
        switch (align) {
            case CENTER: {
                return screenWidth / 2 - info.getWidth() / 2;
            }
            case END: {
                return screenWidth - info.getWidth();
            }
        }
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    private int calculateHeight(Align align, int screenHeight, int yLevel) {
        if (align == Align.END) {
            return screenHeight - yLevel;
        }
        if (align == Align.CENTER) {
            return screenHeight / 2 - yLevel / 2;
        }
        return 1;
    }
}

