/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.gui;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import pregenerator.base.api.Align;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.gui.BasePregenScreen;
import pregenerator.base.impl.gui.comp.CycleButton;
import pregenerator.base.impl.gui.comp.PregenButton;
import pregenerator.base.impl.gui.comp.PregenCheckBox;
import pregenerator.base.impl.gui.comp.PregenText;
import pregenerator.base.impl.gui.comp.PregenTreeList;
import pregenerator.impl.client.helpers.IChunkAcceptor;
import pregenerator.impl.network.ChunkPacket;
import pregenerator.impl.tracking.ChunkEntry;
import pregenerator.impl.tracking.types.BlockEntry;
import pregenerator.impl.tracking.types.EntityTypeEntry;
import pregenerator.impl.tracking.types.IWorldEntry;
import pregenerator.impl.tracking.types.TileEntry;

public class ChunkScreen
extends BasePregenScreen
implements IChunkAcceptor {
    private static final ITextComponent TOOLTIP_LAG = TextUtil.translateStyled("gui.chunk_pregen.dimension_screen.tooltip.no_lag", TextFormatting.RED);
    private static final ITextComponent TOOLTIP_RNG = TextUtil.translateStyled("gui.chunk_pregen.dimension_screen.tooltip.rng_tick", TextFormatting.RED);
    private static final ITextComponent TOOLTIP_DELETE = TextUtil.translateStyled("gui.chunk_pregen.dimension_screen.tooltip.delete", TextFormatting.DARK_AQUA);
    private static final ITextComponent SANITY_CHECK_HEADER = TextUtil.translateStyled("gui.chunk_pregen.check_screen.header", TextFormatting.BOLD, TextFormatting.RED);
    private static final DecimalFormat FORMATTER = new DecimalFormat("###,###");
    private static final String[] NAMES = new String[]{"gui.chunk_pregen.chunk_screen.types.tiles", "gui.chunk_pregen.chunk_screen.types.entities", "gui.chunk_pregen.chunk_screen.types.biomes", "gui.chunk_pregen.chunk_screen.types.blocks"};
    GuiScreen parent;
    Map<Class<? extends Entity>, Entity> entityCache = new Object2ObjectOpenHashMap();
    PregenTreeList.TreeState<ChunkNode> elements = new PregenTreeList.TreeState(48).setRowWidth(330).setTopPadding(65).setBottomPadding(35);
    CycleButton.CycleState<Integer> dimensions = new CycleButton.CycleState<Integer>(Integer.valueOf(0), TextUtil::dimension, this.dimensions());
    CycleButton.CycleState<Integer> sorter = new CycleButton.CycleState<Integer>(Integer.valueOf(0), this::getSorterName, 0, 1, 2);
    CycleButton.CycleState<Integer> filterType = new CycleButton.CycleState<Integer>(Integer.valueOf(0), this::getFilterType, 0, 1, 2, 3, 4);
    PregenText.TextState search = new PregenText.TextState("").setCallback(this.elements::search);
    PregenCheckBox.CheckboxState showMods = new PregenCheckBox.CheckboxState(true, true, TextUtil.translate("gui.chunk_pregen.retrogen_selector.show_mods"));
    PregenCheckBox.CheckboxState showFrame = new PregenCheckBox.CheckboxState(true, false, TextUtil.translate("gui.chunk_pregen.retrogen_selector.show_frame")).withStateListener(this.elements::setFrame);
    ITextComponent header = TextUtil.translate("gui.chunk_pregen.chunk_screen.header");

    public ChunkScreen(GuiScreen parent) {
        this.parent = parent;
        this.updateDimension();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.tree(this.elements);
        this.text(-96, 44, 92, 14, Align.CENTER, Align.START, this.search);
        this.cycleButton(-1, 43, 94, 16, Align.CENTER, Align.START, this.filterType, (CycleButton<T> T) -> this.elements.updateSearch()).setTooltip(TextUtil.translateStyled("gui.chunk_pregen.chunk_screen.search_target", new TextFormatting[0]));
        this.cycleButton(-97, 24, 94, 16, Align.CENTER, Align.START, this.sorter, (CycleButton<T> T) -> this.elements.sort(this.getNodeSorter((Integer)T.getValue()))).setTooltip(TextUtil.translateStyled("gui.chunk_pregen.dimension_screen.sort", TextFormatting.GOLD));
        this.cycleButton(-1, 24, 94, 16, Align.CENTER, Align.START, this.dimensions, (CycleButton<T> T) -> this.updateDimension()).withSelectScreen().setTooltip(this::getDimensionTooltip);
        this.checkbox(96, 25, 14, 14, Align.CENTER, Align.START, this.showFrame);
        this.checkbox(96, 43, 14, 14, Align.CENTER, Align.START, this.showMods);
        this.button(-60, -28, 120, 20, Align.CENTER, Align.END, TextUtil.translate("gui.chunk_pregen.retrogen_selector.back"), T -> this.onClose());
    }

    public void updateDimension() {
        this.sendToServer(new ChunkPacket.Request(this.dimensions.getValue()));
    }

    @Override
    public void onClose() {
        this.displayGuiScreen(this.parent);
    }

    @Override
    public void renderForeground(int mouseX, int mouseY, float partialTicks) {
        this.drawUnalignedText(this.header, this.centerX, 10.0f, Align.CENTER, -1);
    }

    @Override
    public void acceptUpdateData(int dimension, ChunkEntry chunk) {
        if (!this.dimensions.getValue().equals(dimension)) {
            return;
        }
        List<ChunkNode> owner = this.elements.getNodes();
        long pos = chunk.getPos();
        int index = -1;
        int m = owner.size();
        for (int i = 0; i < m; ++i) {
            ChunkNode node = owner.get(i);
            if (!(node instanceof RootNode) || ((RootNode)node).getEntry().getPos() != pos) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return;
        }
        owner.set(index, this.createNode(chunk));
        this.elements.sort(this.getNodeSorter(this.sorter.getValue()));
    }

    @Override
    public void acceptChunkData(int dimension, List<ChunkEntry> entries) {
        if (!this.dimensions.getValue().equals(dimension)) {
            return;
        }
        ObjectArrayList root = new ObjectArrayList();
        for (ChunkEntry chunk : entries) {
            root.add(this.createNode(chunk));
        }
        root.sort(this.getNodeSorter(this.sorter.getValue()));
        this.elements.replaceNodes((List<ChunkNode>)root);
    }

    private RootNode createNode(ChunkEntry chunk) {
        RootNode node = new RootNode(chunk);
        for (int i = 0; i < 4; ++i) {
            ObjectArrayList list = new ObjectArrayList(chunk.get(i, IWorldEntry.class));
            if (list.isEmpty()) continue;
            list.sort(Comparator.comparingInt(IWorldEntry::getCount).reversed());
            CategoryNode cat = new CategoryNode(TextUtil.translate(NAMES[i]), i, (List<IWorldEntry>)list);
            for (IWorldEntry entry : list) {
                cat.addChildNode(i == 2 ? new BiomeNode(entry) : new EntryNode(entry, i, chunk.getPos()));
            }
            node.addChildNode(cat);
        }
        return node;
    }

    private ITextComponent getDimensionTooltip(CycleButton<Integer> button) {
        ITextComponent base = TextUtil.empty();
        base.func_150257_a(TextUtil.translateStyled("gui.chunk_pregen.taskgenerator.tooltip.dimension", TextFormatting.GOLD));
        return base;
    }

    private ITextComponent getFilterType(int value) {
        switch (value) {
            case 0: {
                return TextUtil.translate("gui.chunk_pregen.chunk_screen.types.all");
            }
            case 1: {
                return TextUtil.translate("gui.chunk_pregen.chunk_screen.types.tiles");
            }
            case 2: {
                return TextUtil.translate("gui.chunk_pregen.chunk_screen.types.entities");
            }
            case 3: {
                return TextUtil.translate("gui.chunk_pregen.chunk_screen.types.biomes");
            }
            case 4: {
                return TextUtil.translate("gui.chunk_pregen.chunk_screen.types.blocks");
            }
        }
        return TextUtil.guiConstructor();
    }

    protected Comparator<ChunkNode> getNodeSorter(int mode) {
        Comparator<ChunkEntry> sorter = this.getEntrySorter(mode);
        if (mode != 2) {
            sorter = sorter.thenComparing(this.getEntrySorter(2));
        }
        return Comparator.comparing(RootNode.class::cast, Comparator.comparing(RootNode::getEntry, sorter));
    }

    protected Comparator<ChunkEntry> getEntrySorter(int mode) {
        switch (mode) {
            case 1: {
                return Comparator.comparingInt(ChunkEntry::getTiles).reversed();
            }
            case 2: {
                return Comparator.comparingInt(ChunkEntry::getEntities).reversed();
            }
        }
        return Comparator.comparingInt(T -> T.getDistance(this.getPlayerPos()));
    }

    private BlockPos getPlayerPos() {
        return Minecraft.func_71410_x().field_71439_g.func_180425_c();
    }

    private ITextComponent getSorterName(int value) {
        switch (value) {
            case 1: {
                return TextUtil.translate("gui.chunk_pregen.chunk_screen.types.tiles");
            }
            case 2: {
                return TextUtil.translate("gui.chunk_pregen.chunk_screen.types.entities");
            }
        }
        return TextUtil.translate("gui.chunk_pregen.chunk_screen.types.distance");
    }

    private static Entity create(Class<? extends Entity> type) {
        Entity entity = ChunkScreen.createEntity(type);
        if (entity instanceof EntityItem) {
            ((EntityItem)entity).func_92058_a(new ItemStack((Block)Blocks.field_150461_bJ));
        }
        return entity;
    }

    private static Entity createEntity(Class<? extends Entity> type) {
        try {
            return type.getConstructor(World.class).newInstance(Minecraft.func_71410_x().field_71441_e);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public class EntryNode
    extends ChunkNode {
        IWorldEntry entry;
        ResourceLocation id;
        int index;
        long chunkPos;
        boolean hovered;
        Entity entity;
        ITextComponent name;
        ITextComponent mod;
        ITextComponent found;
        ITextComponent ticking;
        ITextComponent tooltipName;
        ITextComponent tooltipMod;
        ITextComponent tooltipFound;

        public EntryNode(IWorldEntry entry, int index, long chunkPos) {
            this.entry = entry;
            this.index = index;
            this.chunkPos = chunkPos;
            this.name = TextUtil.applyTextStyle(entry.getName().func_150259_f(), TextFormatting.GOLD);
            this.id = entry.getKey();
            this.mod = TextUtil.applyTextStyle(TextUtil.getModName(this.id.func_110624_b()).func_150259_f(), TextFormatting.GRAY, TextFormatting.ITALIC);
            this.found = TextUtil.literal(BasePregenScreen.NUMBERS.format(entry.getCount()));
            this.ticking = TextUtil.translateStyled(index == 0 ? "gui.chunk_pregen.dimension_screen.ticking" : "gui.chunk_pregen.dimension_screen.rng_tick", TextFormatting.GRAY);
            this.tooltipName = TextUtil.applyTextStyle(TextUtil.translate(this.getTranslationKey(index), entry.getName()), TextFormatting.GOLD);
            this.tooltipMod = TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.taskgenerator.tooltip.mod", TextUtil.getModName(this.id.func_110624_b())), TextFormatting.GRAY);
            this.tooltipFound = TextUtil.translate("gui.chunk_pregen.dimension_screen.tooltip.found", BasePregenScreen.NUMBERS.format(entry.getCount()));
            if (entry instanceof EntityTypeEntry) {
                this.entity = ChunkScreen.this.entityCache.computeIfAbsent(((EntityTypeEntry)entry).getEntity().getEntityClass(), x$0 -> ChunkScreen.create(x$0));
            }
        }

        @Override
        protected boolean containsSearch(String searchString) {
            return this.containsString(searchString, this.index, this.id);
        }

        private Block getBlock() {
            if (this.entry instanceof TileEntry) {
                return ((TileEntry)this.entry).getType();
            }
            if (this.entry instanceof BlockEntry) {
                return ((BlockEntry)this.entry).getType();
            }
            return null;
        }

        public boolean isTicking() {
            return this.entry instanceof TileEntry && ((TileEntry)this.entry).isTicking();
        }

        public boolean isRandomTicking() {
            return this.entry instanceof BlockEntry && ((BlockEntry)this.entry).isTicking();
        }

        private String getTranslationKey(int index) {
            switch (index) {
                case 0: {
                    return "gui.chunk_pregen.dimension_screen.tooltip.type.tile";
                }
                case 1: {
                    return "gui.chunk_pregen.dimension_screen.tooltip.type.entity";
                }
                case 3: {
                    return "gui.chunk_pregen.dimension_screen.tooltip.type.block";
                }
            }
            return "gui.chunk_pregen.unused_constructor";
        }

        @Override
        public boolean mouseClick(double p_94737_, double p_94738_, int p_94739_) {
            if (GuiScreen.func_146272_n() && this.entry.canDelete(true)) {
                ChunkScreen.this.displayGuiScreen(ChunkScreen.this.createChoice(SANITY_CHECK_HEADER, TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.check_screen.body", BasePregenScreen.NUMBERS.format(this.entry.getCount()), this.name), TextFormatting.GRAY), (T, I) -> {
                    if (T) {
                        ChunkScreen.this.sendToServer(new ChunkPacket.RemoveAction(ChunkScreen.this.dimensions.getValue(), this.chunkPos, this.index, this.entry));
                    }
                    ChunkScreen.this.displayGuiScreen(ChunkScreen.this);
                }));
                return true;
            }
            return super.mouseClick(p_94737_, p_94738_, p_94739_);
        }

        @Override
        public void provideTooltips(Consumer<ITextComponent> tooltips) {
            super.provideTooltips(tooltips);
            if (this.hovered) {
                tooltips.accept(this.tooltipName);
                tooltips.accept(this.tooltipMod);
                tooltips.accept(this.tooltipFound);
                if (this.entry instanceof TileEntry && !((TileEntry)this.entry).isTicking()) {
                    tooltips.accept(TOOLTIP_LAG);
                } else if (this.isRandomTicking()) {
                    tooltips.accept(TOOLTIP_RNG);
                }
                if (this.entry.canDelete(false)) {
                    tooltips.accept(TOOLTIP_DELETE);
                }
                this.hovered = false;
            }
        }

        @Override
        public void render(int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            super.render(x, top, left, width, height, mouseX, mouseY, selected, partialTicks);
            this.hovered = mouseX >= left && mouseX < left + width && mouseY >= top && mouseY < top + height && this.isVisible(mouseX, mouseY);
            Block block = this.getBlock();
            if (block != null) {
                BasePregenScreen.pushScissors(left + width / 2 - 10, top, 20.0f, 20.0f);
                RenderHelper.func_74520_c();
                this.mc.func_175599_af().func_175042_a(new ItemStack(block), left + width / 2 - 9, top);
                BasePregenScreen.popScissors();
            }
            if (this.entity != null) {
                float entityHeight = this.entity.func_70047_e();
                entityHeight = (entityHeight - 1.0f) * 0.7f + 1.0f;
                float s = 1.0f * (11.2f / entityHeight);
                GlStateManager.func_179126_j();
                BasePregenScreen.pushScissors(left + width / 2 - 10, top, 20.0f, 20.0f);
                BasePregenScreen.renderEntityInGui(this.entity, left + width / 2 - 9, top - 3, s, 0.0f);
                BasePregenScreen.popScissors();
                GlStateManager.func_179097_i();
            }
            int y = top + this.fontRenderer.field_78288_b + 13;
            ChunkScreen.this.drawUnalignedScrollText(this.name, left + 2, y, width - 4, this.fontRenderer.field_78288_b + 1, Align.CENTER, -1, this.id.func_110623_a().hashCode());
            if (ChunkScreen.this.showMods.isChecked()) {
                ChunkScreen.this.drawUnalignedScrollText(this.mod, left + 2, y += this.fontRenderer.field_78288_b + 1, width - 4, this.fontRenderer.field_78288_b + 1, Align.CENTER, -1, this.id.func_110624_b().hashCode());
            }
            ChunkScreen.this.drawUnalignedScrollText(this.found, left + 2, y += this.fontRenderer.field_78288_b + 1, width - 4, this.fontRenderer.field_78288_b + 1, Align.CENTER, -1, this.id.hashCode());
            if (this.isTicking() || this.isRandomTicking()) {
                ChunkScreen.this.drawUnalignedScrollText(this.ticking, left + 2, y += this.fontRenderer.field_78288_b + 1, width - 4, this.fontRenderer.field_78288_b + 1, Align.CENTER, -1, this.id.hashCode());
            }
        }

        @Override
        public int getItemHeight() {
            return 45 + (ChunkScreen.this.showMods.isChecked() ? 10 : 0) + (this.isRandomTicking() || this.isTicking() ? 10 : 0);
        }
    }

    public class BiomeNode
    extends ChunkNode {
        IWorldEntry entry;
        ResourceLocation id;
        ITextComponent name;
        ITextComponent mod;

        public BiomeNode(IWorldEntry entry) {
            this.entry = entry;
            this.id = entry.getKey();
            this.name = TextUtil.applyTextStyle(entry.getName().func_150259_f().func_150258_a(" ").func_150257_a(TextUtil.applyTextStyle(TextUtil.literal(BasePregenScreen.NUMBERS.format(entry.getCount())), TextFormatting.WHITE)), TextFormatting.GOLD);
            this.mod = TextUtil.applyTextStyle(TextUtil.getModName(this.id.func_110624_b()).func_150259_f(), TextFormatting.GRAY, TextFormatting.ITALIC);
        }

        @Override
        protected boolean containsSearch(String searchString) {
            return this.containsString(searchString, 2, this.id);
        }

        @Override
        public void render(int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            super.render(x, top, left, width, height, mouseX, mouseY, selected, partialTicks);
            int y = ChunkScreen.this.showMods.isChecked() ? top : top + height / 2 - this.fontRenderer.field_78288_b / 2;
            ChunkScreen.this.drawUnalignedText(this.name, left + 20, y, Align.START, -1);
            if (!ChunkScreen.this.showMods.isChecked()) {
                return;
            }
            ChunkScreen.this.drawUnalignedText(this.mod, left + 20, top + this.fontRenderer.field_78288_b + 1, Align.START, -1);
        }

        @Override
        public int getItemHeight() {
            return ChunkScreen.this.showMods.isChecked() ? 22 : 13;
        }
    }

    public class CategoryNode
    extends ChunkNode {
        ITextComponent categoryName;
        int index;
        List<IWorldEntry> entries;

        public CategoryNode(ITextComponent categoryName, int index, List<IWorldEntry> entries) {
            this.categoryName = TextUtil.applyTextStyle(categoryName.func_150259_f(), this.getColor(index)).func_150258_a(": ").func_150257_a(TextUtil.applyTextStyle(TextUtil.literal(IWorldEntry.count(entries) + ", "), TextFormatting.WHITE).func_150257_a(this.getTypes(entries.size())));
            this.index = index;
            this.entries = entries;
        }

        @Override
        public void render(int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            super.render(x, top, left, width, height, mouseX, mouseY, selected, partialTicks);
            ChunkScreen.this.drawUnalignedText(this.categoryName, left + 20, top + height / 2 - this.fontRenderer.field_78288_b / 2, Align.START, -1);
        }

        public ITextComponent getTypes(int size) {
            return TextUtil.translate("gui.chunk_pregen.chunk_screen.category.type", BasePregenScreen.NUMBERS.format(size));
        }

        public TextFormatting getColor(int index) {
            switch (index) {
                case 0: {
                    return TextFormatting.DARK_RED;
                }
                case 1: {
                    return TextFormatting.DARK_GREEN;
                }
                case 2: {
                    return TextFormatting.BLUE;
                }
                case 3: {
                    return TextFormatting.DARK_PURPLE;
                }
            }
            return TextFormatting.WHITE;
        }

        @Override
        protected boolean areGridChildren() {
            return this.index != 2;
        }

        @Override
        protected int getGridWidth() {
            return 55;
        }

        @Override
        public int getItemHeight() {
            return 16;
        }
    }

    private class RootNode
    extends ChunkNode {
        ChunkEntry entry;
        int entities;
        int tiles;
        int ticking;
        PregenButton tpButton;
        ITextComponent chunkInfo;
        ITextComponent entityInfo;
        ITextComponent tileInfo;

        public RootNode(ChunkEntry entry) {
            this.tpButton = this.addChild(new PregenButton(0, 0, 20, 14, TextUtil.translate("gui.chunk_pregen.chunk_screen.tp"), this::teleport)).setTooltip(TextUtil.translate("gui.chunk_pregen.chunk_screen.tp.desc"));
            this.entry = entry;
            this.entities = entry.getEntities();
            this.tiles = entry.getTiles();
            this.ticking = entry.getTickingTiles();
            ITextComponent text = TextUtil.empty();
            text.func_150257_a(TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.chunk_screen.entry.chunk.base", FORMATTER.format(entry.getX()), FORMATTER.format(entry.getZ())), TextFormatting.YELLOW));
            text.func_150257_a(TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.chunk_screen.entry.chunk.dist", FORMATTER.format(entry.getDistance(Minecraft.func_71410_x().field_71439_g.func_180425_c()))), TextFormatting.AQUA));
            this.chunkInfo = text;
            this.entityInfo = TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.chunk_screen.entry.entities", FORMATTER.format(this.entities)), TextFormatting.WHITE);
            this.tileInfo = TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.chunk_screen.entry.tiles", FORMATTER.format(this.tiles), FORMATTER.format(this.ticking)), TextFormatting.WHITE);
        }

        private void teleport(GuiButton button) {
            ChunkScreen.this.sendToServer(new ChunkPacket.TPAction(ChunkScreen.this.dimensions.getValue(), this.entry.getPos()));
            ChunkScreen.this.displayGuiScreen(null);
        }

        public ChunkEntry getEntry() {
            return this.entry;
        }

        @Override
        public void render(int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            super.render(x, top, left, width, height, mouseX, mouseY, selected, partialTicks);
            this.tpButton.field_146128_h = left + width - this.tpButton.getWidgetWidth() - 3;
            this.tpButton.field_146129_i = top + height / 2 - this.tpButton.getWidgetHeight() / 2;
            this.tpButton.render(this.mc, mouseX, mouseY, partialTicks);
            if (this.hasAny()) {
                ChunkScreen.this.drawUnalignedText(this.chunkInfo, left + 20, top, Align.START, -1);
                ITextComponent text = TextUtil.empty();
                if (this.hasEntities()) {
                    text.func_150257_a(this.entityInfo);
                    if (this.hasTiles()) {
                        text.func_150258_a(", ");
                    }
                }
                if (this.hasTiles()) {
                    text.func_150257_a(this.tileInfo);
                }
                ChunkScreen.this.drawUnalignedText(text, left + 20, top + this.fontRenderer.field_78288_b + 1, Align.START, -1);
                return;
            }
            ChunkScreen.this.drawUnalignedText(this.chunkInfo, left + 20, (float)top + (float)height / 2.0f - (float)this.fontRenderer.field_78288_b / 2.0f + 0.5f, Align.START, -1);
        }

        public boolean hasAny() {
            return this.hasEntities() || this.hasTiles();
        }

        public boolean hasEntities() {
            return this.entities > 0;
        }

        public boolean hasTiles() {
            return this.tiles > 0;
        }

        @Override
        public int getItemHeight() {
            return this.hasAny() ? 22 : 16;
        }
    }

    private class ChunkNode
    extends PregenTreeList.TreeEntry<ChunkNode> {
        private ChunkNode() {
        }

        @Override
        protected boolean containsSearch(String searchString) {
            return false;
        }

        protected boolean containsString(String searchString, int index, ResourceLocation id) {
            int otherIndex = ChunkScreen.this.filterType.getValue();
            if (otherIndex != 0 && otherIndex - 1 != index) {
                return false;
            }
            return this.searchResourceLocation(searchString, id);
        }
    }
}

