/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.Align;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.gui.BasePregenScreen;
import pregenerator.base.impl.gui.comp.PregenButton;
import pregenerator.base.impl.gui.comp.PregenCheckBox;
import pregenerator.base.impl.gui.comp.PregenText;
import pregenerator.base.impl.gui.comp.PregenTreeList;
import pregenerator.impl.network.RetrogenPacket;
import pregenerator.impl.retrogen.RetrogenManager;

public class RetrogenScreen
extends BasePregenScreen {
    ITextComponent header = TextUtil.translate("gui.chunk_pregen.retrogen_selector.header");
    PregenCheckBox.CheckboxState showMods = new PregenCheckBox.CheckboxState(true, true, TextUtil.translate("gui.chunk_pregen.retrogen_selector.show_mods"));
    PregenTreeList.TreeState<RetrogenNode> selectors = new PregenTreeList.TreeState<RetrogenNode>(this.createNode()).setRowWidth(350);
    PregenText.TextState search = new PregenText.TextState("").setCallback(this.selectors::search);
    PregenCheckBox.CheckboxState showFrame = new PregenCheckBox.CheckboxState(true, false, TextUtil.translate("gui.chunk_pregen.retrogen_selector.show_frame")).withStateListener(this.selectors::setFrame);
    GuiScreen parent;

    public RetrogenScreen(GuiScreen parent) {
        this.parent = parent;
        this.sendToServer(new RetrogenPacket.Request());
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.tree(this.field_146294_l, this.field_146295_m, 50, this.field_146295_m - 36, this.selectors);
        this.text(-80, 21, 160, 18, Align.CENTER, Align.START, this.search);
        this.checkbox(85, 15, 14, 14, Align.CENTER, Align.START, this.showMods);
        this.checkbox(85, 30, 14, 14, Align.CENTER, Align.START, this.showFrame);
        this.button(-60, -28, 120, 20, Align.CENTER, Align.END, TextUtil.translate("gui.chunk_pregen.retrogen_selector.back"), T -> this.onClose());
    }

    @Override
    public void onClose() {
        this.displayGuiScreen(this.parent);
    }

    @Override
    public void renderForeground(int mouseX, int mouseY, float partialTicks) {
        this.drawText(this.header, 0.0f, -this.centerY + 6, Align.CENTER, -1);
    }

    public List<RetrogenNode> createNode() {
        ArrayList<RetrogenNode> nodes = new ArrayList<RetrogenNode>();
        List<String> mods = RetrogenManager.INSTANCE.getKnownMods();
        mods.sort(String.CASE_INSENSITIVE_ORDER);
        for (String mod : mods) {
            ModNode modNode = new ModNode(mod);
            for (String name : RetrogenManager.INSTANCE.getGeneratorsForMod(mod)) {
                modNode.addChildNode(new FeatureNode(mod, name, this.showMods));
            }
            nodes.add(modNode);
        }
        return nodes;
    }

    private static enum State {
        ENABLED,
        DISABLED,
        UNKNOWN;

    }

    public class ModNode
    extends RetrogenNode {
        ITextComponent text;

        public ModNode(String modId) {
            this.text = TextUtil.applyTextStyle(TextUtil.getModName(modId), TextFormatting.GOLD);
        }

        @Override
        public void render(int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            super.render(x, top, left, width, height, mouseX, mouseY, selected, partialTicks);
            RetrogenScreen.this.drawUnalignedText(this.text, left + 20, top + height / 2 - this.fontRenderer.field_78288_b / 2, Align.START, -1);
        }

        @Override
        public int getItemHeight() {
            return 16;
        }
    }

    public class CategoryNode
    extends RetrogenNode {
        ITextComponent text;
        ITextComponent modId;
        PregenCheckBox.CheckboxState showMods;

        public CategoryNode(String category, String mod, PregenCheckBox.CheckboxState showMods) {
            this.text = TextUtil.applyTextStyle(TextUtil.literalPascal(category), TextFormatting.GOLD);
            this.modId = TextUtil.applyTextStyle(TextUtil.getModName(mod), TextFormatting.GRAY, TextFormatting.ITALIC);
            this.showMods = showMods;
        }

        @Override
        public void render(int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            super.render(x, top, left, width, height, mouseX, mouseY, selected, partialTicks);
            if (this.showMods.isChecked()) {
                RetrogenScreen.this.drawUnalignedText(this.text, left + 20, top + height / 3 - this.fontRenderer.field_78288_b / 2 - 1, Align.START, -1);
                RetrogenScreen.this.drawUnalignedText(this.modId, left + 20, top + height / 3 + this.fontRenderer.field_78288_b / 2 + 1, Align.START, -1);
            } else {
                RetrogenScreen.this.drawUnalignedText(this.text, left + 20, top + height / 2 - this.fontRenderer.field_78288_b / 2, Align.START, -1);
            }
        }

        @Override
        public int getItemHeight() {
            return this.showMods.isChecked() ? 24 : 16;
        }
    }

    public class FeatureNode
    extends RetrogenNode {
        String id;
        ITextComponent text;
        ITextComponent modId;
        PregenCheckBox.CheckboxState showMods;

        public FeatureNode(String modId, String id, PregenCheckBox.CheckboxState showMods) {
            this.id = id;
            this.text = TextUtil.applyTextStyle(TextUtil.literal(id), TextFormatting.GOLD);
            this.modId = TextUtil.applyTextStyle(TextUtil.getModName(modId), TextFormatting.GRAY, TextFormatting.ITALIC);
            this.showMods = showMods;
        }

        @Override
        public void render(int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            super.render(x, top, left, width, height, mouseX, mouseY, selected, partialTicks);
            if (this.showMods.isChecked()) {
                RetrogenScreen.this.drawUnalignedText(this.text, left + 20, top + height / 3 - this.fontRenderer.field_78288_b / 2 - 1, Align.START, -1);
                RetrogenScreen.this.drawUnalignedText(this.modId, left + 20, top + height / 3 + this.fontRenderer.field_78288_b / 2 + 1, Align.START, -1);
            } else {
                RetrogenScreen.this.drawUnalignedText(this.text, left + 20, top + height / 2 - this.fontRenderer.field_78288_b / 2, Align.START, -1);
            }
        }

        @Override
        public int getItemHeight() {
            return this.showMods.isChecked() ? 24 : 16;
        }

        @Override
        protected boolean containsSearch(String searchString) {
            return this.searchIds(searchString, this.id);
        }

        @Override
        protected State getState() {
            return RetrogenManager.INSTANCE.isActive(this.id) ? State.ENABLED : State.DISABLED;
        }

        @Override
        protected void setState(boolean value) {
            RetrogenManager.INSTANCE.toggleClient(this.id, value);
            ChunkPregenerator.NETWORKING.sendToServer(new RetrogenPacket.Change(this.id, value));
        }
    }

    public static abstract class RetrogenNode
    extends PregenTreeList.TreeEntry<RetrogenNode> {
        PregenButton enable = this.addChild(new PregenButton(0, 0, 50, 14, TextUtil.translate("gui.chunk_pregen.retrogen_selector.enable"), T -> this.setState(true)));
        PregenButton disable = this.addChild(new PregenButton(0, 0, 50, 14, TextUtil.translate("gui.chunk_pregen.retrogen_selector.disable"), T -> this.setState(false)));

        protected State getState() {
            int state = 0;
            for (RetrogenNode node : this.childNodes()) {
                state |= 1 << node.getState().ordinal();
            }
            if ((state & 4) != 0) {
                return State.UNKNOWN;
            }
            int value = state & 3;
            if (value == 3) {
                return State.UNKNOWN;
            }
            return value == 1 ? State.ENABLED : State.DISABLED;
        }

        protected void setState(boolean value) {
            this.childNodes().forEach(T -> T.setState(value));
        }

        @Override
        protected boolean containsSearch(String searchString) {
            return false;
        }

        @Override
        public void render(int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            super.render(x, top, left, width, height, mouseX, mouseY, selected, partialTicks);
            Minecraft mc = Minecraft.func_71410_x();
            State state = this.getState();
            this.enable.setActive(state != State.ENABLED);
            this.enable.field_146128_h = left + width - (this.enable.getWidgetWidth() + this.disable.getWidgetWidth() + 4);
            this.enable.field_146129_i = top + height / 2 - this.enable.getWidgetHeight() / 2;
            this.enable.render(mc, mouseX, mouseY, partialTicks);
            this.disable.setActive(state != State.DISABLED);
            this.disable.field_146128_h = left + width - this.disable.getWidgetWidth() - 3;
            this.disable.field_146129_i = top + height / 2 - this.disable.getWidgetHeight() / 2;
            this.disable.render(mc, mouseX, mouseY, partialTicks);
        }
    }
}

