/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.gui;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import pregenerator.base.api.Align;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.gui.BasePregenScreen;
import pregenerator.base.impl.gui.comp.CycleButton;
import pregenerator.base.impl.gui.comp.PregenButton;
import pregenerator.base.impl.gui.comp.PregenCheckBox;
import pregenerator.base.impl.gui.comp.PregenText;
import pregenerator.base.impl.gui.comp.PregenTreeList;
import pregenerator.impl.client.utils.StructureIcons;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.network.ChunkPacket;
import pregenerator.impl.network.StructurePacket;
import pregenerator.impl.structure.StructureData;

public class StructureScreen
extends BasePregenScreen {
    GuiScreen owner;
    PregenTreeList.TreeState<StructureEntry> elements = new PregenTreeList.TreeState(48).setRowWidth(330).setTopPadding(65).setBottomPadding(35).setFrame(true);
    CycleButton.CycleState<Integer> dimensions = new CycleButton.CycleState<Integer>(Integer.valueOf(0), TextUtil::dimension, this.dimensions());
    PregenText.TextState search = new PregenText.TextState("").setCallback(this.elements::search);
    PregenCheckBox.CheckboxState showFrame = new PregenCheckBox.CheckboxState(true, true, TextUtil.translate("gui.chunk_pregen.retrogen_selector.show_frame")).withStateListener(this.elements::setFrame);

    public StructureScreen(GuiScreen owner) {
        this.updateDimension();
        this.owner = owner;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.tree(this.elements);
        this.text(-96, 43, 188, 14, Align.CENTER, Align.START, this.search);
        this.cycleButton(-97, 24, 94, 16, Align.CENTER, Align.START, this.dimensions, (CycleButton<T> T) -> this.updateDimension()).withSelectScreen().setTooltip(this::getDimensionTooltip);
        this.button(-1, 24, 94, 16, Align.CENTER, Align.START, TextUtil.translate("gui.chunk_pregen.structure_screen.refresh"), T -> this.updateDimension());
        this.checkbox(96, 25, 14, 14, Align.CENTER, Align.START, this.showFrame);
        this.button(-60, -28, 120, 20, Align.CENTER, Align.END, TextUtil.translate("gui.chunk_pregen.retrogen_selector.back"), T -> this.onClose());
    }

    @Override
    protected void onClose() {
        this.displayGuiScreen(this.owner);
    }

    public void updateDimension() {
        this.sendToServer(new StructurePacket.Request(this.dimensions.getValue()));
    }

    public void acceptData(int dimension, List<StructureData> data) {
        LinkedHashMap<String, List> mappedData = new LinkedHashMap<String, List>();
        for (StructureData entry : data) {
            mappedData.computeIfAbsent(entry.getType(), T -> new ArrayList()).add(entry);
        }
        ArrayList<CategoryEntry> result = new ArrayList<CategoryEntry>();
        for (Map.Entry entry : mappedData.entrySet()) {
            CategoryEntry category = new CategoryEntry((String)entry.getKey());
            for (StructureData sData : (List)entry.getValue()) {
                category.addChildNode(new StructureSubEntry(this.dimensions.getValue(), sData));
            }
            result.add(category);
        }
        this.elements.replaceNodes(result);
    }

    private ITextComponent getDimensionTooltip(CycleButton<Integer> button) {
        ITextComponent base = TextUtil.empty();
        base.func_150257_a(TextUtil.translateStyled("gui.chunk_pregen.taskgenerator.tooltip.dimension", TextFormatting.GOLD));
        return base;
    }

    public double getDistance(StructureData start) {
        EntityPlayerSP player = this.field_146297_k.field_71439_g;
        double d0 = player.field_70165_t - (double)((float)start.getX() + 0.5f);
        double d2 = player.field_70161_v - (double)((float)start.getZ() + 0.5f);
        return Math.sqrt(d0 * d0 + d2 * d2);
    }

    public class StructureSubEntry
    extends StructureEntry {
        int dimension;
        StructureData start;
        String type;
        ITextComponent text;
        ITextComponent xPos;
        ITextComponent zPos;
        ITextComponent size;
        PregenButton remove;
        PregenButton tp;

        public StructureSubEntry(int dimension, StructureData start) {
            super(start.getType());
            this.remove = this.addChild(new PregenButton(0, 0, 50, 12, TextUtil.translate("gui.chunk_pregen.structure_screen.button.remove"), this::remove).setTooltip(TextUtil.translate("gui.chunk_pregen.structure_screen.delete")));
            this.tp = this.addChild(new PregenButton(0, 0, 23, 12, TextUtil.translate("gui.chunk_pregen.structure_screen.button.tp"), this::tp));
            this.dimension = dimension;
            this.start = start;
            this.xPos = TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.structure_screen.x", TextUtil.NUMBERS.format(start.getX())), TextFormatting.YELLOW);
            this.zPos = TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.structure_screen.z", TextUtil.NUMBERS.format(start.getZ())), TextFormatting.YELLOW);
            this.size = TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.structure_screen.elements", TextUtil.NUMBERS.format(start.getParts())), TextFormatting.LIGHT_PURPLE);
        }

        @Override
        public StructureData getData() {
            return this.start;
        }

        @Override
        public void render(int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            super.render(x, top, left, width, height, mouseX, mouseY, selected, partialTicks);
            TextureAtlasSprite sprite = StructureIcons.INSTANCE.getSprite(this.start.getType().toLowerCase(Locale.ROOT));
            StructureScreen.this.drawUnalignedText(this.xPos, left + 2, top + 14, Align.START, -1);
            StructureScreen.this.drawUnalignedText(this.zPos, left + 2, top + 24, Align.START, -1);
            StructureScreen.this.drawUnalignedText(TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.structure_screen.dist", TextUtil.NUMBERS.format(this.getDistance())), TextFormatting.AQUA), left + 2, top + 34, Align.START, -1);
            StructureScreen.this.drawUnalignedText(this.size, left + 2, top + 44, Align.START, -1);
            this.mc.func_110434_K().func_110577_a(StructureIcons.INSTANCE.getTexture());
            StructureScreen.this.func_175175_a(left + width / 2 - 6, top, sprite, 12, 12);
            this.remove.field_146128_h = left + 1;
            this.remove.field_146129_i = top + 52;
            this.remove.render(this.mc, mouseX, mouseY, partialTicks);
            this.tp.field_146128_h = left + 51;
            this.tp.field_146129_i = top + 52;
            this.tp.render(this.mc, mouseX, mouseY, partialTicks);
        }

        private void tp(GuiButton button) {
            StructureScreen.this.sendToServer(new ChunkPacket.TPAction(this.dimension, FilePos.asLong(this.start.getX() >> 4, this.start.getZ() >> 4)));
        }

        private void remove(GuiButton button) {
            StructureScreen.this.sendToServer(new StructurePacket.Delete(this.dimension, GuiScreen.func_146272_n(), this.start));
        }

        public double getDistance() {
            EntityPlayerSP player = this.mc.field_71439_g;
            double d0 = player.field_70165_t - (double)((float)this.start.getX() + 0.5f);
            double d2 = player.field_70161_v - (double)((float)this.start.getZ() + 0.5f);
            return Math.sqrt(d0 * d0 + d2 * d2);
        }

        @Override
        public int getItemHeight() {
            return 70;
        }
    }

    public class CategoryEntry
    extends StructureEntry {
        String name;
        ITextComponent structure;

        public CategoryEntry(String name) {
            this.name = name;
            this.structure = TextUtil.literal(name);
        }

        @Override
        public void render(int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            super.render(x, top, left, width, height, mouseX, mouseY, selected, partialTicks);
            TextureAtlasSprite sprite = StructureIcons.INSTANCE.getSprite(this.name.toLowerCase(Locale.ROOT));
            this.mc.func_110434_K().func_110577_a(StructureIcons.INSTANCE.getTexture());
            StructureScreen.this.func_175175_a(left + 20, top + height / 2 - 8, sprite, 16, 16);
            StructureScreen.this.drawUnalignedText(this.structure, left + 40, top + height / 2 - this.fontRenderer.field_78288_b / 2, Align.START, -1);
        }

        @Override
        protected boolean areGridChildren() {
            return true;
        }

        @Override
        protected int getGridWidth() {
            return 75;
        }

        @Override
        public int getItemHeight() {
            return 16;
        }
    }

    public class StructureEntry
    extends PregenTreeList.TreeEntry<StructureEntry> {
        String name;

        public StructureEntry() {
        }

        public StructureEntry(String name) {
            this.name = name;
        }

        public StructureData getData() {
            return null;
        }

        @Override
        protected boolean containsSearch(String searchString) {
            return this.name != null && this.searchIds(searchString, this.name.toLowerCase(Locale.ROOT));
        }
    }
}

