/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.info;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import pregenerator.base.api.Align;
import pregenerator.base.api.TextUtil;
import pregenerator.base.api.misc.IRenderHelper;
import pregenerator.base.impl.gui.base.IWidget;

public interface IRenderObj {
    public float height();

    @SideOnly(value=Side.CLIENT)
    public void render(IRenderHelper var1, float var2, float var3, float var4, float var5);

    public boolean onClick(int var1, int var2);

    public static IRenderObj text(String text) {
        return IRenderObj.text(TextUtil.translate(text));
    }

    public static IRenderObj text(String text, Align align) {
        return IRenderObj.text(TextUtil.translate(text), align);
    }

    public static IRenderObj text(String text, Object ... args) {
        return IRenderObj.text(TextUtil.translate(text, args));
    }

    public static IRenderObj text(ITextComponent text) {
        return new Text(text, Align.START);
    }

    public static IRenderObj text(ITextComponent text, Align align) {
        return new Text(text, align);
    }

    public static IRenderObj text(ITextComponent text, Align align, float height) {
        return new Text(text, align, height);
    }

    public static IRenderObj bar(String text, float progress) {
        return IRenderObj.bar(TextUtil.translate(text), progress);
    }

    public static IRenderObj bar(String text, Object first, float progress) {
        return IRenderObj.bar(TextUtil.translate(text, first), progress);
    }

    public static IRenderObj bar(String text, Object first, Object second, float progress) {
        return IRenderObj.bar(TextUtil.translate(text, first, second), progress);
    }

    public static IRenderObj bar(String text, Object first, Object second, Object third, float progress) {
        return IRenderObj.bar(TextUtil.translate(text, first, second, third), progress);
    }

    public static IRenderObj bar(ITextComponent text, float progress) {
        return new Bar(text, progress);
    }

    public static IRenderObj bar(ITextComponent text, float progress, float height) {
        return new Bar(text, progress, height);
    }

    public static IRenderObj padding(float height) {
        return new Padding(height);
    }

    public static float height(Iterable<IRenderObj> elements) {
        float totalHeight = 0.0f;
        for (IRenderObj obj : elements) {
            totalHeight += obj.height();
        }
        return totalHeight;
    }

    public static abstract class Interactable
    implements IRenderObj {
        private static final float SCALE = 2.0f;
        List<IWidget> interactables = new ObjectArrayList();

        protected <T extends IWidget> T addChild(T listener) {
            this.interactables.add(listener);
            return listener;
        }

        @Override
        public void render(IRenderHelper helper, float x, float y, float width, float scale) {
            float invScale = 1.0f / (scale *= 0.5f);
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution res = new ScaledResolution(mc);
            int mouseX = (int)((double)Mouse.getX() * (double)res.func_78326_a() / (double)mc.field_71443_c * (double)invScale);
            int mouseY = (int)((double)(mc.field_71440_d - Mouse.getY()) * (double)res.func_78328_b() / (double)mc.field_71440_d * (double)invScale);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            this.setupInteractables(x, y, width, scale, 2.0f);
            int m = this.interactables.size();
            for (int i = 0; i < m; ++i) {
                this.interactables.get(i).render(mc, mouseX, mouseY, 0.0f);
            }
            GlStateManager.func_179121_F();
        }

        @Override
        public boolean onClick(int mouseX, int mouseY) {
            mouseX = (int)((float)mouseX * 2.0f);
            mouseY = (int)((float)mouseY * 2.0f);
            int m = this.interactables.size();
            for (int i = 0; i < m; ++i) {
                if (!this.interactables.get(i).mouseClick(mouseX, mouseY, 0)) continue;
                return true;
            }
            return false;
        }

        public abstract void setupInteractables(float var1, float var2, float var3, float var4, float var5);
    }

    public static class Padding
    implements IRenderObj {
        float height;

        public Padding(float height) {
            this.height = height;
        }

        @Override
        public float height() {
            return this.height;
        }

        @Override
        public void render(IRenderHelper helper, float x, float y, float width, float scale) {
        }

        @Override
        public boolean onClick(int mouseX, int mouseY) {
            return false;
        }
    }

    public static class Bar
    implements IRenderObj {
        ITextComponent text;
        float progress;
        float height;

        public Bar(ITextComponent text, float progress) {
            this(text, progress, 6.0f);
        }

        public Bar(ITextComponent text, float progress, float height) {
            this.text = text;
            this.progress = progress;
            this.height = height;
        }

        @Override
        public float height() {
            return this.height;
        }

        @Override
        public void render(IRenderHelper helper, float x, float y, float width, float scale) {
            helper.drawProgressBar(x, y, width, this.height, this.progress, this.text);
        }

        @Override
        public boolean onClick(int mouseX, int mouseY) {
            return false;
        }
    }

    public static class Text
    implements IRenderObj {
        ITextComponent text;
        Align align;
        float height;

        public Text(ITextComponent text, Align align) {
            this(text, align, 5.0f);
        }

        public Text(ITextComponent text, Align align, float height) {
            this.text = text;
            this.align = align;
            this.height = height;
        }

        @Override
        public float height() {
            return this.height;
        }

        @Override
        public void render(IRenderHelper helper, float x, float y, float width, float scale) {
            helper.drawText(x, y, this.align, this.text);
        }

        @Override
        public boolean onClick(int mouseX, int mouseY) {
            return false;
        }
    }
}

