/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.info;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pregenerator.PregenConfig;
import pregenerator.base.api.Align;
import pregenerator.base.api.TextUtil;
import pregenerator.base.api.misc.IRenderHelper;
import pregenerator.base.impl.gui.comp.PregenButton;
import pregenerator.impl.client.info.IProcessorInfo;
import pregenerator.impl.client.info.IRenderObj;

public class TrackerInfo
implements IProcessorInfo {
    List<IRenderObj> objects = new ObjectArrayList();
    boolean minimized = false;
    float height = 0.0f;

    public void clear() {
        this.objects.clear();
    }

    @Override
    public void read(PacketBuffer buffer) {
        this.objects.clear();
        long averageServerLag = buffer.func_179260_f();
        this.objects.add(new Menu());
        this.objects.add(IRenderObj.text("ui.chunk_pregen.tracker.header", Align.CENTER));
        float ms = (float)averageServerLag / 1000000.0f;
        this.objects.add(IRenderObj.bar("ui.chunk_pregen.tracker.lag", FLOATING_NUMBERS.format(ms), NUMBERS.format((float)averageServerLag / 1000.0f), MathHelper.func_76131_a((float)ms, (float)0.0f, (float)50.0f) / 50.0f));
        float tps = Math.min(20.0f, 20.0f / (ms / 50.0f));
        this.objects.add(IRenderObj.bar("ui.chunk_pregen.tracker.tps", FLOATING_NUMBERS.format(tps), tps / 20.0f));
        long totalMemory = buffer.readLong();
        long maxMemory = buffer.readLong();
        long freeMemory = buffer.readLong();
        this.objects.add(IRenderObj.bar("ui.chunk_pregen.tracker.ram", NUMBERS.format(totalMemory - freeMemory >> 20), NUMBERS.format(maxMemory >> 20), maxMemory <= 0L ? 0.0f : (float)(totalMemory - freeMemory) / (float)maxMemory));
        if (!this.minimized) {
            this.objects.add(IRenderObj.padding(1.0f));
            int averagePackets = buffer.func_150792_a();
            int exactPackets = buffer.func_150792_a();
            this.objects.add(IRenderObj.text("ui.chunk_pregen.tracker.packets", NUMBERS.format(exactPackets), NUMBERS.format(averagePackets)));
            int size = buffer.func_150792_a();
            for (int i = 0; i < size; ++i) {
                int dim = buffer.readInt();
                long time = buffer.func_179260_f();
                ms = (float)time / 1000000.0f;
                this.objects.add(IRenderObj.bar("ui.chunk_pregen.tracker.dimension_lag", TextUtil.dimension(dim), FLOATING_NUMBERS.format(ms), NUMBERS.format((float)time / 1000.0f), MathHelper.func_76131_a((float)ms, (float)0.0f, (float)50.0f) / 50.0f));
            }
            if (buffer.readBoolean()) {
                this.objects.add(IRenderObj.padding(2.0f));
                this.objects.add(IRenderObj.text("ui.chunk_pregen.tracker.detail", Align.CENTER));
                this.objects.add(IRenderObj.text(TextUtil.dimension(buffer.readInt()), Align.CENTER));
                long time = buffer.func_179260_f();
                ms = (float)time / 1000000.0f;
                this.objects.add(IRenderObj.bar("ui.chunk_pregen.tracker.avg_lag", FLOATING_NUMBERS.format(ms), NUMBERS.format((float)time / 1000.0f), MathHelper.func_76131_a((float)ms, (float)0.0f, (float)50.0f) / 50.0f));
                time = buffer.func_179260_f();
                ms = (float)time / 1000000.0f;
                this.objects.add(IRenderObj.bar("ui.chunk_pregen.tracker.exact_lag", FLOATING_NUMBERS.format(ms), NUMBERS.format((float)time / 1000.0f), MathHelper.func_76131_a((float)ms, (float)0.0f, (float)50.0f) / 50.0f));
                this.objects.add(IRenderObj.padding(1.0f));
                this.objects.add(IRenderObj.text("ui.chunk_pregen.tracker.chunks", NUMBERS.format(buffer.func_150792_a())));
                this.objects.add(IRenderObj.text("ui.chunk_pregen.tracker.tiles", NUMBERS.format(buffer.func_150792_a()), NUMBERS.format(buffer.func_150792_a())));
                this.objects.add(IRenderObj.text("ui.chunk_pregen.tracker.entities", NUMBERS.format(buffer.func_150792_a())));
                this.objects.add(IRenderObj.text("ui.chunk_pregen.tracker.block_updates", NUMBERS.format(buffer.func_150792_a()), NUMBERS.format(buffer.func_150792_a())));
                int exactTicks = buffer.func_150792_a();
                this.objects.add(IRenderObj.bar("ui.chunk_pregen.tracker.block_queue", NUMBERS.format(exactTicks), NUMBERS.format(buffer.func_150792_a()), (float)exactTicks / 65536.0f));
            }
        }
        this.height = IRenderObj.height(this.objects);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(IRenderHelper helper, int x, int y, float scale) {
        helper.setupCanvasSize(100.0f);
        helper.drawArea(x, y, 100.0f, this.height - 2.0f);
        float yOffset = 3.0f;
        for (IRenderObj obj : this.objects) {
            obj.render(helper, x + 4, (float)y + yOffset, 100.0f, scale);
            yOffset += obj.height();
        }
    }

    @Override
    public boolean onClick(int mouseX, int mouseY) {
        for (IRenderObj obj : this.objects) {
            if (!obj.onClick(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getWidth() {
        return 109;
    }

    @Override
    public int getHeight() {
        return (int)this.height + 6;
    }

    @Override
    public int getID() {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public class Menu
    extends IRenderObj.Interactable {
        PregenButton close = this.addChild(new PregenButton(0, 0, 12, 12, TextUtil.literal("X"), this::onClose));
        PregenButton minimize = this.addChild(new PregenButton(0, 0, 12, 12, TextUtil.literal("_"), this::onMinimize));

        @Override
        public float height() {
            return 0.0f;
        }

        private void onClose(GuiButton button) {
            PregenConfig.INSTANCE.trackerOverlay.setEnabled(false);
            PregenConfig.INSTANCE.save();
        }

        private void onMinimize(GuiButton button) {
            TrackerInfo.this.minimized = !TrackerInfo.this.minimized;
        }

        @Override
        public void setupInteractables(float x, float y, float width, float scale, float posScale) {
            this.close.field_146128_h = (int)((x + width - 3.0f) * posScale) - (int)((float)this.close.getWidgetWidth() * scale);
            this.close.field_146129_i = (int)((y - 1.0f) * posScale);
            this.minimize.field_146128_h = (int)((x + width - 9.0f) * posScale) - (int)((float)this.close.getWidgetWidth() * scale);
            this.minimize.field_146129_i = (int)((y - 1.0f) * posScale);
        }
    }
}

