/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview;

import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.awt.Color;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import org.lwjgl.input.Keyboard;
import pregenerator.PregenConfig;
import pregenerator.base.api.Align;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.gui.BasePregenScreen;
import pregenerator.base.impl.gui.comp.CycleButton;
import pregenerator.base.impl.gui.comp.PregenButton;
import pregenerator.base.impl.gui.comp.PregenSlider;
import pregenerator.base.impl.gui.comp.PregenText;
import pregenerator.base.impl.misc.PregenEvent;
import pregenerator.impl.client.preview.ScreenshotScreen;
import pregenerator.impl.client.preview.data.IFileProvider;
import pregenerator.impl.client.preview.data.MapManager;
import pregenerator.impl.client.preview.data.tasks.CreateScreenshotTask;
import pregenerator.impl.client.preview.texture.MoveableTexture;
import pregenerator.impl.client.preview.world.ChunkCache;
import pregenerator.impl.client.preview.world.CustomServer;
import pregenerator.impl.client.preview.world.WorldData;
import pregenerator.impl.client.preview.world.WorldSeed;
import pregenerator.impl.client.preview.world.data.IChunkData;
import pregenerator.impl.client.utils.BiomeColors;
import pregenerator.impl.client.utils.StructureIcons;
import pregenerator.impl.commands.BaseCommands;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.misc.GenShape;
import pregenerator.impl.processor.IBaseTask;
import pregenerator.impl.processor.ServerManager;
import pregenerator.impl.processor.TaskActions;
import pregenerator.impl.processor.generator.GenerationType;
import pregenerator.impl.processor.generator.tasks.ITask;

public class PreviewScreen
extends BasePregenScreen {
    public static final int SLIME_COLOR = -2147418113;
    public static final int PROGRESS_COLOR = Integer.MIN_VALUE;
    ThreadPoolExecutor screenShotService = (ThreadPoolExecutor)Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    ExecutorService processor = Executors.newFixedThreadPool(1);
    CustomServer server = null;
    WorldSeed seed;
    Map<Integer, WorldData> genData = new ConcurrentHashMap<Integer, WorldData>();
    PregenText.TextState seedText = new PregenText.TextState("");
    CycleButton.CycleState<Integer> dimension = new CycleButton.CycleState<Integer>(Integer.valueOf(0), this::getDimensionName, DimensionManager.getStaticDimensionIDs());
    PregenButton randomizeSeed;
    PregenButton applySeed;
    PregenSlider.SliderState radius = new PregenSlider.SliderState(100, 1, 1000, TextUtil.translate("gui.chunk_pregen.preview.radius.prefix"), TextUtil.translate("gui.chunk_pregen.preview.radius.suffix"));
    PregenButton decreaseOnceRadius;
    PregenButton increaseOnceRadius;
    PregenButton applySize;
    CycleButton.CycleState<GenShape> shape = new CycleButton.CycleState<GenShape>(GenShape.SQUARE, this::getShapeName, GenShape.values());
    CycleButton.CycleState<Boolean> genMode = new CycleButton.CycleState<Boolean>(Boolean.valueOf(true), this::getGenMode, false, true);
    PregenSlider.SliderState speed;
    PregenButton decreaseOnceSpeed;
    PregenButton increaseOnceSpeed;
    CycleButton.CycleState<Boolean> priority;
    CycleButton.CycleState<Integer> views;
    CycleButton.CycleState<Integer> progressView;
    CycleButton.CycleState<Boolean> slimeChunks;
    CycleButton.CycleState<Boolean> structures;
    PregenButton start;
    PregenButton stop;
    PregenButton screenshot;
    PregenButton back;
    PregenButton keep;
    boolean closing;
    int oldScale;
    float scale;
    ChunkPos pos;
    MoveableTexture renderTexture;
    MapManager mapData;
    Set<String> spammyStructure;

    public PreviewScreen(GuiCreateWorld original) {
        this.speed = new PregenSlider.SliderState(PregenConfig.INSTANCE.timePerTick.get(), 1, 1000, TextUtil.translate("gui.chunk_pregen.preview.speed.prefix"), TextUtil.translate("gui.chunk_pregen.preview.speed.suffix")).setListener(T -> PregenConfig.INSTANCE.timePerTick.set(T.getState().get()));
        this.priority = new CycleButton.CycleState<Boolean>(Boolean.valueOf(PregenConfig.INSTANCE.priority.get() == BaseCommands.Priority.PREGENERATOR), TextUtil.translate("gui.chunk_pregen.preview.priority"), false, true);
        this.views = new CycleButton.CycleState<Integer>(Integer.valueOf(0), this::getViewName, 0, 1, 2);
        this.progressView = new CycleButton.CycleState<Integer>(Integer.valueOf(0), TextUtil.translate("gui.chunk_pregen.preview.progress"), 0, Integer.MIN_VALUE);
        this.slimeChunks = new CycleButton.CycleState<Boolean>(Boolean.valueOf(false), TextUtil.translate("gui.chunk_pregen.preview.slime_chunks"), false, true);
        this.structures = new CycleButton.CycleState<Boolean>(Boolean.valueOf(false), TextUtil.translate("gui.chunk_pregen.preview.structures"), false, true);
        this.closing = false;
        this.scale = 0.2f;
        this.pos = null;
        this.renderTexture = new MoveableTexture(3200);
        this.mapData = new MapManager();
        this.spammyStructure = new ObjectOpenHashSet();
        this.seed = new WorldSeed(original);
        this.screenShotService.setKeepAliveTime(1L, TimeUnit.MILLISECONDS);
        this.screenShotService.allowCoreThreadTimeOut(true);
        WorldSeed.removeFile(WorldSeed.getPreviewFolder().toFile(), true);
        this.seedText.setValue(this.seed.getTextSeed());
        this.oldScale = this.getSettings().field_74335_Z;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.text(30, 30, 160, 10, this.seedText);
        this.randomizeSeed = this.button(29, 42, 80, 14, TextUtil.translate("gui.chunk_pregen.preview.randomize"), T -> this.seedText.setValue(Long.toString(new Random().nextLong())));
        this.applySeed = this.button(111, 42, 80, 14, TextUtil.translate("gui.chunk_pregen.preview.apply_seed"), this::setSeed);
        this.slider(44, 70, 132, 14, this.radius).setTooltip(this::getSliderTooltip);
        this.decreaseOnceRadius = this.button(29, 70, 14, 14, TextUtil.literal("<"), T -> this.radius.decreaseOnce());
        this.increaseOnceRadius = this.button(177, 70, 14, 14, TextUtil.literal(">"), T -> this.radius.increaseOnce());
        this.applySize = this.button(29, 86, 70, 14, TextUtil.translate("gui.chunk_pregen.preview.apply_size"), this::resizeTexture);
        this.cycleButton(101, 86, 90, 14, this.shape, this::setShape);
        this.cycleButton(29, 101, 162, 14, this.dimension, this::setDimension).withSelectScreen();
        this.start = this.button(29, 116, 80, 14, TextUtil.translate("gui.chunk_pregen.preview.start"), this::start);
        this.stop = this.button(111, 116, 80, 14, TextUtil.translate("gui.chunk_pregen.preview.stop"), this::stop);
        this.cycleButton(29, 143, 162, 14, this.views, this::setView);
        this.cycleButton(29, 158, 80, 14, this.slimeChunks, null).setTooltip(this.createTooltip(TextUtil.translate("gui.chunk_pregen.biome_preview.tooltip.slime_chunks")));
        this.cycleButton(111, 158, 80, 14, this.structures, null).setTooltip(this.createTooltip(TextUtil.translate("gui.chunk_pregen.biome_preview.tooltip.structures")));
        this.cycleButton(29, 173, 80, 14, this.progressView, this::toggleProgress).setTooltip(this.createViewTooltip(TextUtil.translate("gui.chunk_pregen.preview.tooltip.progress")));
        this.screenshot = this.button(111, 173, 80, 14, TextUtil.translate("gui.chunk_pregen.preview.screenshot"), this::createScreenshot).setTooltip(TextUtil.translate("gui.chunk_pregen.preview.tooltip.screenshot"));
        this.slider(44, 201, 132, 14, this.speed).setTooltip(this::getSpeedTooltip);
        this.decreaseOnceSpeed = this.button(29, 201, 14, 14, TextUtil.literal("<"), T -> this.speed.decreaseOnce());
        this.increaseOnceSpeed = this.button(177, 201, 14, 14, TextUtil.literal(">"), T -> this.speed.increaseOnce());
        this.cycleButton(29, 216, 80, 14, this.priority, T -> PregenConfig.INSTANCE.priority.set((Boolean)T.getValue() != false ? BaseCommands.Priority.PREGENERATOR : BaseCommands.Priority.GAME)).setTooltip(this.createTooltip(TextUtil.translate("gui.chunk_pregen.preview.tooltip.priority")));
        this.cycleButton(111, 216, 80, 14, this.genMode, this.emptyAction());
        this.back = this.button(29, -29, 80, 14, Align.START, Align.END, TextUtil.translate("gui.chunk_pregen.preview.back"), this::back);
        this.keep = this.button(111, -29, 80, 14, Align.START, Align.END, TextUtil.translate("gui.chunk_pregen.preview.keep_world"), this::keepWorld);
        this.button(-228, 16, 20, 13, Align.END, Align.START, TextUtil.translate("gui.chunk_pregen.preview.gc"), T -> System.gc());
        if (!PregenConfig.INSTANCE.ignoreScale.get()) {
            this.ensureScale();
        }
    }

    private void ensureScale() {
        int number;
        for (number = 0; number < 20 && this.field_146297_k.field_71443_c / (number + 1) >= 320 && this.field_146297_k.field_71440_d / (number + 1) >= 270; ++number) {
        }
        GameSettings setting = this.getSettings();
        if ((number == 0 || this.field_146297_k.field_71440_d / number >= 270) && number != setting.field_74335_Z) {
            setting.field_74335_Z = number;
            this.displayGuiScreen(this);
        }
    }

    @Override
    public void tick() {
        super.tick();
        ServerManager manager = ServerManager.INSTANCE;
        boolean globalRunning = manager.isRunning();
        IBaseTask task = manager.getActiveTask();
        boolean dimensionRunning = task != null && task.getDimension() == this.getDimension();
        boolean serverRunning = this.server != null && this.server.func_71200_ad() && !this.closing;
        this.randomizeSeed.field_146124_l = !globalRunning;
        this.applySeed.field_146124_l = !globalRunning && WorldSeed.makeSeed(this.seedText.getValue()) != this.seed.getSeed();
        this.seedText.getOwner().func_146184_c(!globalRunning);
        this.radius.getOwner().field_146124_l = !dimensionRunning;
        this.decreaseOnceRadius.field_146124_l = !dimensionRunning && this.radius.get() > 1;
        this.increaseOnceRadius.field_146124_l = !dimensionRunning && this.radius.get() < 1000;
        this.applySize.field_146124_l = !dimensionRunning && this.renderTexture.getWidth() != this.radius.get() * 32;
        this.shape.getOwner().field_146124_l = !dimensionRunning;
        this.dimension.getOwner().field_146124_l = serverRunning;
        this.start.field_146124_l = !globalRunning && serverRunning;
        this.stop.field_146124_l = dimensionRunning && serverRunning;
        this.genMode.getOwner().field_146124_l = !globalRunning;
        this.keep.field_146124_l = !globalRunning && this.screenShotService.getActiveCount() <= 0 && !this.closing;
        this.back.field_146124_l = this.screenShotService.getActiveCount() <= 0 && !this.closing;
        this.screenshot.field_146124_l = this.screenShotService.getActiveCount() <= 0 && this.genData.size() > 0;
        super.tick();
        for (WorldData data : this.genData.values()) {
            data.update(this.getActiveView(false), this.processor);
            if (!data.isFocused()) continue;
            data.render(this.renderTexture);
        }
        if (this.server == null && !this.closing) {
            this.server = this.seed.createServer();
            if (this.server != null) {
                this.server.func_71256_s();
            }
        }
    }

    @Override
    protected boolean shouldCloseOnEsc() {
        return false;
    }

    @Override
    public void onClose() {
        this.processor.shutdownNow();
        this.screenShotService.shutdownNow();
        this.removeServer();
        this.mapData.shutdown();
        this.genData.clear();
        this.renderTexture.removeTexture();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        this.seed.removePreview(true);
        this.getSettings().field_74335_Z = this.oldScale;
        this.displayGuiScreen((GuiScreen)this.seed.getPrevGui());
    }

    @Override
    public boolean mouseClick(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isInFrame(mouseX, mouseY)) {
            this.pos = new ChunkPos((int)mouseX, (int)mouseY);
            return true;
        }
        return super.mouseClick(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseRelease(double mouseX, double mouseY, int button) {
        if (this.pos != null) {
            this.pos = null;
            return true;
        }
        return super.mouseRelease(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseScroll(double mouseX, double mouseY, double scroll) {
        if (scroll != 0.0 && this.isInFrame(mouseX, mouseY)) {
            float data = 1.0f + (PreviewScreen.func_146271_m() ? 2.0f : 0.1f) * (float)scroll;
            this.scale = Math.max(0.01f, Math.min(60.0f, this.scale * data));
            return true;
        }
        return super.mouseScroll(mouseX, mouseY, scroll);
    }

    @Override
    public void renderBackground(int mouseX, int mouseY, float partialTicks) {
        this.priority.getOwner().field_146125_m = this.field_146295_m >= 265;
        this.speed.getOwner().field_146125_m = this.field_146295_m >= 265;
        this.genMode.getOwner().field_146125_m = this.field_146295_m >= 265;
        this.decreaseOnceSpeed.field_146125_m = this.field_146295_m >= 265;
        boolean bl = this.increaseOnceSpeed.field_146125_m = this.field_146295_m >= 265;
        if (this.pos != null) {
            this.renderTexture.moveTexture(-((float)(this.pos.field_77276_a - mouseX) / this.scale), -((float)(this.pos.field_77275_b - mouseY) / this.scale));
            this.pos = new ChunkPos(mouseX, mouseY);
        } else if (this.seedText.getOwner() != null && !this.seedText.getOwner().func_146206_l()) {
            float xMove = (Keyboard.isKeyDown((int)30) ? 1.0f : 0.0f) + (Keyboard.isKeyDown((int)32) ? -1.0f : 0.0f);
            float yMove = (Keyboard.isKeyDown((int)17) ? 1.0f : 0.0f) + (Keyboard.isKeyDown((int)31) ? -1.0f : 0.0f);
            if (xMove != 0.0f || yMove != 0.0f) {
                this.renderTexture.moveTexture(xMove / this.scale, yMove / this.scale);
            }
        }
        this.func_146276_q_();
        this.drawFrame(this.getRamInfo(), ServerManager.INSTANCE.getData(this.getDimension()));
        PreviewScreen.pushScissors(200.0f, 34.8f, this.field_146294_l - 240, (float)this.field_146295_m - 66.8f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(this.centerX + 70), (float)this.centerY, (float)0.0f);
        GlStateManager.func_179139_a((double)this.scale, (double)this.scale, (double)1.0);
        this.renderTexture.render(false, this::renderTextureWithOffset);
        this.drawExtras();
        GlStateManager.func_179121_F();
        PreviewScreen.popScissors();
    }

    @Override
    public void renderForeground(int mouseX, int mouseY, float partialTicks) {
        this.drawPostFrame(this.getRamInfo(), ServerManager.INSTANCE.getData(this.getDimension()));
    }

    @Override
    public void collectTooltips(int mouseX, int mouseY, float partialTicks, Consumer<ITextComponent> tooltips) {
        if (!this.isInFrame(mouseX, mouseY)) {
            return;
        }
        WorldData data = this.getCurrentData();
        if (data == null) {
            return;
        }
        ChunkPos pos = this.getMousePosition(data.getRadius() * 16, mouseX, mouseY);
        if (pos == null) {
            return;
        }
        IChunkData chunk = data.getChunk(pos.field_77276_a >> 4, pos.field_77275_b >> 4);
        if (chunk == null) {
            return;
        }
        int x = pos.field_77276_a & 0xF;
        int z = pos.field_77275_b & 0xF;
        tooltips.accept(TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.preview.position", NUMBERS.format(pos.field_77276_a), NUMBERS.format(chunk.getHeight(x, z)), NUMBERS.format(pos.field_77275_b)), TextFormatting.GRAY));
        tooltips.accept(TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.preview.chunk", NUMBERS.format(pos.field_77276_a >> 4), NUMBERS.format(pos.field_77275_b >> 4)), TextFormatting.GRAY));
        Biome biome = (Biome)((ForgeRegistry)ForgeRegistries.BIOMES).getValue(chunk.getBiome(x, z));
        if (biome != null) {
            tooltips.accept(TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.biome_preview.tooltip.biome", TextUtil.applyTextStyle(TextUtil.biome(biome.getRegistryName()).func_150259_f(), TextFormatting.GOLD)), TextFormatting.GREEN));
            if (BiomeColors.INSTANCE.isColorGuessed(biome.getRegistryName())) {
                tooltips.accept(TextUtil.translateStyled("gui.chunk_pregen.biome_preview.tooltip.guessed", TextFormatting.GRAY));
            }
        }
        if (chunk.isSlimeChunk()) {
            tooltips.accept(TextUtil.translateStyled("gui.chunk_pregen.preview.slime_chunk", TextFormatting.AQUA));
        }
        Map<String, Set<StructureStart>> references = data.getStructures();
        references.forEach((S, P) -> {
            ITextComponent text = TextUtil.literalPascal(S);
            for (StructureStart start : P) {
                StructureBoundingBox bounds = start.func_75071_a();
                int minX = bounds.field_78897_a + bounds.func_78883_b() / 2;
                int minZ = bounds.field_78896_c + bounds.func_78880_d() / 2;
                if (pos.field_77276_a < minX - 16 || pos.field_77276_a > minX + 16 || pos.field_77275_b < minZ - 16 || pos.field_77275_b > minZ + 16) continue;
                tooltips.accept(text);
            }
        });
    }

    public void drawFrame(long[] ram, long[] progressBars) {
        this.drawSimpleRect(20, 15, this.field_146294_l - 20, this.field_146295_m - 13, -3750202, false);
        this.drawSimpleRect(200, 35, this.field_146294_l - 40, this.field_146295_m - 32, -7631989, true);
        this.drawSimpleRect(this.field_146294_l - 205, 17, this.field_146294_l - 40, 28, -7631989, true);
        this.drawSimpleRect(200, this.field_146295_m - 28, this.field_146294_l - 40, this.field_146295_m - 15, -7631989, true);
        double value = (double)ram[0] / (double)ram[2];
        Gui.func_73734_a((int)(this.field_146294_l - 205), (int)17, (int)(this.field_146294_l - 40 - (int)(165.0 - 165.0 * value)), (int)28, (int)Color.GREEN.getRGB());
        if (progressBars[0] > 0L) {
            int pixels = this.field_146294_l - 200 - 40;
            value = (double)progressBars[1] / (double)progressBars[0];
            Gui.func_73734_a((int)200, (int)(this.field_146295_m - 28), (int)(this.field_146294_l - 40 - (int)((double)pixels - (double)pixels * value)), (int)(this.field_146295_m - 15), (int)Color.RED.darker().getRGB());
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawPostFrame(long[] ram, long[] progressBars) {
        this.drawUnalignedText(TextUtil.translate("gui.chunk_pregen.preview.seed"), 30.0f, 20.0f, Align.START, 0x404040);
        this.drawUnalignedText(TextUtil.translate("gui.chunk_pregen.preview.generation"), 30.0f, 61.0f, Align.START, 0x404040);
        this.drawUnalignedText(TextUtil.translate("gui.chunk_pregen.preview.overlays"), 30.0f, 134.0f, Align.START, 0x404040);
        if (this.field_146295_m >= 265) {
            this.drawUnalignedText(TextUtil.translate("Adv Settings"), 30.0f, 192.0f, Align.START, 0x404040);
        }
        this.drawUnalignedText(TextUtil.ram(ram[0], ram[2]), this.field_146294_l - 204, 19.0f, Align.START, 0x404040);
        this.drawUnalignedText(TextUtil.translate("gui.chunk_pregen.preview.progress.gen", progressBars[1], progressBars[0]), 201.0f, this.field_146295_m - 25, Align.START, 0x404040);
    }

    public void drawExtras() {
        WorldData data = this.getCurrentData();
        if (data == null) {
            return;
        }
        GlStateManager.func_179137_b((double)this.centerX, (double)this.centerY, (double)0.0);
        GlStateManager.func_179109_b((float)((float)this.renderTexture.getWidth() / 2.0f), (float)((float)this.renderTexture.getHeight() / 2.0f), (float)0.0f);
        float x = this.renderTexture.getX();
        float y = this.renderTexture.getY();
        if (this.slimeChunks.getValue().booleanValue()) {
            Tessellator tes = Tessellator.func_178181_a();
            BufferBuilder builder = tes.func_178180_c();
            builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            for (long pos : data.getSlimeChunks()) {
                float minX = (float)(FilePos.getX(pos) * 16) + x;
                float minY = (float)(FilePos.getZ(pos) * 16) + y;
                PreviewScreen.drawQuadArea(minX, minY, minX + 16.0f, minY + 16.0f, builder, -2147418113);
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_179090_x();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            tes.func_78381_a();
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
        }
        if (this.structures.getValue().booleanValue()) {
            float size = Math.min(60.0f / this.scale / 4.0f * (float)this.field_146294_l / 480.0f, 100.0f);
            float sizeOffset = size / 2.0f;
            Tessellator tes = Tessellator.func_178181_a();
            BufferBuilder builder = tes.func_178180_c();
            builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            int radius = data.getRadius() * 16;
            Map<String, Set<StructureStart>> references = data.getStructures();
            boolean shift = !PreviewScreen.func_146272_n();
            references.forEach((K, V) -> {
                String id = K.toLowerCase(Locale.ROOT);
                if (this.spammyStructure.contains(id) && shift || StructureIcons.INSTANCE.isHidden(id)) {
                    return;
                }
                for (StructureStart start : V) {
                    StructureBoundingBox bounds = start.func_75071_a();
                    int minX = bounds.field_78897_a + bounds.func_78883_b() / 2;
                    int minZ = bounds.field_78896_c + bounds.func_78880_d() / 2;
                    if ((float)minX - sizeOffset <= (float)(-radius) || (float)minX + sizeOffset >= (float)radius || (float)minZ - sizeOffset <= (float)(-radius) || (float)minZ + sizeOffset >= (float)radius) continue;
                    PreviewScreen.drawQuadArea((float)minX + x - sizeOffset, (float)minZ + y - sizeOffset, (float)minX + x + sizeOffset, (float)minZ + y + sizeOffset, builder, -2141562278);
                }
            });
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            tes.func_78381_a();
            LinkedHashMap spamDetectionMap = new LinkedHashMap();
            builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            references.forEach((K, V) -> {
                String id = K.toLowerCase(Locale.ROOT);
                if (this.spammyStructure.contains(id) && shift || StructureIcons.INSTANCE.isHidden(id)) {
                    return;
                }
                spamDetectionMap.put(K, V.size());
                TextureAtlasSprite sprite = StructureIcons.INSTANCE.getSprite(id);
                for (StructureStart start : V) {
                    StructureBoundingBox bounds = start.func_75071_a();
                    int minX = bounds.field_78897_a + bounds.func_78883_b() / 2;
                    int minZ = bounds.field_78896_c + bounds.func_78880_d() / 2;
                    if ((float)minX - sizeOffset <= (float)(-radius) || (float)minX + sizeOffset >= (float)radius || (float)minZ - sizeOffset <= (float)(-radius) || (float)minZ + sizeOffset >= (float)radius) continue;
                    this.renderTexture((float)minX + x - sizeOffset, (float)minZ + y - sizeOffset, size, size, sprite, builder);
                }
            });
            this.field_146297_k.func_110434_K().func_110577_a(StructureIcons.INSTANCE.getTexture());
            tes.func_78381_a();
            GlStateManager.func_179084_k();
            int count = data.getGeneratedRegions();
            if (count > 3 && shift) {
                for (Map.Entry entry : spamDetectionMap.entrySet()) {
                    if ((Integer)entry.getValue() <= count * 3) continue;
                    this.spammyStructure.add(((String)entry.getKey()).toLowerCase(Locale.ROOT));
                }
            }
        }
    }

    private long[] getRamInfo() {
        long first = Runtime.getRuntime().totalMemory();
        long second = Runtime.getRuntime().freeMemory();
        long last = Runtime.getRuntime().maxMemory();
        return new long[]{first - second, first, last};
    }

    @SubscribeEvent
    public void onChunkPreviewed(PregenEvent event) {
        Chunk chunk = event.getChunk();
        WorldData instance = this.genData.get(chunk.func_177412_p().field_73011_w.getDimension());
        if (instance != null) {
            instance.addChunk(chunk);
        }
    }

    @SubscribeEvent
    public void onChunkSaved(ChunkDataEvent.Save event) {
        Chunk chunk = event.getChunk();
        if (!chunk.func_177419_t()) {
            return;
        }
        WorldData instance = this.genData.get(chunk.func_177412_p().field_73011_w.getDimension());
        if (instance != null) {
            instance.addChunk(chunk);
        }
    }

    public int getDimension() {
        return this.dimension.getValue();
    }

    public WorldData getCurrentData() {
        return this.genData.get(this.dimension.getValue());
    }

    public WorldData createData() {
        return this.genData.computeIfAbsent(this.dimension.getValue(), T -> {
            WorldData data = new WorldData((int)T, this.shape.getValue(), this.mapData.createDimension((int)T), DimensionManager.createProviderFor((int)T).func_191066_m());
            data.setRadius(this.radius.get());
            this.renderTexture.resizeTexture(this.radius.get() * 32);
            this.renderTexture.centerTexture();
            return data;
        });
    }

    private void createScreenShot(List<ScreenshotScreen.ScreenshotEntry> output) {
        if (output.isEmpty()) {
            return;
        }
        File file = new File(this.field_146297_k.field_71412_D, "screenshots/preview/" + Long.toString(this.seed.getSeed()));
        if (!file.exists()) {
            try {
                file.mkdirs();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (ScreenshotScreen.ScreenshotEntry entry : output) {
            WorldData data = this.genData.get(entry.getDim());
            if (data == null) continue;
            this.screenShotService.execute(new CreateScreenshotTask(data, file, entry, this.spammyStructure));
        }
    }

    protected int getActiveView(boolean excludeProgress) {
        int view = this.progressView.getValue();
        return view == 0 || excludeProgress ? this.views.getValue() : view;
    }

    public void reloadTextureData() {
        WorldData data = this.getCurrentData();
        if (data != null) {
            data.reload(this.getActiveView(false));
        }
    }

    private void finishFolder() {
        this.processor.shutdownNow();
        this.screenShotService.shutdownNow();
        this.removeServer();
        this.mapData.shutdown();
        this.genData.clear();
        this.renderTexture.removeTexture();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        WorldSeed.removeFile(WorldSeed.getMapFolder().toFile(), true);
        this.getSettings().field_74335_Z = this.oldScale;
        if (!WorldSeed.getPreviewFolder().toFile().renameTo(new File("saves/" + this.seed.getFolderName()))) {
            this.displayGuiScreen(this.createChoice(TextUtil.translate("gui.chunk_pregen.preview.warning"), TextUtil.translate("gui.chunk_pregen.preview.warning.body"), TextUtil.translate("gui.chunk_pregen.preview.warning.ok"), TextUtil.translate("gui.chunk_pregen.preview.warning.not_ok"), (T, I) -> {
                if (T) {
                    OpenGlHelper.func_188786_a((File)WorldSeed.getPreviewFolder().getParent().toFile());
                    FMLCommonHandler.instance().exitJava(0, true);
                    return;
                }
                this.displayGuiScreen((GuiScreen)new GuiMainMenu());
            }));
            return;
        }
        this.displayGuiScreen((GuiScreen)new GuiMainMenu());
    }

    private void keepWorld(GuiButton button) {
        Map<Integer, Integer> toLight = this.getUngeneratedChunks();
        button.field_146124_l = false;
        button.field_146126_j = I18n.func_135052_a((String)"gui.chunk_pregen.preview.processing", (Object[])new Object[0]);
        if (toLight.isEmpty()) {
            this.closing = true;
            this.finishFolder();
            return;
        }
        ITextComponent body = TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.preview.confirm.body").func_150259_f().func_150258_a("\n\n"), TextFormatting.GRAY);
        for (Map.Entry<Integer, Integer> entry : toLight.entrySet()) {
            body.func_150257_a(TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.preview.confirm.entry", TextUtil.applyTextStyle(TextUtil.dimension(entry.getKey()), TextFormatting.GOLD), TextUtil.literal(NUMBERS.format(entry.getValue())), TextFormatting.AQUA), new TextFormatting[0]));
        }
        this.displayGuiScreen(this.createChoice(TextUtil.translate("gui.chunk_pregen.preview.confirm.header"), body, (T, i) -> {
            this.displayGuiScreen(this);
            if (T) {
                this.closing = true;
                this.finishFolder();
                return;
            }
            button.field_146126_j = I18n.func_135052_a((String)"gui.chunk_pregen.preview.keep_world", (Object[])new Object[0]);
        }));
    }

    private Map<Integer, Integer> getUngeneratedChunks() {
        LinkedHashMap<Integer, Integer> toLight = new LinkedHashMap<Integer, Integer>();
        for (WorldData data : this.genData.values()) {
            ChunkCache cache = data.getCache();
            if (cache.isFullyFinished()) continue;
            toLight.put(data.getDimension(), cache.getChunksToFinish());
        }
        return toLight;
    }

    private void back(GuiButton button) {
        button.field_146126_j = I18n.func_135052_a((String)"gui.chunk_pregen.preview.stopping", (Object[])new Object[0]);
        button.field_146124_l = false;
        this.closing = true;
        this.onClose();
    }

    private void start(GuiButton button) {
        WorldData data = this.createData();
        data.setState(this.genMode.getValue());
        ITask task = this.shape.getValue().createRadiusGenTask("Preview_" + this.getDimension(), 0, 0, data.getRadius(), this.genMode.getValue().booleanValue() ? (this.getUngeneratedChunks().isEmpty() ? GenerationType.FAST_CHECK_GEN : GenerationType.NORMAL_GEN) : GenerationType.TERRAIN_ONLY, data.getDimension());
        TaskActions.startTask((IBaseTask)task, null, T -> {});
    }

    private void stop(GuiButton button) {
        this.server.func_152344_a(() -> TaskActions.removeTask("Preview_" + this.getDimension(), T -> {}));
    }

    private void setSeed(GuiButton button) {
        long newSeed = WorldSeed.makeSeed(this.seedText.getValue());
        if (newSeed != this.seed.getSeed()) {
            this.seed.setSeed(this.seedText.getValue());
            this.removeServer();
            this.mapData.clearData();
            this.genData.clear();
            WorldSeed.removeFile(WorldSeed.getPreviewFolder().toFile(), false);
            this.renderTexture.centerTexture();
            this.renderTexture.clearTexture();
            this.reloadTextureData();
        }
    }

    private void removeServer() {
        if (this.server == null) {
            return;
        }
        for (WorldServer level : this.server.field_71305_c) {
            WorldInfo data = level.func_72912_H();
            data.func_76068_b(0L);
            data.func_176142_i(0);
            data.func_76084_b(false);
            data.func_76080_g(0);
            data.func_76069_a(false);
            data.func_76090_f(0);
        }
        this.seed.destroyServer(this.server);
        this.server = null;
    }

    private void resizeTexture(GuiButton button) {
        int radius = this.radius.get();
        this.renderTexture.resizeTexture(radius * 32);
        this.renderTexture.centerTexture();
        WorldData data = this.getCurrentData();
        if (data != null) {
            data.setRadius(radius);
        }
        this.reloadTextureData();
    }

    public void createScreenshot(GuiButton button) {
        if (GuiScreen.func_146272_n()) {
            this.displayGuiScreen(new ScreenshotScreen(this, this.genData.keySet(), this.getDimension(), this.views.getValue(), this::createScreenShot));
            return;
        }
        this.createScreenShot((List<ScreenshotScreen.ScreenshotEntry>)ObjectLists.singleton((Object)new ScreenshotScreen.ScreenshotEntry(this.getDimension(), this.views.getValue(), this.slimeChunks.getValue(), this.structures.getValue(), false)));
    }

    public void setDimension(CycleButton<Integer> cycle) {
        int dim = cycle.getValue();
        for (WorldData data : this.genData.values()) {
            data.setFocus(dim, this.getActiveView(false));
        }
        WorldData data = this.getCurrentData();
        if (data != null) {
            this.radius.set(data.getRadius());
        }
        this.renderTexture.resizeTexture(this.radius.get() * 32);
        this.renderTexture.centerTexture();
        this.reloadTextureData();
    }

    private void setShape(CycleButton<GenShape> shape) {
        WorldData data = this.getCurrentData();
        if (data == null) {
            return;
        }
        data.setShape(shape.getValue());
    }

    private void setView(CycleButton<Integer> view) {
        if (this.progressView.getValue() != 0) {
            return;
        }
        WorldData data = this.getCurrentData();
        if (data != null) {
            data.reload(this.getActiveView(false));
        }
    }

    private void toggleProgress(CycleButton<Integer> view) {
        WorldData data = this.getCurrentData();
        if (data != null) {
            data.reload(this.getActiveView(false));
        }
    }

    private Function<CycleButton<Boolean>, ITextComponent> createTooltip(ITextComponent desc) {
        return T -> TextUtil.empty().func_150257_a(desc).func_150258_a("\n").func_150257_a(TextUtil.translateStyled("gui.chunk_pregen.biome_preview.tooltip.active", TextFormatting.BLUE).func_150257_a(TextUtil.translateStyled("gui.chunk_pregen.biome_preview.tooltip.active." + T.getValue(), (Boolean)T.getValue() != false ? TextFormatting.GREEN : TextFormatting.RED)));
    }

    private Function<CycleButton<Integer>, ITextComponent> createViewTooltip(ITextComponent desc) {
        return T -> TextUtil.empty().func_150257_a(desc).func_150258_a("\n").func_150257_a(TextUtil.translateStyled("gui.chunk_pregen.biome_preview.tooltip.active", TextFormatting.BLUE).func_150257_a(TextUtil.translateStyled("gui.chunk_pregen.biome_preview.tooltip.active." + ((Integer)T.getValue() == 0 ? "false" : "true"), (Integer)T.getValue() != 0 ? TextFormatting.GREEN : TextFormatting.RED)));
    }

    private ITextComponent getDimensionName(int dimension) {
        return TextUtil.dimension(dimension);
    }

    private ITextComponent getShapeName(GenShape shape) {
        return TextUtil.translate("gui.chunk_pregen.preview.shape", shape.getName());
    }

    private ITextComponent getViewName(int index) {
        return TextUtil.translate(index == 0 ? "gui.chunk_pregen.preview.view.blocks" : (index == 1 ? "gui.chunk_pregen.preview.view.biomes" : "gui.chunk_pregen.preview.view.heights"));
    }

    private ITextComponent getGenMode(boolean value) {
        return TextUtil.literal(value ? "Full Gen" : "Terrain Only");
    }

    protected ITextComponent getSpeedTooltip(PregenSlider slider) {
        ITextComponent comp = TextUtil.empty();
        comp.func_150257_a(TextUtil.translate("gui.chunk_pregen.preview.tooltip.speed.base")).func_150258_a("\n");
        comp.func_150257_a(TextUtil.translate("gui.chunk_pregen.preview.tooltip.speed.expansion"));
        if (slider.getState().get() > 250) {
            comp.func_150258_a("\n").func_150257_a(TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.preview.tooltip.speed.fast"), TextFormatting.RED));
        }
        return comp;
    }

    protected ITextComponent getSliderTooltip(PregenSlider slider) {
        long radius = slider.get() * 2;
        long worldSize = radius * 16L;
        long chunkSize = radius * radius;
        long byteSize = TextUtil.getWorldSize(chunkSize, this.getDimension());
        float speed = ServerManager.INSTANCE.getChunksPerTick(this.getDimension());
        long time = (long)((float)chunkSize / speed * 50.0f);
        ITextComponent comp = TextUtil.empty();
        comp.func_150257_a(TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.preview.tooltip.world_size", NUMBERS.format(worldSize)), TextFormatting.GOLD)).func_150258_a("\n");
        comp.func_150257_a(TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.task_screen.nodes.eta", TextUtil.getTime(time), FLOATING_NUMBERS.format(speed)), TextFormatting.AQUA)).func_150258_a("\n");
        comp.func_150258_a("\n");
        comp.func_150257_a(TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.preview.tooltip.expected_usage"), TextFormatting.GOLD)).func_150258_a("\n");
        comp.func_150257_a(TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.preview.tooltip.gpu_usage", TextUtil.findBestMemory(chunkSize * 1024L)), TextFormatting.AQUA)).func_150258_a("\n");
        comp.func_150258_a("\n");
        comp.func_150257_a(TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.preview.tooltip.disk_usage"), TextFormatting.GOLD)).func_150258_a("\n");
        comp.func_150257_a(TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.preview.tooltip.world_data", TextUtil.findBestMemory(byteSize)), TextFormatting.AQUA)).func_150258_a("\n");
        comp.func_150257_a(TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.preview.tooltip.preview_data", TextUtil.findBestMemory(chunkSize * (IFileProvider.FileType.CHUNK_DATA.getOffset() + IFileProvider.FileType.HEIGHT_DATA.getOffset()))), TextFormatting.GREEN));
        return comp;
    }

    public ChunkPos getMousePosition(int radius, int mouseX, int mouseY) {
        int posX = (int)(this.renderTexture.getX() - ((float)(mouseX - (this.field_146294_l + 140) / 2) / this.scale - (float)this.centerX));
        int posZ = (int)(this.renderTexture.getY() - ((float)(mouseY - this.field_146295_m / 2) / this.scale - (float)this.centerY));
        return posX > 0 || posZ > 0 || posX <= radius * -2 || posZ <= radius * -2 ? null : new ChunkPos(Math.abs(posX) - radius, Math.abs(posZ) - radius);
    }

    public boolean isInFrame(double mouseX, double mouseY) {
        return mouseX >= 200.0 && mouseX <= (double)(this.field_146294_l - 35) && mouseY >= 40.0 && mouseY <= (double)(this.field_146295_m - 32);
    }
}

