/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview.texture;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import pregenerator.impl.client.preview.texture.IRenderTexture;
import pregenerator.impl.client.preview.texture.MoveableTexture;
import pregenerator.impl.client.preview.world.data.ChunkData;
import pregenerator.impl.client.preview.world.data.IChunkData;

public class DisplayTexture
implements IRenderTexture {
    public static final int BACKGROUND_COLOR = -7631989;
    int width;
    int height;
    int xSize;
    int ySize;
    int[] textures;

    public DisplayTexture(int width, int height) {
        this.width = width;
        this.height = height;
        this.generateTexture(width, height);
        this.clearTexture();
    }

    @Override
    public void clearTexture() {
        int frame = GL30.glGenFramebuffers();
        GL30.glBindFramebuffer((int)36009, (int)frame);
        GL11.glViewport((int)0, (int)0, (int)4096, (int)4096);
        GL11.glDrawBuffer((int)36064);
        for (int i = 0; i < this.textures.length; ++i) {
            GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.textures[i], (int)0);
            GL11.glClearColor((float)0.545f, (float)0.545f, (float)0.545f, (float)1.0f);
            GL11.glClear((int)16384);
            GL11.glClearColor((float)0.545f, (float)0.545f, (float)0.545f, (float)1.0f);
        }
        GL30.glDeleteFramebuffers((int)frame);
        GL30.glBindFramebuffer((int)36009, (int)Minecraft.func_71410_x().func_147110_a().field_147616_f);
        Minecraft mc = Minecraft.func_71410_x();
        GL11.glViewport((int)0, (int)0, (int)mc.field_71443_c, (int)mc.field_71440_d);
    }

    public void addPixels(int x, int y, int[] data, int width, int height) {
        GlStateManager.func_179144_i((int)this.getTexture(x, y));
        TextureUtil.func_147955_a((int[][])new int[][]{data}, (int)width, (int)height, (int)(x % 4096), (int)(y % 4096), (boolean)false, (boolean)false);
    }

    @Override
    public void translate(float x, float y, float scale) {
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void onRender(boolean slime, MoveableTexture.IRenderFunction function, MoveableTexture texture) {
        float xPos = texture.getX();
        float yPos = texture.getY();
        for (int x = 0; x < this.xSize; ++x) {
            for (int y = 0; y < this.ySize; ++y) {
                GlStateManager.func_179144_i((int)this.textures[this.ySize * x + y]);
                function.render(xPos + (float)x * 4096.0f, yPos + (float)y * 4096.0f, 4096, 4096);
            }
        }
    }

    @Override
    public void addData(IChunkData data, int size, int view) {
        ChunkData chunk = (ChunkData)data;
        int x = data.getX() * 16 + size;
        int z = data.getZ() * 16 + size;
        this.addPixels(x, z, chunk.getData(view), 16, 16);
    }

    @Override
    public void onRenderFinished(Minecraft mc) {
    }

    @Override
    public void removeTexture() {
        for (int i = 0; i < this.textures.length; ++i) {
            if (this.textures[i] == -1) continue;
            TextureUtil.func_147942_a((int)this.textures[i]);
            this.textures[i] = -1;
        }
    }

    public int getTexture(int x, int y) {
        return this.textures[MathHelper.func_76125_a((int)x, (int)0, (int)this.width) / 4096 * this.ySize + MathHelper.func_76125_a((int)y, (int)0, (int)this.height) / 4096];
    }

    public void generateTexture(int width, int height) {
        this.xSize = MathHelper.func_76143_f((double)((double)width / 4096.0));
        this.ySize = MathHelper.func_76143_f((double)((double)height / 4096.0));
        this.textures = new int[this.xSize * this.ySize];
        for (int x = 0; x < this.xSize; ++x) {
            for (int y = 0; y < this.ySize; ++y) {
                int index = this.ySize * x + y;
                this.textures[index] = TextureUtil.func_110996_a();
                TextureUtil.func_110991_a((int)this.textures[index], (int)4096, (int)4096);
            }
        }
    }

    public static int unsortColors(int color) {
        int r = color & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 16 & 0xFF;
        int a = color >> 24 & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int sortColors(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 0 & 0xFF;
        int a = color >> 24 & 0xFF;
        return a << 24 | b << 16 | g << 8 | r;
    }
}

