/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview.world;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.StructureStart;
import pregenerator.impl.client.preview.data.IFileProvider;
import pregenerator.impl.client.preview.data.Tasks;
import pregenerator.impl.client.preview.texture.MoveableTexture;
import pregenerator.impl.client.preview.world.ChunkCache;
import pregenerator.impl.client.preview.world.data.Evaluator;
import pregenerator.impl.client.preview.world.data.IChunkData;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.misc.GenShape;
import pregenerator.impl.misc.Tuple;
import pregenerator.impl.processor.generator.ChunkProcessor;
import pregenerator.impl.structure.MapGenStructureDataPregen;
import pregenerator.impl.structure.StructureManager;

public class WorldData {
    static final String[] VIEWS = new String[]{"Blocks", "Biomes", "Heights"};
    static final FilePos CENTER = new FilePos(0, 0);
    Cache<Long, IChunkData> cachedChunks = CacheBuilder.newBuilder().maximumSize(64L).expireAfterAccess(30L, TimeUnit.SECONDS).build();
    Map<String, Set<StructureStart>> structureCache = new LinkedHashMap<String, Set<StructureStart>>();
    Set<Long> slimeChunks = new LinkedHashSet<Long>();
    Set<Long> regionsGenerated = new HashSet<Long>();
    Deque<IChunkData> toSave = new ConcurrentLinkedDeque<IChunkData>();
    Deque<Tuple<IChunkData, Integer>> toRender = new ConcurrentLinkedDeque<Tuple<IChunkData, Integer>>();
    Evaluator evaluator = new Evaluator();
    final int dimension;
    int radius = 100;
    ChunkCache cache;
    boolean isFocus = false;
    IFileProvider.FileType type;
    GenShape shape = GenShape.SQUARE;
    boolean currentState;
    boolean skyLight;

    public WorldData(int dimension, GenShape shape, ChunkCache cache, boolean hasSkylight) {
        this.shape = shape;
        this.dimension = dimension;
        this.cache = cache;
        this.skyLight = hasSkylight;
        this.isFocus = true;
        this.type = IFileProvider.FileType.CHUNK_DATA;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public void setShape(GenShape shape) {
        this.shape = shape;
    }

    public GenShape getShape() {
        return this.shape;
    }

    public int getRadius() {
        return this.radius;
    }

    public ChunkCache getCache() {
        return this.cache;
    }

    public boolean isFocused() {
        return this.isFocus;
    }

    public int getDimension() {
        return this.dimension;
    }

    public boolean hasSkyLight() {
        return this.skyLight;
    }

    public int getGeneratedRegions() {
        return this.regionsGenerated.size();
    }

    public String getScreenName(int view, boolean overlay) {
        return "Screenshot_" + this.dimension + VIEWS[view] + (overlay ? "_overlay" : "") + ".png";
    }

    public void setState(boolean value) {
        this.currentState = value;
    }

    public void setFocus(int focusDim, int view) {
        boolean bl = this.isFocus = focusDim == this.dimension;
        if (this.isFocus) {
            this.reload(view);
        } else {
            this.toRender.clear();
        }
    }

    public IChunkData getChunk(int x, int z) {
        if (this.cache.hasIndex(x, z)) {
            IChunkData data = (IChunkData)this.cachedChunks.getIfPresent((Object)FilePos.asLong(x, z));
            return data != null ? data : this.cache.getChunk(x, z, this.cachedChunks);
        }
        return null;
    }

    public boolean isFocus() {
        return this.isFocus;
    }

    public void reload(int view) {
        this.cache.addTask(new Tasks.MassFetchTask(this.toRender, view));
    }

    public void update(int view, Executor process) {
        for (int i = 0; i < 100 && !this.toSave.isEmpty(); ++i) {
            IChunkData data = this.toSave.removeFirst();
            data.storeInHeightMap(this.cache);
            if (data.isSlimeChunk()) {
                this.slimeChunks.add(FilePos.asLong(data.getX(), data.getZ()));
            }
            this.cache.addTask(data);
            this.evaluator.addChunk(data);
            if (this.isFocus) {
                this.toRender.addLast(new Tuple<IChunkData, Integer>(data, view));
            }
            this.regionsGenerated.add(data.getRegion());
        }
        process.execute(() -> this.process(view));
    }

    private void process(int view) {
        for (IChunkData data : this.evaluator.tick(ChunkProcessor.INSTANCE.isStopped(), this.cache)) {
            this.cache.addTask(data);
            if (!this.isFocus) continue;
            this.toRender.addLast(new Tuple<IChunkData, Integer>(data, view));
        }
    }

    public void render(MoveableTexture texture) {
        int toUpdate = Math.max(1000, this.toRender.size() / 10);
        for (int i = 0; i < toUpdate && !this.toRender.isEmpty(); ++i) {
            Tuple<IChunkData, Integer> value = this.toRender.removeFirst();
            IChunkData data = value.getFirst();
            if (data.getX() < -this.radius || data.getX() >= this.radius || data.getZ() < -this.radius || data.getZ() >= this.radius) continue;
            data.addToTexture(texture, value.getSecond(), this.radius * 16);
        }
    }

    public void addChunk(Chunk data) {
        if (this.shape.isInsideArea(this.radius, data.field_76635_g, data.field_76647_h)) {
            this.toSave.add(this.type.createData(data, this.currentState));
        }
    }

    public Collection<Long> getSlimeChunks() {
        return this.slimeChunks;
    }

    public Map<String, Set<StructureStart>> getStructures() {
        LinkedHashMap<String, Set<StructureStart>> results = new LinkedHashMap<String, Set<StructureStart>>();
        for (MapGenStructureDataPregen mapGenStructureDataPregen : StructureManager.INSTANCE.getStructureHolders(this.dimension)) {
            try {
                results.put(mapGenStructureDataPregen.field_76190_i, new LinkedHashSet<StructureStart>(mapGenStructureDataPregen.getStarts()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Map.Entry entry : this.structureCache.entrySet()) {
            results.computeIfAbsent((String)entry.getKey(), (Function<String, Set<StructureStart>>)((Function<String, Set>)T -> new LinkedHashSet())).addAll((Collection)entry.getValue());
        }
        this.structureCache = results;
        return results;
    }
}

