/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.utils;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class StructureIcons
implements IResourceManagerReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final StructureIcons INSTANCE = new StructureIcons();
    private static final ResourceLocation ID = new ResourceLocation("chunkpregenerator", "structure_icons");
    TextureAtlas textureAtlas;
    Set<String> hiddenStructures = new HashSet<String>();
    Map<String, TextureAtlasSprite> sprites = new LinkedHashMap<String, TextureAtlasSprite>();
    TextureAtlasSprite defaultValue;
    Gson gson = new Gson();

    public void init(TextureManager manager) {
        this.textureAtlas = new TextureAtlas();
        manager.func_110579_a(ID, (ITextureObject)this.textureAtlas);
    }

    public void func_110549_a(IResourceManager manager) {
        this.loadData(manager, this.gatherTextures(manager));
    }

    public ResourceLocation getTexture() {
        return ID;
    }

    public boolean isHidden(String id) {
        return this.hiddenStructures.contains(id) || id == null;
    }

    public TextureAtlasSprite getSprite(String id) {
        return this.sprites.getOrDefault(id, this.defaultValue);
    }

    private void loadData(IResourceManager manager, Map<String, ResourceLocation> structuresToIcons) {
        this.sprites.clear();
        this.hiddenStructures.clear();
        this.textureAtlas.clear();
        for (Map.Entry<String, ResourceLocation> entry : structuresToIcons.entrySet()) {
            ResourceLocation value = entry.getValue();
            if ("hidden".equals(value.func_110623_a())) {
                this.hiddenStructures.add(entry.getKey());
                continue;
            }
            this.sprites.put(entry.getKey(), this.textureAtlas.registerTexture(value));
        }
        this.defaultValue = this.sprites.get("unknown");
        this.textureAtlas.load(manager);
    }

    private Map<String, ResourceLocation> gatherTextures(IResourceManager manager) {
        LinkedHashMap<String, ResourceLocation> map = new LinkedHashMap<String, ResourceLocation>();
        try {
            for (IResource resource : manager.func_135056_b(new ResourceLocation("chunkpregenerator", "minimap/structures/structure_icons.json"))) {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(resource.func_110527_b()));
                    Throwable throwable = null;
                    try {
                        JsonObject object = (JsonObject)JsonUtils.func_193839_a((Gson)this.gson, (Reader)reader, JsonObject.class);
                        for (Map.Entry structureEntry : object.entrySet()) {
                            map.put((String)structureEntry.getKey(), new ResourceLocation(JsonUtils.func_151206_a((JsonElement)((JsonElement)structureEntry.getValue()), (String)((String)structureEntry.getKey()))));
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((Reader)reader).close();
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Couldn't parse data file {} from {}", (Object)resource.func_177241_a(), (Object)resource.func_177240_d(), (Object)exception);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    private static class AtlasTexture
    extends TextureAtlasSprite {
        public AtlasTexture(ResourceLocation spriteName) {
            super(spriteName.toString());
        }
    }

    public static class TextureAtlas
    extends AbstractTexture {
        private Map<ResourceLocation, TextureAtlasSprite> mapRegisteredSprites = new LinkedHashMap<ResourceLocation, TextureAtlasSprite>();
        private Map<ResourceLocation, TextureAtlasSprite> mapUploadedSprites = new LinkedHashMap<ResourceLocation, TextureAtlasSprite>();
        private TextureAtlasSprite missingImage = new AtlasTexture(new ResourceLocation("missingno"));

        public void func_110551_a(IResourceManager resourceManager) throws IOException {
            this.load(resourceManager);
        }

        public void load(IResourceManager manager) {
            this.initMissingImage();
            this.func_147631_c();
            this.loadTextures(manager);
        }

        public void clear() {
            this.mapRegisteredSprites.clear();
        }

        private void loadTextures(IResourceManager manager) {
            this.mapUploadedSprites.clear();
            int i = Minecraft.func_71369_N();
            Stitcher stitcher = new Stitcher(i, i, 0, 0);
            for (Map.Entry<ResourceLocation, TextureAtlasSprite> entry : this.mapRegisteredSprites.entrySet()) {
                TextureAtlasSprite sprite = entry.getValue();
                try {
                    IResource resource = manager.func_110536_a(this.getResourceLocation(sprite));
                    Throwable throwable = null;
                    try {
                        PngSizeInfo info = PngSizeInfo.func_188532_a((IResource)resource);
                        sprite.func_188538_a(info, false);
                        IResource newResource = manager.func_110536_a(this.getResourceLocation(sprite));
                        sprite.func_188539_a(newResource, 1);
                        IOUtils.closeQuietly((Closeable)newResource);
                        stitcher.func_110934_a(sprite);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (resource == null) continue;
                        if (throwable != null) {
                            try {
                                resource.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        resource.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            stitcher.func_110934_a(this.missingImage);
            stitcher.func_94305_f();
            TextureUtil.func_180600_a((int)this.func_110552_b(), (int)0, (int)stitcher.func_110935_a(), (int)stitcher.func_110936_b());
            for (TextureAtlasSprite textureAtlasSprite : stitcher.func_94309_g()) {
                this.mapUploadedSprites.put(new ResourceLocation(textureAtlasSprite.func_94215_i()), textureAtlasSprite);
                TextureUtil.func_147955_a((int[][])textureAtlasSprite.func_147965_a(0), (int)textureAtlasSprite.func_94211_a(), (int)textureAtlasSprite.func_94216_b(), (int)textureAtlasSprite.func_130010_a(), (int)textureAtlasSprite.func_110967_i(), (boolean)false, (boolean)false);
            }
            for (Map.Entry<Object, Object> entry : this.mapRegisteredSprites.entrySet()) {
                if (this.mapUploadedSprites.containsKey(entry.getKey())) continue;
                ((TextureAtlasSprite)entry.getValue()).func_94217_a(this.missingImage);
            }
        }

        public TextureAtlasSprite registerTexture(ResourceLocation location) {
            return this.mapRegisteredSprites.computeIfAbsent(location, AtlasTexture::new);
        }

        private ResourceLocation getResourceLocation(TextureAtlasSprite p_184396_1_) {
            ResourceLocation resourcelocation = new ResourceLocation(p_184396_1_.func_94215_i());
            return new ResourceLocation(resourcelocation.func_110624_b(), String.format("%s/%s%s", "textures", resourcelocation.func_110623_a(), ".png"));
        }

        private void initMissingImage() {
            int[] aint = TextureUtil.field_110999_b;
            this.missingImage.func_110966_b(16);
            this.missingImage.func_110969_c(16);
            int[][] aint1 = new int[][]{aint};
            this.missingImage.func_110968_a((List)Lists.newArrayList((Object[])new int[][][]{aint1}));
        }
    }
}

