/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.commands;

import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import pregenerator.PregenConfig;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.commands.base.CommandBuilder;
import pregenerator.impl.commands.base.CommandNode;
import pregenerator.impl.commands.base.PregenCommand;
import pregenerator.impl.commands.base.PregenCommands;
import pregenerator.impl.commands.base.args.BooleanArgument;
import pregenerator.impl.commands.base.args.DimensionArgument;
import pregenerator.impl.commands.base.args.EnumArgument;
import pregenerator.impl.commands.base.args.IntegerArgument;
import pregenerator.impl.commands.base.args.StringArgument;
import pregenerator.impl.processor.IBaseTask;
import pregenerator.impl.processor.IProcessor;
import pregenerator.impl.processor.ServerManager;
import pregenerator.impl.processor.generator.BenchmarkManager;
import pregenerator.impl.processor.minitasks.AgeScan;
import pregenerator.impl.processor.minitasks.CorruptionScan;
import pregenerator.impl.processor.minitasks.ScanSize;
import pregenerator.impl.storage.PregenTaskStorage;
import pregenerator.impl.tracking.ServerTracker;

public class BaseCommands {
    public static CommandNode createControlTasks() {
        CommandBuilder builder = new CommandBuilder("temp");
        builder.literal("taskList", BaseCommands::showTaskList).pop();
        builder.literal("pause", BaseCommands::pauseTask).pop();
        builder.literal("resume", BaseCommands::resumeTask).pop();
        PregenCommand stopCommand = BaseCommands::stopTask;
        builder.literal("stop", stopCommand);
        builder.arg("delete", BooleanArgument.bool(), stopCommand).popTop();
        PregenCommand continueCommand = BaseCommands::continueTask;
        builder.literal("continue", continueCommand);
        builder.arg("Task Name", StringArgument.text(), BaseCommands::suggestsTaskList, continueCommand).popTop();
        PregenCommand clearCommand = BaseCommands::clearTask;
        builder.literal("clear", clearCommand);
        builder.arg("Task Name", StringArgument.text(), BaseCommands::suggestsTaskList, clearCommand).popTop();
        CommandNode node = builder.build();
        node.addChild(BaseCommands.createScanTasks());
        return node;
    }

    static CommandNode createScanTasks() {
        CommandBuilder builder = new CommandBuilder("scan");
        builder.literal("worldsize").arg("dimension", DimensionArgument.any(), BaseCommands::scanSize).pop(2);
        builder.literal("worldage").arg("dimension", DimensionArgument.any(), BaseCommands::scanAge).pop(2);
        builder.literal("worldcorruption").arg("dimension", DimensionArgument.any(), BaseCommands::scanCorruption);
        return builder.build();
    }

    public static CommandNode createUtilCommands() {
        CommandBuilder builder = new CommandBuilder("utils");
        builder.literal("gc", BaseCommands::gc).pop();
        builder.literal("tracker", BaseCommands::trackerStatus);
        builder.literal("enable", BaseCommands::enableTracker).pop();
        builder.literal("disable", BaseCommands::disableTracker).popTop();
        builder.literal("timePerTick", BaseCommands::timePerTickStatus).arg("time", IntegerArgument.range(1, 1000), BaseCommands::setTimePerTick).popTop();
        builder.literal("priorty", BaseCommands::priorityStatus).arg("priority", EnumArgument.value(Priority.class), BaseCommands::setPriority).popTop();
        builder.literal("dimension");
        builder.literal("unload").arg("dimension", DimensionArgument.loaded(), BaseCommands::unload).pop(2);
        builder.literal("unlock_range").arg("from", DimensionArgument.loaded()).arg("to", DimensionArgument.loaded(), BaseCommands::unloadRange);
        return builder.build();
    }

    private static void suggestsTaskList(PregenCommands.CommandContext context, int argumentIndex, Consumer<String> output) {
        PregenTaskStorage.getStorage().getTaskNames().forEach(output);
    }

    private static void scanAge(PregenCommands.CommandContext context) {
        int dimension = context.getDimension("Dimension");
        if (context.getWorld(dimension) == null) {
            context.sendFailure(TextUtil.dimensionMissing());
            return;
        }
        ServerManager.INSTANCE.startMiniTask(UUID.randomUUID(), new AgeScan(dimension, context.getSenderId()));
        PregenTaskStorage.getStorage().collectListeners(context.getSenderId());
    }

    private static void scanCorruption(PregenCommands.CommandContext context) {
        int dimension = context.getDimension("Dimension");
        if (context.getWorld(dimension) == null) {
            context.sendFailure(TextUtil.dimensionMissing());
            return;
        }
        ServerManager.INSTANCE.startMiniTask(UUID.randomUUID(), new CorruptionScan(dimension, context.getSenderId()));
        PregenTaskStorage.getStorage().collectListeners(context.getSenderId());
    }

    private static void scanSize(PregenCommands.CommandContext context) {
        int dimension = context.getDimension("Dimension");
        if (context.getWorld(dimension) == null) {
            context.sendFailure(TextUtil.dimensionMissing());
            return;
        }
        ServerManager.INSTANCE.startMiniTask(UUID.randomUUID(), new ScanSize(dimension, context.getSenderId()));
        PregenTaskStorage.getStorage().collectListeners(context.getSenderId());
    }

    private static void pauseTask(PregenCommands.CommandContext context) {
        IProcessor processor = context.getActiveProcessor();
        if (processor == null) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.pause.no_task"));
            return;
        }
        if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.benchmark.pause"));
            return;
        }
        if (processor.isPaused()) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.pause.already"));
            return;
        }
        processor.pauseTask();
        context.sendSuccess(TextUtil.translate("commands.chunk_pregen.paused", processor.getTask().getName()));
    }

    private static void resumeTask(PregenCommands.CommandContext context) {
        IProcessor processor = context.getActiveProcessor();
        if (processor == null) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.resume.no_task"));
            return;
        }
        if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.benchmark.resume"));
            return;
        }
        if (!processor.isPaused()) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.resume.already"));
            return;
        }
        processor.resumeTask();
        context.sendSuccess(TextUtil.translate("commands.chunk_pregen.resumed", processor.getTask().getName()));
    }

    private static void stopTask(PregenCommands.CommandContext context) {
        IProcessor processor = context.getActiveProcessor();
        if (processor == null) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.stop.no_task"));
            return;
        }
        String name = processor.getTask().getName();
        processor.stop(false);
        context.sendSuccess(TextUtil.translate("commands.chunk_pregen.stopped", name));
        if (context.getArgumentOrDefault("delete", Boolean.class, false).booleanValue()) {
            PregenTaskStorage.getStorage().removeTask(name);
            context.sendSuccess(TextUtil.translate("commands.chunk_pregen.removed", name));
        }
    }

    private static void continueTask(PregenCommands.CommandContext context) {
        IProcessor processor = context.getActiveProcessor();
        if (processor != null) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.continue.already"));
            return;
        }
        PregenTaskStorage storage = PregenTaskStorage.getStorage();
        String taskId = context.getArgumentOrDefault("Task Name", String.class, null);
        if (taskId == null) {
            IBaseTask task = storage.getNextTask();
            if (task == null) {
                context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.continue.no_task"));
                return;
            }
            context.continueTask(task);
            return;
        }
        IBaseTask task = storage.findTask(taskId);
        if (task == null) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.continue.couldnt_find", taskId));
            return;
        }
        context.continueTask(task);
    }

    private static void clearTask(PregenCommands.CommandContext context) {
        IProcessor processor = context.getActiveProcessor();
        if (processor != null) {
            String name = processor.getTask().getName();
            processor.stop(false);
            context.sendSuccess(TextUtil.translate("commands.chunk_pregen.stopped", name));
        }
        PregenTaskStorage storage = PregenTaskStorage.getStorage();
        String taskId = context.getArgumentOrDefault("Task Name", String.class, null);
        if (taskId == null) {
            storage.clearAll();
            context.sendSuccess(TextUtil.translate("commands.chunk_pregen.removed_all"));
            return;
        }
        if (!storage.removeTask(taskId)) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.remove.no_task", taskId));
            return;
        }
        context.sendSuccess(TextUtil.translate("commands.chunk_pregen.removed", taskId));
    }

    private static void showTaskList(PregenCommands.CommandContext context) {
        PregenTaskStorage storage = PregenTaskStorage.getStorage();
        IBaseTask active = context.getActiveTask();
        boolean empty = true;
        for (IBaseTask task : storage.getAllTasks()) {
            empty = false;
            ITextComponent desc = task.getDescription();
            if (task == active) {
                desc.func_150257_a(TextUtil.translate("task.chunk_pregen.active_task"));
            }
            context.sendSuccess(desc);
        }
        if (empty) {
            context.sendFailure(TextUtil.translate("task.chunk_pregen.no_tasks"));
        }
    }

    private static void unload(PregenCommands.CommandContext context) {
        int dimension = context.getArgument("dimension", Integer.class);
        WorldServer world = DimensionManager.getWorld((int)dimension);
        if (world == null) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.unloaded_dimension"));
            return;
        }
        if (dimension == 0) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.overworld_dimension"));
            return;
        }
        if (world.field_73010_i.size() > 0) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.player_dimension"));
            return;
        }
        DimensionManager.unloadWorld((int)dimension);
        context.sendSuccess(TextUtil.translate("commands.chunk_pregen.dimension.unloaded", TextUtil.dimension(dimension), TextUtil.NUMBERS.format(dimension)));
    }

    private static void unloadRange(PregenCommands.CommandContext context) {
        int to;
        int from = context.getArgument("from", Integer.class);
        if (from > (to = context.getArgument("to", Integer.class).intValue())) {
            int temp = from;
            from = to;
            to = temp;
        }
        for (int i = from; i < to; ++i) {
            if (!DimensionManager.isDimensionRegistered((int)i)) continue;
            context.sendSuccess(TextUtil.translate("commands.chunk_pregen.dimension.unloading", TextUtil.dimension(i), TextUtil.NUMBERS.format(i)));
            WorldServer world = DimensionManager.getWorld((int)i);
            if (world == null) {
                context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.unloaded_dimension"));
                continue;
            }
            if (i == 0) {
                context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.overworld_dimension"));
                continue;
            }
            if (world.field_73010_i.size() > 0) {
                context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.player_dimension"));
                continue;
            }
            DimensionManager.unloadWorld((int)i);
            context.sendSuccess(TextUtil.translate("commands.chunk_pregen.dimension.unloaded", TextUtil.dimension(i), TextUtil.NUMBERS.format(i)));
        }
    }

    private static void priorityStatus(PregenCommands.CommandContext context) {
        context.sendSuccess(TextUtil.translate(PregenConfig.INSTANCE.priority.get().isPregenerator() ? "commands.chunk_pregen.priority.game" : "commands.chunk_pregen.priority.pregenerator"));
    }

    private static void setPriority(PregenCommands.CommandContext context) {
        Priority prio = context.getArgument("priority", Priority.class);
        PregenConfig config = PregenConfig.INSTANCE;
        config.priority.set(prio);
        config.save();
        context.sendSuccess(TextUtil.translate(prio == Priority.PREGENERATOR ? "commands.chunk_pregen.priority.set.pregenerator" : "commands.chunk_pregen.priority.set.game"));
    }

    private static void timePerTickStatus(PregenCommands.CommandContext context) {
        context.sendSuccess(TextUtil.translate("commands.chunk_pregen.time_per_tick", TextUtil.NUMBERS.format(PregenConfig.INSTANCE.timePerTick.get())));
    }

    private static void setTimePerTick(PregenCommands.CommandContext context) {
        int timePerTick = context.getArgument("time", Integer.class);
        PregenConfig config = PregenConfig.INSTANCE;
        config.timePerTick.set(timePerTick);
        config.save();
        context.sendSuccess(TextUtil.translate("commands.chunk_pregen.time_per_tick.set", TextUtil.NUMBERS.format(timePerTick)));
    }

    private static void trackerStatus(PregenCommands.CommandContext context) {
        context.sendSuccess(TextUtil.translate(ServerTracker.INSTANCE.isEnabled() ? "commands.chunk_pregen.tracker.status.enabled" : "commands.chunk_pregen.tracker.status.disabled"));
    }

    private static void enableTracker(PregenCommands.CommandContext context) {
        if (ServerTracker.INSTANCE.isEnabled()) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.tracker.enable"));
            return;
        }
        ServerTracker.INSTANCE.enable();
        context.sendSuccess(TextUtil.translate("commands.chunk_pregen.tracker.enable"));
    }

    private static void disableTracker(PregenCommands.CommandContext context) {
        if (!ServerTracker.INSTANCE.isEnabled()) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.tracker.enable"));
            return;
        }
        ServerTracker.INSTANCE.disable();
        context.sendSuccess(TextUtil.translate("commands.chunk_pregen.tracker.disable"));
    }

    private static void gc(PregenCommands.CommandContext context) {
        context.sendSuccess(TextUtil.translate("commands.chunk_pregen.gc.start"));
        System.gc();
        context.sendSuccess(TextUtil.translate("commands.chunk_pregen.gc.finish"));
    }

    public static enum Priority {
        GAME,
        PREGENERATOR;


        public boolean isPregenerator() {
            return this == PREGENERATOR;
        }
    }
}

