/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.commands;

import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.storage.ThreadedFileIOBase;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.commands.base.CommandBuilder;
import pregenerator.impl.commands.base.CommandNode;
import pregenerator.impl.commands.base.PregenCommand;
import pregenerator.impl.commands.base.PregenCommands;
import pregenerator.impl.commands.base.args.DimensionArgument;
import pregenerator.impl.commands.base.args.EnumArgument;
import pregenerator.impl.commands.base.args.PositionArgument;
import pregenerator.impl.commands.base.args.RangeArgument;
import pregenerator.impl.commands.base.args.StringArgument;
import pregenerator.impl.commands.base.args.TimeArgument;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.misc.GenShape;
import pregenerator.impl.processor.deleter.tasks.DeletionExcess;
import pregenerator.impl.processor.deleter.tasks.DeletionSpecific;
import pregenerator.impl.processor.deleter.tasks.DeletionTimeout;

public class DeletionCommands {
    public static CommandNode createDeletionCommands() {
        CommandBuilder builder = new CommandBuilder("delete");
        PregenCommand radius = DeletionCommands::executeRadius;
        builder.literal("radius");
        builder.arg("Task Name", StringArgument.text());
        builder.arg("Shape", EnumArgument.value(GenShape.class));
        builder.arg("Center", PositionArgument.chunkPos());
        builder.arg("Radius", RangeArgument.chunkRange(1, 25000), radius);
        builder.arg("Dimension", DimensionArgument.any(), radius).popTop();
        PregenCommand expansion = DeletionCommands::executeExpansion;
        builder.literal("expansion");
        builder.arg("Task Name", StringArgument.text());
        builder.arg("Shape", EnumArgument.value(GenShape.class));
        builder.arg("Center", PositionArgument.chunkPos());
        builder.arg("Min Radius", RangeArgument.chunkRange(1, Integer.MAX_VALUE));
        builder.arg("Max Radius", RangeArgument.chunkRange(1, Integer.MAX_VALUE), expansion);
        builder.arg("Dimension", DimensionArgument.any(), expansion).popTop();
        PregenCommand area = DeletionCommands::executeAreas;
        builder.literal("area");
        builder.arg("Task Name", StringArgument.text());
        builder.arg("Shape", EnumArgument.value(GenShape.class));
        builder.arg("From", PositionArgument.chunkPos());
        builder.arg("To", PositionArgument.chunkPos(), area);
        builder.arg("Dimension", DimensionArgument.any(), area).popTop();
        PregenCommand trim = DeletionCommands::executeTrim;
        builder.literal("trim");
        builder.arg("Task Name", StringArgument.text());
        builder.arg("Center", PositionArgument.chunkPos());
        builder.arg("Min Radius", RangeArgument.chunkMin(1), trim);
        builder.arg("Dimension", DimensionArgument.any(), trim).popTop();
        PregenCommand timout = DeletionCommands::executeTrim;
        builder.literal("trim");
        builder.arg("Task Name", StringArgument.text());
        builder.arg("Center", PositionArgument.chunkPos());
        builder.arg("Min Radius", RangeArgument.chunkMin(1));
        builder.arg("Min Time", TimeArgument.time(), timout);
        builder.arg("Dimension", DimensionArgument.any(), timout).popTop();
        PregenCommand single = DeletionCommands::executeSingle;
        builder.literal("single");
        builder.arg("Task Name", StringArgument.text());
        builder.arg("Position", PositionArgument.chunkPos(), single);
        builder.arg("Dimension", DimensionArgument.any(), single).popTop();
        PregenCommand dimension = DeletionCommands::executeDimension;
        builder.literal("dimension");
        builder.arg("Dimension", DimensionArgument.any(), dimension).popTop();
        return builder.build();
    }

    public static void executeDimension(PregenCommands.CommandContext context) {
        int dimension = context.getArgument("Dimension", Integer.class);
        if (!DimensionManager.isDimensionRegistered((int)dimension)) {
            context.sendFailure(TextUtil.dimensionMissing());
            return;
        }
        if (DimensionManager.getWorld((int)dimension) != null) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.dimension_loaded"));
            return;
        }
        if (context.isRunning()) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.already_active_dimension"));
            return;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        String folder = DimensionManager.getProviderType((int)dimension).func_186070_d().getSaveFolder();
        Path newFolder = server.func_71254_M().func_186352_b(server.func_71270_I(), ".").toPath().resolve(folder == null ? "." : folder);
        Path region = newFolder.resolve("region");
        Path data = newFolder.resolve("data");
        boolean regionExists = Files.exists(region, new LinkOption[0]);
        boolean dataExists = Files.exists(data, new LinkOption[0]);
        if (!regionExists && !dataExists) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.dimension.no_data"));
            return;
        }
        try {
            ThreadedFileIOBase.func_178779_a().func_75734_a();
            RegionFileCache.func_76551_a();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (regionExists) {
                Files.walk(region, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(TextUtil::delete);
            }
            if (dataExists) {
                Files.walk(data, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(TextUtil::delete);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.dimension.failure"));
            return;
        }
        context.sendSuccess(TextUtil.translate("deleter.chunk_pregen.dimension", TextUtil.dimension(dimension)));
    }

    public static void executeSingle(PregenCommands.CommandContext context) {
        String name = context.getArgument("Task Name", String.class);
        FilePos position = context.getArgument("Position", FilePos.class);
        int dimension = context.getDimension("Dimension");
        if (!DimensionManager.isDimensionRegistered((int)dimension)) {
            context.sendFailure(TextUtil.dimensionMissing());
            return;
        }
        context.startTask(new DeletionSpecific(name, dimension, Arrays.asList(position.asLong())));
    }

    public static void executeTimeOut(PregenCommands.CommandContext context) {
        String name = context.getArgument("Task Name", String.class);
        FilePos center = context.getArgument("Center", FilePos.class);
        int radius = context.getArgument("Min Radius", Integer.class);
        long time = context.getArgument("Min Time", Long.class);
        int dimension = context.getDimension("Dimension");
        if (!DimensionManager.isDimensionRegistered((int)dimension)) {
            context.sendFailure(TextUtil.dimensionMissing());
            return;
        }
        context.startTask(new DeletionTimeout(name, dimension, center, radius, time));
    }

    public static void executeTrim(PregenCommands.CommandContext context) {
        String name = context.getArgument("Task Name", String.class);
        FilePos center = context.getArgument("Center", FilePos.class);
        int radius = context.getArgument("Min Radius", Integer.class);
        int dimension = context.getDimension("Dimension");
        if (!DimensionManager.isDimensionRegistered((int)dimension)) {
            context.sendFailure(TextUtil.dimensionMissing());
            return;
        }
        context.startTask(new DeletionExcess(name, dimension, center, radius));
    }

    private static void executeAreas(PregenCommands.CommandContext context) {
        String name = context.getArgument("Task Name", String.class);
        GenShape shape = context.getArgument("Shape", GenShape.class);
        FilePos min = context.getArgument("From", FilePos.class);
        FilePos max = context.getArgument("To", FilePos.class);
        int dimension = context.getDimension("Dimension");
        if (!DimensionManager.isDimensionRegistered((int)dimension)) {
            context.sendFailure(TextUtil.dimensionMissing());
            return;
        }
        FilePos minPos = new FilePos(min.x < max.x ? min.x : max.x, min.z < max.z ? min.z : max.z);
        FilePos maxPos = new FilePos(min.x > max.x ? min.x : max.x, min.z > max.z ? min.z : max.z);
        context.startTask(shape.createAreaDeleteTask(name, minPos, maxPos, dimension));
    }

    private static void executeExpansion(PregenCommands.CommandContext context) {
        String name = context.getArgument("Task Name", String.class);
        GenShape shape = context.getArgument("Shape", GenShape.class);
        FilePos center = context.getArgument("Center", FilePos.class);
        int minRadius = context.getArgument("Min Radius", Integer.class);
        int maxRadius = context.getArgument("Max Radius", Integer.class);
        int dimension = context.getDimension("Dimension");
        if (minRadius > maxRadius) {
            context.sendFailure(TextUtil.minBiggerThenMax());
            return;
        }
        if (!DimensionManager.isDimensionRegistered((int)dimension)) {
            context.sendFailure(TextUtil.dimensionMissing());
            return;
        }
        context.startTask(shape.createExpansionDeleteTask(name, center.x, center.z, minRadius, maxRadius, dimension));
    }

    private static void executeRadius(PregenCommands.CommandContext context) {
        String name = context.getArgument("Task Name", String.class);
        GenShape shape = context.getArgument("Shape", GenShape.class);
        FilePos center = context.getArgument("Center", FilePos.class);
        int radius = context.getArgument("Radius", Integer.class);
        int dimension = context.getDimension("Dimension");
        if (!DimensionManager.isDimensionRegistered((int)dimension)) {
            context.sendFailure(TextUtil.dimensionMissing());
            return;
        }
        context.startTask(shape.createRadiusDeleteTask(name, center.x, center.z, radius, dimension));
    }
}

