/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.commands;

import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.commands.base.CommandBuilder;
import pregenerator.impl.commands.base.CommandNode;
import pregenerator.impl.commands.base.PregenCommands;
import pregenerator.impl.commands.base.args.StringArgument;
import pregenerator.impl.retrogen.RetrogenManager;

public class RetrogenCommands {
    public static CommandNode createRetrogenCommands() {
        CommandBuilder builder = new CommandBuilder("retrogen");
        builder.literal("add");
        builder.arg("id", StringArgument.text(), RetrogenCommands::inactiveSuggestions, RetrogenCommands::activateRetrogen).popTop();
        builder.literal("remove");
        builder.arg("id", StringArgument.text(), RetrogenCommands::activeSuggestions, RetrogenCommands::deactivateRetrogen).popTop();
        builder.literal("show", RetrogenCommands::showActive).popTop();
        builder.literal("list", RetrogenCommands::listAll);
        builder.literal("sorted", RetrogenCommands::listMods);
        builder.arg("mod", StringArgument.text(), RetrogenCommands::modSuggestions, RetrogenCommands::listModSelected).popTop();
        return builder.build();
    }

    private static void inactiveSuggestions(PregenCommands.CommandContext context, int argumentIndex, Consumer<String> values) {
        RetrogenManager.INSTANCE.getInactiveGenerators().forEach(values);
    }

    private static void activeSuggestions(PregenCommands.CommandContext context, int argumentIndex, Consumer<String> values) {
        RetrogenManager.INSTANCE.getActiveGenerators().forEach(values);
    }

    private static void modSuggestions(PregenCommands.CommandContext context, int argumentIndex, Consumer<String> values) {
        RetrogenManager.INSTANCE.getKnownMods().forEach(values);
    }

    private static void showActive(PregenCommands.CommandContext context) {
        Set<String> locations = RetrogenManager.INSTANCE.getActiveGenerators();
        if (locations.isEmpty()) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.retrogen.error.empty"));
            return;
        }
        context.sendSuccess(TextUtil.translate("commands.chunk_pregen.retrogen.enabled", locations.size()));
        for (String location : locations) {
            context.sendSuccess(TextUtil.translate("commands.chunk_pregen.retrogen.feature", location, TextUtil.translate("commands.chunk_pregen.retrogen.disable").func_150259_f().func_150255_a(RetrogenCommands.createCommand(location, false))));
        }
    }

    private static void listAll(PregenCommands.CommandContext context) {
        RetrogenCommands.list(context, RetrogenManager.INSTANCE.getAllGenerators());
    }

    private static void listMods(PregenCommands.CommandContext context) {
        List<String> list = RetrogenManager.INSTANCE.getKnownMods();
        list.sort(String.CASE_INSENSITIVE_ORDER);
        for (String s : list) {
            Style style = new Style().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/pregen retrogen list sorted " + s)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextUtil.translate("commands.chunk_pregen.retrogen.list")));
            context.sendSuccess(TextUtil.translate("commands.chunk_pregen.retrogen.mod", TextUtil.applyTextStyle(TextUtil.literalPascal(s).func_150255_a(style), TextFormatting.GOLD)));
        }
    }

    private static void listModSelected(PregenCommands.CommandContext context) {
        RetrogenCommands.list(context, RetrogenManager.INSTANCE.getGeneratorsForMod(context.getArgument("mod", String.class)));
    }

    private static void list(PregenCommands.CommandContext context, List<String> locations) {
        locations.removeAll(RetrogenManager.INSTANCE.getActiveGenerators());
        if (locations.isEmpty()) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.retrogen.full"));
            return;
        }
        locations.sort(String.CASE_INSENSITIVE_ORDER);
        context.sendSuccess(TextUtil.translate("commands.chunk_pregen.retrogen.disabled", locations.size()));
        for (String location : locations) {
            context.sendSuccess(TextUtil.translate("commands.chunk_pregen.retrogen.feature", TextUtil.applyTextStyle(TextUtil.literal(RetrogenManager.INSTANCE.getModForGenerator(location)), TextFormatting.BLUE), TextUtil.applyTextStyle(TextUtil.literal(location), TextFormatting.GOLD)).func_150255_a(RetrogenCommands.createCommand(location, true)));
        }
    }

    private static void activateRetrogen(PregenCommands.CommandContext context) {
        if (context.isRunning()) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.retrogen.active"));
            return;
        }
        RetrogenManager handler = RetrogenManager.INSTANCE;
        String value = context.getArgument("id", String.class);
        if (!handler.isValidGenerator(value)) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.retrogen.invalid_type"));
            return;
        }
        handler.enableGenerator(value);
        context.sendSuccess(TextUtil.translate("commands.chunk_pregen.retrogen.add", value));
    }

    private static void deactivateRetrogen(PregenCommands.CommandContext context) {
        if (context.isRunning()) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.retrogen.active"));
            return;
        }
        RetrogenManager handler = RetrogenManager.INSTANCE;
        String value = context.getArgument("id", String.class);
        if (!handler.isValidGenerator(value)) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.retrogen.invalid_type"));
            return;
        }
        handler.disableGenerator(value);
        context.sendSuccess(TextUtil.translate("commands.chunk_pregen.retrogen.remove", value));
    }

    private static Style createCommand(String args, boolean add) {
        String s = (add ? "/pregen retrogen add " : "/pregen retrogen remove ") + args;
        return new Style().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, s)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextUtil.translate(add ? "commands.chunk_pregen.retrogen.enable" : "commands.chunk_pregen.retrogen.disable")));
    }
}

