/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.commands.base;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.commands.BaseCommands;
import pregenerator.impl.commands.BenchmarkCommands;
import pregenerator.impl.commands.DeletionCommands;
import pregenerator.impl.commands.GenCommands;
import pregenerator.impl.commands.InfoCommands;
import pregenerator.impl.commands.RetrogenCommands;
import pregenerator.impl.commands.StructureCommands;
import pregenerator.impl.commands.base.CommandNode;
import pregenerator.impl.commands.base.LiteralNode;
import pregenerator.impl.commands.base.args.StringWalker;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.processor.IBaseTask;
import pregenerator.impl.processor.IProcessor;
import pregenerator.impl.processor.deleter.DeleteProcessor;
import pregenerator.impl.processor.generator.BenchmarkManager;
import pregenerator.impl.processor.generator.ChunkProcessor;
import pregenerator.impl.processor.generator.tasks.ITask;
import pregenerator.impl.storage.PregenTaskStorage;

public class PregenCommands
extends CommandBase {
    CommandNode root = new LiteralNode("pregen");

    public PregenCommands() {
        LiteralNode node = new LiteralNode("start");
        node.addChild(GenCommands.createGenCommand());
        node.addChild(DeletionCommands.createDeletionCommands());
        node.addChild(BenchmarkCommands.createBenchmarkCommands());
        this.addChild(node);
        this.addChild(RetrogenCommands.createRetrogenCommands());
        this.addChildren(BaseCommands.createControlTasks());
        this.addChild(BaseCommands.createUtilCommands());
        this.addChild(InfoCommands.createInfoCommands());
        this.addChild(StructureCommands.createStructureCommands());
    }

    private void addChild(CommandNode child) {
        this.root.addChild(child);
    }

    private void addChildren(CommandNode node) {
        node.getChildren().forEach(this::addChild);
    }

    public String func_71517_b() {
        return "pregen";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/pregen allows you to Generate/Delete/Scan/Track worlds";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        CommandContext context = new CommandContext(sender);
        CommandNode node = this.root.findCurrentNode(new StringWalker(args), context);
        if (context.getException() != null) {
            context.sendFailure(context.getException());
            return;
        }
        if (node == null) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.command.notfound", "/pregen " + String.join((CharSequence)" ", args)));
            return;
        }
        if (node.getCommand() == null) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.command.missingargs"));
            return;
        }
        node.getCommand().execute(context);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        CommandContext context = new CommandContext(sender);
        StringWalker walker = new StringWalker(args);
        walker.capTop();
        CommandNode node = this.root.findCurrentNode(walker, context);
        walker.resetCap();
        return PregenCommands.getBestMatch(walker.canRead() ? walker.peek() : null, (node == null ? this.root : node).getSuggestions(context.getArgumentIndex(), context));
    }

    public static List<String> getBestMatch(String argument, Collection<String> args) {
        ObjectArrayList results = new ObjectArrayList();
        for (String arg : args) {
            if (argument != null && !arg.regionMatches(true, 0, argument, 0, argument.length())) continue;
            results.add(arg);
        }
        return results;
    }

    public static class CommandContext {
        ICommandSender sender;
        List<CommandNode> nodes = new ObjectArrayList();
        Map<String, Object> args = new Object2ObjectOpenHashMap();
        String argumentId;
        ITextComponent exception;
        int argumentIndex;

        public CommandContext(ICommandSender sender) {
            this.sender = sender;
        }

        public void setException(String argumentId, ITextComponent exception) {
            this.argumentId = argumentId;
            this.exception = exception;
        }

        public ITextComponent getException() {
            return this.exception;
        }

        public void setArgumentIndex(int index) {
            this.argumentIndex = index;
        }

        public int getArgumentIndex() {
            return this.argumentIndex;
        }

        public void addNode(CommandNode node) {
            this.nodes.add(node);
            this.exception = null;
        }

        public boolean addArgument(String name, Object arg) {
            this.args.put(name, arg);
            return true;
        }

        public <T> T getArgument(String name, Class<T> clz) {
            Object arg = this.args.get(name);
            if (arg == null) {
                throw new IllegalStateException("Argument [" + name + "] is missing");
            }
            if (clz.isInstance(arg)) {
                return clz.cast(arg);
            }
            throw new IllegalStateException("Argument [" + name + "] is of type [" + arg.getClass().getSimpleName() + "], but was expected to be [" + clz + "]");
        }

        public <T> T getArgumentOrDefault(String name, Class<T> clz, T defaultValue) {
            Object arg = this.args.get(name);
            return arg != null && clz.isInstance(arg) ? clz.cast(arg) : defaultValue;
        }

        public <T> boolean hasArgument(String name, Class<T> clz) {
            Object arg = this.args.get(name);
            return arg != null && clz.isInstance(arg);
        }

        public int getDimension(String name) {
            return this.getArgumentOrDefault(name, Integer.class, this.getSenderDimensionId());
        }

        public ICommandSender getSender() {
            return this.sender;
        }

        public ITextComponent getSenderName() {
            return this.sender.func_145748_c_();
        }

        public UUID getSenderId() {
            Entity entity = this.sender.func_174793_f();
            return entity != null ? entity.func_110124_au() : null;
        }

        public World getSenderDimension() {
            return this.sender.func_130014_f_();
        }

        public int getSenderDimensionId() {
            return this.sender.func_130014_f_().field_73011_w.getDimension();
        }

        public WorldServer getWorld(int dimension) {
            return FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dimension);
        }

        public FilePos getSenderPosition() {
            BlockPos pos = this.sender.func_180425_c();
            return new FilePos(pos.func_177958_n(), pos.func_177952_p());
        }

        public FilePos getSpawnPosition() {
            BlockPos pos = this.sender.func_130014_f_().func_175694_M();
            return new FilePos(pos.func_177958_n(), pos.func_177952_p());
        }

        public boolean storeTask(IBaseTask task) {
            return PregenTaskStorage.getStorage().storeTask(task, (MessagePassingQueue.Consumer<ITextComponent>)((MessagePassingQueue.Consumer)this::sendFailure));
        }

        public void startTask(IBaseTask task) {
            if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
                this.sendFailure(TextUtil.translate("commands.chunk_pregen.benchmark.active_queue"));
                return;
            }
            if (!this.storeTask(task)) {
                return;
            }
            PregenTaskStorage.getStorage().collectListeners(this.getSenderId());
            this.startWorkers(task);
        }

        public void continueTask(IBaseTask task) {
            if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
                this.sendFailure(TextUtil.translate("commands.chunk_pregen.benchmark.active_queue"));
                return;
            }
            PregenTaskStorage.getStorage().collectListeners(this.getSenderId());
            this.startWorkers(task);
        }

        public void startWorkers(IBaseTask task) {
            if (this.isRunning()) {
                this.sendFailure(TextUtil.translate("commands.chunk_pregen.error.already_active"));
                return;
            }
            task.start();
        }

        public boolean isRunning() {
            return ChunkProcessor.INSTANCE.isRunning() || DeleteProcessor.INSTANCE.isRunning();
        }

        public IProcessor getActiveProcessor() {
            ChunkProcessor process = ChunkProcessor.INSTANCE;
            if (process.isRunning()) {
                return process;
            }
            DeleteProcessor deleter = DeleteProcessor.INSTANCE;
            return deleter.isRunning() ? deleter : null;
        }

        public IBaseTask getActiveTask() {
            ITask task = ChunkProcessor.INSTANCE.getTask();
            return task != null ? task : DeleteProcessor.INSTANCE.getTask();
        }

        public void printException() {
            this.sendFailure(TextUtil.translate("commands.chunk_pregen.error.command.argument_failed", this.argumentId, this.exception));
        }

        private boolean isInstalledOnClient() {
            Entity entity = this.sender.func_174793_f();
            if (!(entity instanceof EntityPlayerMP)) {
                return true;
            }
            return ChunkPregenerator.NETWORKING.isInstalledOnClient((EntityPlayerMP)entity);
        }

        private void sendMessage(ITextComponent text) {
            this.sender.func_145747_a(this.isInstalledOnClient() ? text : TextUtil.serverTranslate(text));
        }

        public void sendSuccess(ITextComponent text) {
            this.sendMessage(text);
        }

        public void sendFailure(ITextComponent text) {
            this.sendMessage(TextUtil.applyTextStyle(text.func_150259_f(), TextFormatting.RED));
        }
    }
}

