/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.commands.base.args;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraftforge.common.DimensionManager;
import pregenerator.impl.commands.base.PregenCommands;
import pregenerator.impl.commands.base.args.IArgument;
import pregenerator.impl.commands.base.args.StringWalker;

public class DimensionArgument
implements IArgument<Integer> {
    boolean loaded;

    protected DimensionArgument(boolean loaded) {
        this.loaded = loaded;
    }

    public static DimensionArgument loaded() {
        return new DimensionArgument(true);
    }

    public static DimensionArgument any() {
        return new DimensionArgument(false);
    }

    @Override
    public Integer parse(StringWalker args, PregenCommands.CommandContext context) throws CommandException {
        int value = args.readInt();
        if (this.loaded ? DimensionManager.getWorld((int)value) == null : !DimensionManager.isDimensionRegistered((int)value)) {
            throw new CommandException("commands.chunk_pregen.error.parse.dimension_missing", new Object[]{value});
        }
        return value;
    }

    @Override
    public List<String> getExamples(PregenCommands.CommandContext context, int argumentIndex) {
        ObjectArrayList list = new ObjectArrayList();
        for (Integer entry : this.loaded ? DimensionManager.getIDs() : DimensionManager.getStaticDimensionIDs()) {
            list.add(entry.toString());
        }
        return list;
    }
}

