/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.commands.base.args;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.command.CommandException;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.commands.base.PregenCommands;
import pregenerator.impl.commands.base.args.IArgument;
import pregenerator.impl.commands.base.args.StringWalker;

public class LongArgument
implements IArgument<Long> {
    private static final List<String> EXAMPLES = ObjectArrayList.wrap((Object[])new String[]{"0", "123", "-123"});
    long min;
    long max;

    protected LongArgument(long min, long max) {
        this.min = min;
        this.max = max;
    }

    public static LongArgument value() {
        return new LongArgument(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public static LongArgument max(long max) {
        return new LongArgument(Long.MIN_VALUE, max);
    }

    public static LongArgument min(long min) {
        return new LongArgument(min, Long.MAX_VALUE);
    }

    public static LongArgument range(long min, long max) {
        return new LongArgument(min, max);
    }

    @Override
    public Long parse(StringWalker args, PregenCommands.CommandContext context) throws CommandException {
        long value = args.readLong();
        if (value < this.min) {
            throw new CommandException("commands.chunk_pregen.error.parse.to_small", new Object[]{TextUtil.NUMBERS.format(value), TextUtil.NUMBERS.format(this.min)});
        }
        if (value > this.max) {
            throw new CommandException("commands.chunk_pregen.error.parse.to_big", new Object[]{TextUtil.NUMBERS.format(value), TextUtil.NUMBERS.format(this.max)});
        }
        return value;
    }

    @Override
    public List<String> getExamples(PregenCommands.CommandContext context, int argumentIndex) {
        return EXAMPLES;
    }
}

