/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.commands.base.args;

import net.minecraft.command.CommandException;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.SyntaxErrorException;

public class StringWalker {
    String[] arguments;
    int max;
    int index;

    public StringWalker(String[] arguments) {
        this.arguments = arguments;
        this.max = arguments.length;
    }

    public StringWalker(String[] arguments, int index) {
        this.arguments = arguments;
        this.max = arguments.length;
        this.index = index;
    }

    public void apply(StringWalker other) {
        this.index = other.index;
    }

    public StringWalker copy() {
        return new StringWalker(this.arguments, this.index);
    }

    public void capTop() {
        --this.max;
    }

    public void resetCap() {
        this.max = this.arguments.length;
    }

    public boolean canRead() {
        return this.index < this.max;
    }

    public String peek() {
        return this.arguments[this.index];
    }

    public String poll() {
        return this.arguments[this.index++];
    }

    public void advance(int amount) {
        this.index += amount;
    }

    public void skip() {
        ++this.index;
    }

    public void undo() {
        --this.index;
    }

    public int getIndex() {
        return this.index;
    }

    public int parsePosition(int playerPos, int worldPos, boolean chunk) throws CommandException {
        if (!this.canRead()) {
            throw new CommandException("commands.chunk_pregen.error.parse.missing.args", new Object[0]);
        }
        String value = this.peek();
        try {
            int result = 0;
            int offset = 0;
            if (value.charAt(0) == '^') {
                result += worldPos;
                ++offset;
            } else if (value.charAt(0) == '~') {
                result += playerPos;
                ++offset;
            }
            boolean isBlock = value.charAt(value.length() - 1) == 'b';
            String subString = value.substring(offset, value.length() - (isBlock ? 1 : 0));
            if (!subString.isEmpty()) {
                result += Integer.parseInt(subString) / (isBlock && chunk ? 16 : 1);
            }
            this.skip();
            return result;
        }
        catch (Exception e) {
            throw new NumberInvalidException("commands.chunk_pregen.error.parse.int", new Object[]{value, e});
        }
    }

    public int parseChunkOrBlock(boolean chunk) throws CommandException {
        if (!this.canRead()) {
            throw new CommandException("commands.chunk_pregen.error.parse.missing.args", new Object[0]);
        }
        String value = this.peek();
        try {
            boolean isBlock = value.charAt(value.length() - 1) == 'b';
            int result = Integer.parseInt(value.substring(0, value.length() - (isBlock ? 1 : 0))) / (isBlock && chunk ? 16 : 1);
            this.skip();
            return result;
        }
        catch (Exception e) {
            throw new NumberInvalidException("commands.chunk_pregen.error.parse.int", new Object[]{value, e});
        }
    }

    public <T extends Enum<T>> T readEnum(Class<T> clz) throws CommandException {
        if (!this.canRead()) {
            throw new CommandException("commands.chunk_pregen.error.parse.missing.args", new Object[0]);
        }
        try {
            return Enum.valueOf(clz, this.poll());
        }
        catch (Exception e) {
            throw new NumberInvalidException("commands.chunk_pregen.error.parse.int", new Object[]{this.arguments[this.index - 1], e});
        }
    }

    public boolean readBoolean() throws CommandException {
        if (!this.canRead()) {
            throw new CommandException("commands.chunk_pregen.error.parse.missing.args", new Object[0]);
        }
        String arg = this.poll();
        if (arg.equalsIgnoreCase("true")) {
            return true;
        }
        if (arg.equalsIgnoreCase("false")) {
            return false;
        }
        throw new SyntaxErrorException("commands.chunk_pregen.error.parse.boolean", new Object[]{this.arguments[this.index - 1]});
    }

    public int readInt() throws CommandException {
        if (!this.canRead()) {
            throw new CommandException("commands.chunk_pregen.error.parse.missing.args", new Object[0]);
        }
        try {
            return Integer.parseInt(this.poll());
        }
        catch (Exception e) {
            throw new NumberInvalidException("commands.chunk_pregen.error.parse.int", new Object[]{this.arguments[this.index - 1], e});
        }
    }

    public long readLong() throws CommandException {
        if (!this.canRead()) {
            throw new CommandException("commands.chunk_pregen.error.parse.missing.args", new Object[0]);
        }
        try {
            return Long.parseLong(this.poll());
        }
        catch (Exception e) {
            throw new NumberInvalidException("commands.chunk_pregen.error.parse.long", new Object[]{this.arguments[this.index - 1], e});
        }
    }

    public double readDouble() throws CommandException {
        if (!this.canRead()) {
            throw new CommandException("commands.chunk_pregen.error.parse.missing.args", new Object[0]);
        }
        try {
            return Double.parseDouble(this.poll());
        }
        catch (Exception e) {
            throw new NumberInvalidException("commands.chunk_pregen.error.parse.double", new Object[]{this.arguments[this.index - 1], e});
        }
    }
}

