/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.config;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import pregenerator.config.api.IConfigSerializer;
import pregenerator.config.api.buffer.IReadBuffer;
import pregenerator.config.api.buffer.IWriteBuffer;
import pregenerator.config.utils.Helpers;
import pregenerator.config.utils.IEntryDataType;
import pregenerator.config.utils.ParseResult;
import pregenerator.impl.config.DimensionSuggestion;

public class SpeedEntry {
    int dim;
    float speed;

    public SpeedEntry() {
        this(0, 1.0f);
    }

    public SpeedEntry(int dim, float speed) {
        this.dim = dim;
        this.speed = speed;
    }

    public int getDimension() {
        return this.dim;
    }

    public float getSpeed() {
        return this.speed;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SpeedEntry) {
            SpeedEntry entry = (SpeedEntry)obj;
            return Float.compare(this.speed, entry.speed) == 0 && Objects.equals(this.dim, entry.dim);
        }
        return false;
    }

    public String[] serialize() {
        return new String[]{Integer.toString(this.dim), Float.toString(this.speed)};
    }

    public static List<SpeedEntry> getDefaultValues() {
        ObjectArrayList list = new ObjectArrayList();
        list.add(new SpeedEntry(0, 1.0f));
        list.add(new SpeedEntry(-1, 1.0f));
        list.add(new SpeedEntry(1, 1.0f));
        return list;
    }

    private static ParseResult<SpeedEntry> parse(String[] array) {
        if (array.length != 2) {
            return ParseResult.error(Helpers.mergeCompound(array), "Array Length isn't 2");
        }
        ParseResult<Integer> id = SpeedEntry.parseValue(array[0]);
        if (id.hasError()) {
            return id.onlyError();
        }
        ParseResult<Double> value = Helpers.parseDouble(array[1]);
        if (value.hasError()) {
            return value.onlyError();
        }
        return ParseResult.success(new SpeedEntry(id.getValue(), value.getValue().floatValue()));
    }

    private static ParseResult<Integer> parseValue(String value) {
        try {
            return ParseResult.success(Integer.parseInt(value));
        }
        catch (Exception e) {
            return ParseResult.error(value, e, "Couldn't parse Dimension");
        }
    }

    private static void write(IWriteBuffer buffer, SpeedEntry entry) {
        buffer.writeInt(entry.getDimension());
        buffer.writeFloat(entry.getSpeed());
    }

    private static SpeedEntry read(IReadBuffer buffer) {
        return new SpeedEntry(buffer.readInt(), buffer.readFloat());
    }

    public static IConfigSerializer<SpeedEntry> getSerializer() {
        IEntryDataType.CompoundDataType type = new IEntryDataType.CompoundDataType().withSuggestion("dimension", IEntryDataType.EntryDataType.INTEGER, DimensionSuggestion.INSTANCE).with("speed", IEntryDataType.EntryDataType.DOUBLE);
        return IConfigSerializer.withSync(type, new SpeedEntry(), SpeedEntry::parse, SpeedEntry::serialize, SpeedEntry::read, SpeedEntry::write);
    }
}

