/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.misc;

import java.util.BitSet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class Area {
    int minX;
    int minZ;
    int maxX;
    int maxZ;

    public Area(ChunkPos min, ChunkPos max) {
        this.minX = min.field_77276_a;
        this.minZ = min.field_77275_b;
        this.maxX = max.field_77276_a;
        this.maxZ = max.field_77275_b;
    }

    public Area(ChunkPos center, int radius) {
        this.minX = center.field_77276_a - radius;
        this.minZ = center.field_77275_b - radius;
        this.maxX = center.field_77276_a + radius;
        this.maxZ = center.field_77275_b + radius;
    }

    public Area(StructureBoundingBox box) {
        this.minX = box.field_78897_a;
        this.minZ = box.field_78896_c;
        this.maxX = box.field_78893_d;
        this.maxZ = box.field_78892_f;
    }

    public Area(ChunkPos pos, BitSet area) {
        this.minX = pos.field_77276_a;
        this.minZ = pos.field_77275_b;
        int x = 0;
        int z = 0;
        for (int i = 0; i < 1024; ++i) {
            if (!area.get(i)) continue;
            x = Math.max(x, i % 32);
            z = Math.max(z, i / 32);
        }
        this.maxX = this.minX + x + 1;
        this.maxZ = this.minZ + z + 1;
    }

    public Area(PacketBuffer buffer) {
        this.minX = buffer.readInt();
        this.minZ = buffer.readInt();
        this.maxX = buffer.readInt();
        this.maxZ = buffer.readInt();
    }

    public void expand(Area area) {
        this.minX = Math.min(this.minX, area.minX);
        this.minZ = Math.min(this.minZ, area.minZ);
        this.maxX = Math.min(this.maxX, area.maxX);
        this.maxZ = Math.min(this.maxZ, area.maxZ);
    }

    public int getMinX() {
        return this.minX << 4;
    }

    public int getMaxX() {
        return this.maxX << 4;
    }

    public int getMinZ() {
        return this.minZ << 4;
    }

    public int getMaxZ() {
        return this.maxZ << 4;
    }

    public void write(PacketBuffer buffer) {
        buffer.writeInt(this.minX);
        buffer.writeInt(this.minZ);
        buffer.writeInt(this.maxX);
        buffer.writeInt(this.maxZ);
    }
}

