/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.misc;

import java.util.LinkedList;

public class DeltaTimer {
    LinkedList<Long> lastTimes = new LinkedList();
    long lastTime = -1L;
    long averageTime = 0L;

    public void start() {
        this.lastTime = System.currentTimeMillis();
    }

    public long averageDelta() {
        long newTime = System.currentTimeMillis();
        long delta = newTime - this.lastTime;
        this.lastTimes.add(delta);
        this.lastTime = newTime;
        this.averageTime += delta;
        if (this.lastTimes.size() > 20) {
            this.averageTime -= this.lastTimes.removeFirst().longValue();
        }
        return this.averageTime / (long)this.lastTimes.size();
    }

    public boolean hasValues() {
        return this.lastTimes.size() > 0;
    }

    public long getAverageDelta() {
        return this.lastTimes.isEmpty() ? 0L : this.averageTime / (long)this.lastTimes.size();
    }

    public void finishDeltaTime() {
        long time = this.lastTimes.removeLast();
        this.averageTime -= time;
        this.lastTimes.addLast(time += this.getDeltaTime());
        this.averageTime += time;
    }

    public long getDeltaTime() {
        return System.currentTimeMillis() - this.lastTime;
    }

    public void reset() {
        this.lastTime = -1L;
        this.averageTime = 0L;
        this.lastTimes.clear();
    }
}

