/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.misc;

import net.minecraft.util.text.ITextComponent;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.processor.deleter.tasks.DeletionCircle;
import pregenerator.impl.processor.deleter.tasks.DeletionCircleArea;
import pregenerator.impl.processor.deleter.tasks.DeletionCircleExpansion;
import pregenerator.impl.processor.deleter.tasks.DeletionSquare;
import pregenerator.impl.processor.deleter.tasks.DeletionSquareArea;
import pregenerator.impl.processor.deleter.tasks.DeletionSquareExpansion;
import pregenerator.impl.processor.deleter.tasks.IDeletionTask;
import pregenerator.impl.processor.generator.GenerationType;
import pregenerator.impl.processor.generator.tasks.CircleAreaTask;
import pregenerator.impl.processor.generator.tasks.CircleExpansionTask;
import pregenerator.impl.processor.generator.tasks.CircleTask;
import pregenerator.impl.processor.generator.tasks.ITask;
import pregenerator.impl.processor.generator.tasks.SquareAreaTask;
import pregenerator.impl.processor.generator.tasks.SquareExpansionTask;
import pregenerator.impl.processor.generator.tasks.SquareTask;

public enum GenShape {
    SQUARE{

        @Override
        public long calculateRadius(long radius) {
            return radius * radius * 4L;
        }

        @Override
        public long calculateRadius(long minRadius, long maxRadius) {
            return maxRadius * maxRadius * 4L - minRadius * minRadius * 4L;
        }

        @Override
        public long calculateRadius(FilePos from, FilePos to) {
            return (long)((to.x - to.x) * (to.z - to.z)) * 4L;
        }

        @Override
        public boolean isInsideArea(int radius, int x, int z) {
            return x >= -radius || x < radius || z >= -radius || z < radius;
        }

        @Override
        public ITextComponent getName() {
            return TextUtil.translate("task.chunk_pregen.shape_type.square");
        }

        @Override
        public ITask createRadiusGenTask(String name, int x, int z, int radius, GenerationType type, int dimensionId) {
            return new SquareTask(name, dimensionId, type, new FilePos(x, z), radius);
        }

        @Override
        public ITask createExpansionGenTask(String name, int x, int z, int minRadius, int maxRadius, GenerationType type, int dimensionId) {
            return new SquareExpansionTask(name, dimensionId, type, new FilePos(x, z), minRadius, maxRadius);
        }

        @Override
        public ITask createAreaGenTask(String name, FilePos min, FilePos max, GenerationType type, int dimensionId) {
            return new SquareAreaTask(name, dimensionId, type, min, max);
        }

        @Override
        public IDeletionTask createRadiusDeleteTask(String name, int x, int z, int radius, int dimensionId) {
            return new DeletionSquare(name, dimensionId, new FilePos(x, z), radius);
        }

        @Override
        public IDeletionTask createExpansionDeleteTask(String name, int x, int z, int minRadius, int maxRadius, int dimensionId) {
            return new DeletionSquareExpansion(name, dimensionId, new FilePos(x, z), minRadius, maxRadius);
        }

        @Override
        public IDeletionTask createAreaDeleteTask(String name, FilePos min, FilePos max, int dimensionId) {
            return new DeletionSquareArea(name, dimensionId, min, max);
        }
    }
    ,
    CIRCLE{

        @Override
        public long calculateRadius(long radius) {
            return (long)((double)(radius * radius) * Math.PI);
        }

        @Override
        public long calculateRadius(long minRadius, long maxRadius) {
            return (long)((double)(maxRadius * maxRadius) * Math.PI - (double)(minRadius * minRadius) * Math.PI);
        }

        @Override
        public long calculateRadius(FilePos from, FilePos to) {
            return (long)((double)((to.x - to.x) * (to.z - to.z)) * Math.PI * 0.25);
        }

        @Override
        public boolean isInsideArea(int radius, int x, int z) {
            return x * x + z * z < radius * radius;
        }

        @Override
        public ITextComponent getName() {
            return TextUtil.translate("task.chunk_pregen.shape_type.circle");
        }

        @Override
        public ITask createRadiusGenTask(String name, int x, int z, int radius, GenerationType type, int dimensionId) {
            return new CircleTask(name, dimensionId, type, new FilePos(x, z), radius);
        }

        @Override
        public ITask createExpansionGenTask(String name, int x, int z, int minRadius, int maxRadius, GenerationType type, int dimensionId) {
            return new CircleExpansionTask(name, dimensionId, type, new FilePos(x, z), minRadius, maxRadius);
        }

        @Override
        public ITask createAreaGenTask(String name, FilePos min, FilePos max, GenerationType type, int dimensionId) {
            return new CircleAreaTask(name, dimensionId, type, min, max);
        }

        @Override
        public IDeletionTask createRadiusDeleteTask(String name, int x, int z, int radius, int dimensionId) {
            return new DeletionCircle(name, dimensionId, new FilePos(x, z), radius);
        }

        @Override
        public IDeletionTask createExpansionDeleteTask(String name, int x, int z, int minRadius, int maxRadius, int dimensionId) {
            return new DeletionCircleExpansion(name, dimensionId, new FilePos(x, z), minRadius, maxRadius);
        }

        @Override
        public IDeletionTask createAreaDeleteTask(String name, FilePos min, FilePos max, int dimensionId) {
            return new DeletionCircleArea(name, dimensionId, min, max);
        }
    };


    public long calculateRadius(long radius) {
        throw new UnsupportedOperationException();
    }

    public long calculateRadius(long minRadius, long maxRadius) {
        throw new UnsupportedOperationException();
    }

    public long calculateRadius(FilePos from, FilePos to) {
        throw new UnsupportedOperationException();
    }

    public boolean isInsideArea(int radius, int x, int z) {
        throw new UnsupportedOperationException();
    }

    public ITextComponent getName() {
        throw new UnsupportedOperationException();
    }

    public ITask createRadiusGenTask(String name, int x, int z, int radius, GenerationType type, int dimensionId) {
        throw new UnsupportedOperationException();
    }

    public ITask createExpansionGenTask(String name, int x, int z, int minRadius, int maxRadius, GenerationType type, int dimensionId) {
        throw new UnsupportedOperationException();
    }

    public ITask createAreaGenTask(String name, FilePos min, FilePos max, GenerationType type, int dimensionId) {
        throw new UnsupportedOperationException();
    }

    public IDeletionTask createRadiusDeleteTask(String name, int x, int z, int radius, int dimensionId) {
        throw new UnsupportedOperationException();
    }

    public IDeletionTask createExpansionDeleteTask(String name, int x, int z, int minRadius, int maxRadius, int dimensionId) {
        throw new UnsupportedOperationException();
    }

    public IDeletionTask createAreaDeleteTask(String name, FilePos min, FilePos max, int dimensionId) {
        throw new UnsupportedOperationException();
    }
}

