/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.network;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.TextUtil;
import pregenerator.base.api.network.IPregenPacket;
import pregenerator.impl.client.helpers.IChunkAcceptor;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.misc.PregenAction;
import pregenerator.impl.tracking.ChunkEntry;
import pregenerator.impl.tracking.ServerTracker;
import pregenerator.impl.tracking.WorldTracker;
import pregenerator.impl.tracking.types.IWorldEntry;

public class ChunkPacket {

    private static class FetchTask
    extends RecursiveAction {
        private static final long serialVersionUID = 7982665640808749376L;
        WorldTracker tracker;
        List<ChunkEntry> result = new ObjectArrayList();

        private FetchTask(WorldTracker tracker) {
            this.tracker = tracker;
        }

        @Override
        protected void compute() {
            ObjectArrayList tasks = new ObjectArrayList();
            for (Chunk chunk : this.tracker.getChunks()) {
                tasks.add(ForkJoinTask.adapt(() -> ChunkEntry.fromChunk(chunk)));
            }
            FetchTask.invokeAll(tasks);
            for (ForkJoinTask entry : tasks) {
                this.result.add((ChunkEntry)entry.getRawResult());
            }
        }

        public static List<ChunkEntry> fetch(WorldTracker tracker) {
            FetchTask task = new FetchTask(tracker);
            ForkJoinPool.commonPool().invoke(task);
            task.quietlyJoin();
            return task.result;
        }
    }

    public static class TPAction
    implements IPregenPacket {
        int dimension;
        long position;

        public TPAction() {
        }

        public TPAction(int dimension, long position) {
            this.dimension = dimension;
            this.position = position;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.writeInt(this.dimension);
            buffer.writeLong(this.position);
        }

        @Override
        public void read(PacketBuffer buffer) {
            this.dimension = buffer.readInt();
            this.position = buffer.readLong();
        }

        @Override
        public void process(EntityPlayer player) {
            if (!ChunkPregenerator.canDoAction(player, PregenAction.CHUNK_TP)) {
                player.func_146105_b(TextUtil.translate("network.chunk_pregen.failures.no_permissions"), false);
                return;
            }
            WorldTracker tracker = ServerTracker.INSTANCE.getWorld(this.dimension);
            if (tracker == null) {
                player.func_146105_b(TextUtil.translate("network.chunk_pregen.failures.no_dimension"), false);
                return;
            }
            TPAction.teleportEntity((Entity)player, tracker.world, new ChunkPos(FilePos.getX(this.position), FilePos.getZ(this.position)).func_180331_a(8, (int)player.field_70163_u, 8), EnumFacing.UP);
        }

        public static void teleportEntity(Entity entity, WorldServer world, BlockPos destination, EnumFacing dir) {
            entity.func_184210_p();
            double x = (float)(destination.func_177958_n() + dir.func_82601_c()) + 0.5f;
            double y = destination.func_177956_o() + dir.func_96559_d() + (dir.func_176740_k() == EnumFacing.Axis.Y && dir.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? -1 : 0);
            double z = (float)(destination.func_177952_p() + dir.func_82599_e()) + 0.5f;
            if (entity.field_70170_p.field_73011_w.getDimension() != world.field_73011_w.getDimension()) {
                TPAction.changeDimension(entity, (WorldServer)entity.field_70170_p, world);
                entity.func_70080_a(x, y, z, entity.field_70177_z, entity.field_70125_A);
            } else {
                entity.func_70634_a(x, y, z);
            }
        }

        public static void changeDimension(Entity entity, WorldServer oldWorld, WorldServer newWorld) {
            entity.func_184204_a(newWorld.field_73011_w.getDimension());
        }
    }

    public static class RemoveAction
    implements IPregenPacket {
        int dimension;
        long position;
        int type;
        IWorldEntry entry;

        public RemoveAction() {
        }

        public RemoveAction(int dimension, long position, int type, IWorldEntry entry) {
            this.dimension = dimension;
            this.position = position;
            this.type = type;
            this.entry = entry;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.writeInt(this.dimension);
            buffer.writeLong(this.position);
            buffer.func_150787_b(this.type);
            this.entry.write(buffer);
        }

        @Override
        public void read(PacketBuffer buffer) {
            this.dimension = buffer.readInt();
            this.position = buffer.readLong();
            this.entry = IWorldEntry.byId(buffer.func_150792_a()).apply(buffer);
        }

        @Override
        public void process(EntityPlayer player) {
            if (!(player instanceof EntityPlayerMP)) {
                return;
            }
            if (!this.entry.canDelete(true)) {
                return;
            }
            if (!ChunkPregenerator.canDoAction(player, PregenAction.CHUNK_DELETION)) {
                player.func_146105_b(TextUtil.translate("network.chunk_pregen.failures.no_permissions"), false);
                return;
            }
            WorldTracker tracker = ServerTracker.INSTANCE.getWorld(this.dimension);
            if (tracker == null) {
                player.func_146105_b(TextUtil.translate("network.chunk_pregen.failures.no_dimension"), false);
                return;
            }
            player.func_145747_a(TextUtil.translate("gui.chunk_pregen.dimension_screen.deleted", TextUtil.NUMBERS.format(this.entry.deleteChunk(tracker, this.position)), this.entry.getName()));
            ChunkPregenerator.NETWORKING.sendToPlayer(new SingleAnswer(this.dimension, ChunkEntry.fromChunk(tracker.getChunk(this.position))), player);
        }
    }

    public static class SingleAnswer
    implements IPregenPacket {
        int dimension;
        ChunkEntry entry;

        public SingleAnswer() {
        }

        public SingleAnswer(int dimension, ChunkEntry entry) {
            this.dimension = dimension;
            this.entry = entry;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.writeInt(this.dimension);
            this.entry.write(buffer);
        }

        @Override
        public void read(PacketBuffer buffer) {
            this.dimension = buffer.readInt();
            this.entry = ChunkEntry.fromNetwork(buffer);
        }

        @Override
        public void process(EntityPlayer player) {
            this.processClient();
        }

        @SideOnly(value=Side.CLIENT)
        public void processClient() {
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof IChunkAcceptor) {
                ((IChunkAcceptor)screen).acceptUpdateData(this.dimension, this.entry);
            }
        }
    }

    public static class Answer
    implements IPregenPacket {
        int dimension;
        List<ChunkEntry> data = new ObjectArrayList();

        public Answer() {
        }

        public Answer(int dimension) {
            this.dimension = dimension;
        }

        public Answer(int dimension, List<ChunkEntry> data) {
            this.dimension = dimension;
            this.data = data;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.writeInt(this.dimension);
            IPregenPacket.writeCollection(buffer, this.data, ChunkEntry::write);
        }

        @Override
        public void read(PacketBuffer buffer) {
            this.dimension = buffer.readInt();
            IPregenPacket.readCollection(buffer, this.data, ChunkEntry::fromNetwork);
        }

        @Override
        public void process(EntityPlayer player) {
            this.processClient();
        }

        @SideOnly(value=Side.CLIENT)
        public void processClient() {
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof IChunkAcceptor) {
                ((IChunkAcceptor)screen).acceptChunkData(this.dimension, this.data);
            }
        }
    }

    public static class Request
    implements IPregenPacket {
        int dimension;

        public Request() {
        }

        public Request(int dimension) {
            this.dimension = dimension;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.writeInt(this.dimension);
        }

        @Override
        public void read(PacketBuffer buffer) {
            this.dimension = buffer.readInt();
        }

        @Override
        public void process(EntityPlayer player) {
            if (!ChunkPregenerator.canDoAction(player, PregenAction.CHUNK_SCANNING)) {
                player.func_146105_b(TextUtil.translate("network.chunk_pregen.failures.no_permissions"), false);
                ChunkPregenerator.NETWORKING.sendToPlayer(new Answer(this.dimension), player);
                return;
            }
            WorldTracker tracker = ServerTracker.INSTANCE.getWorld(this.dimension);
            if (tracker == null) {
                ChunkPregenerator.NETWORKING.sendToPlayer(new Answer(this.dimension), player);
                return;
            }
            ChunkPregenerator.NETWORKING.sendToPlayer(new Answer(this.dimension, FetchTask.fetch(tracker)), player);
        }
    }
}

