/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.network;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.TextUtil;
import pregenerator.base.api.network.IPregenPacket;
import pregenerator.impl.client.gui.PregenMenu;
import pregenerator.impl.misc.PregenAction;
import pregenerator.impl.processor.IBaseTask;
import pregenerator.impl.processor.IProcessor;
import pregenerator.impl.processor.ServerManager;
import pregenerator.impl.processor.TaskActions;
import pregenerator.impl.storage.GlobalListeners;
import pregenerator.impl.storage.PregenTaskStorage;
import pregenerator.impl.storage.ProcessListener;

public class CommandPacket {

    public static class AnswerPerms
    implements IPregenPacket {
        List<PregenAction> perms = new ObjectArrayList();

        public AnswerPerms() {
        }

        public AnswerPerms(List<PregenAction> perms) {
            this.perms = perms;
        }

        @Override
        public void write(PacketBuffer buffer) {
            IPregenPacket.writeCollectionReverse(buffer, this.perms, PacketBuffer::func_179249_a);
        }

        @Override
        public void read(PacketBuffer buffer) {
            IPregenPacket.readCollection(buffer, this.perms, T -> (PregenAction)T.func_179257_a(PregenAction.class));
        }

        @Override
        public void process(EntityPlayer player) {
            this.processClient();
        }

        @SideOnly(value=Side.CLIENT)
        private void processClient() {
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof PregenMenu) {
                ((PregenMenu)screen).receivePermissions(this.perms);
            }
        }
    }

    public static class RequestPerms
    implements IPregenPacket.IRequestPacket {
        @Override
        public void process(EntityPlayer player) {
            ChunkPregenerator.NETWORKING.sendToPlayer(new AnswerPerms(ChunkPregenerator.getValidActions(player)), player);
        }
    }

    public static class Task
    implements IPregenPacket {
        IBaseTask task;

        public Task() {
        }

        public Task(IBaseTask task) {
            this.task = task;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.func_150786_a(IBaseTask.saveTask(this.task));
        }

        @Override
        public void read(PacketBuffer buffer) throws IOException {
            this.task = IBaseTask.loadTask(buffer.func_150793_b());
        }

        @Override
        public void process(EntityPlayer player) {
            if (this.task == null) {
                player.func_145747_a(TextUtil.impossibleScenario());
                return;
            }
            if (!ChunkPregenerator.canDoAction(player, PregenAction.COMMANDS)) {
                player.func_146105_b(TextUtil.translate("network.chunk_pregen.failures.no_permissions"), false);
                return;
            }
            TaskActions.startTask(this.task, player, arg_0 -> ((EntityPlayer)player).func_145747_a(arg_0));
        }
    }

    public static class Action
    implements IPregenPacket {
        int action;

        public Action() {
        }

        public Action(int action) {
            this.action = action;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.func_150787_b(this.action);
        }

        @Override
        public void read(PacketBuffer buffer) {
            this.action = buffer.func_150792_a();
        }

        @Override
        public void process(EntityPlayer player) {
            if (this.action < 5) {
                if (!ChunkPregenerator.canDoAction(player, PregenAction.COMMANDS)) {
                    player.func_146105_b(TextUtil.translate("network.chunk_pregen.failures.no_permissions"), false);
                    return;
                }
                switch (this.action) {
                    case 0: {
                        TaskActions.pauseTask(arg_0 -> ((EntityPlayer)player).func_145747_a(arg_0));
                        break;
                    }
                    case 1: {
                        TaskActions.resumeTask(arg_0 -> ((EntityPlayer)player).func_145747_a(arg_0));
                        break;
                    }
                    case 2: {
                        TaskActions.stopTask(arg_0 -> ((EntityPlayer)player).func_145747_a(arg_0));
                        break;
                    }
                    case 3: {
                        TaskActions.continueTask(player, arg_0 -> ((EntityPlayer)player).func_145747_a(arg_0));
                        break;
                    }
                    case 4: {
                        TaskActions.removeTask(arg_0 -> ((EntityPlayer)player).func_145747_a(arg_0));
                    }
                }
            } else {
                switch (this.action) {
                    case 5: {
                        PregenTaskStorage.getStorage().add(player.func_110124_au(), true);
                        break;
                    }
                    case 6: {
                        PregenTaskStorage.getStorage().add(player.func_110124_au(), false);
                        break;
                    }
                    case 7: {
                        PregenTaskStorage.getStorage().remove(player.func_110124_au());
                        break;
                    }
                    case 8: {
                        GlobalListeners.INSTANCE.addListener(ProcessListener.create(player.func_110124_au()));
                        break;
                    }
                    case 9: {
                        GlobalListeners.INSTANCE.removeListener(ProcessListener.create(player.func_110124_au()));
                    }
                }
            }
            Request.processPlayer(player);
        }
    }

    public static class Answer
    implements IPregenPacket {
        int listeningState;
        boolean listening;
        int totalTasks;
        int runningTasks;
        int pausedTasks;

        public Answer() {
        }

        public Answer(int listeningState, boolean listening, int totalTasks, int runningTasks, int pausedTasks) {
            this.listeningState = listeningState;
            this.listening = listening;
            this.totalTasks = totalTasks;
            this.runningTasks = runningTasks;
            this.pausedTasks = pausedTasks;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.func_150787_b(this.listeningState);
            buffer.writeBoolean(this.listening);
            buffer.func_150787_b(this.totalTasks);
            buffer.func_150787_b(this.runningTasks);
            buffer.func_150787_b(this.pausedTasks);
        }

        @Override
        public void read(PacketBuffer buffer) {
            this.listeningState = buffer.func_150792_a();
            this.listening = buffer.readBoolean();
            this.totalTasks = buffer.func_150792_a();
            this.runningTasks = buffer.func_150792_a();
            this.pausedTasks = buffer.func_150792_a();
        }

        @Override
        public void process(EntityPlayer player) {
            this.processClient();
        }

        @SideOnly(value=Side.CLIENT)
        private void processClient() {
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof PregenMenu) {
                ((PregenMenu)screen).receiveData(this.listeningState, this.listening, this.totalTasks, this.runningTasks, this.pausedTasks);
            }
        }
    }

    public static class Request
    implements IPregenPacket.IRequestPacket {
        @Override
        public void process(EntityPlayer player) {
            Request.processPlayer(player);
        }

        public static void processPlayer(EntityPlayer player) {
            PregenTaskStorage storage = PregenTaskStorage.getStorage();
            int[] result = new int[3];
            if (ChunkPregenerator.canDoAction(player, PregenAction.COMMANDS)) {
                IProcessor processor = ServerManager.INSTANCE.getActiveProcess();
                result[0] = storage.getAllTasks().size();
                result[1] = processor != null ? 1 : 0;
                result[2] = processor != null && processor.isPaused() ? 1 : 0;
            }
            ChunkPregenerator.NETWORKING.sendToPlayer(new Answer(storage.getState(player.func_110124_au()), GlobalListeners.INSTANCE.containsListener(ProcessListener.create(player.func_110124_au())), result[0], result[1], result[2]), player);
        }
    }
}

