/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.TextUtil;
import pregenerator.base.api.network.IPregenPacket;

public class MemoryPacket {

    public static interface IMemoryReceiver {
        public void receivedMemory(int var1, long var2, boolean var4);
    }

    public static class Answer
    implements IPregenPacket {
        int dim;
        long memory;
        boolean free;

        public Answer() {
        }

        public Answer(int dim, long memory, boolean free) {
            this.dim = dim;
            this.memory = memory;
            this.free = free;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.writeInt(this.dim);
            buffer.writeLong(this.memory);
            buffer.writeBoolean(this.free);
        }

        @Override
        public void read(PacketBuffer buffer) {
            this.dim = buffer.readInt();
            this.memory = buffer.readLong();
            this.free = buffer.readBoolean();
        }

        @Override
        public void process(EntityPlayer player) {
            this.processClient();
        }

        @SideOnly(value=Side.CLIENT)
        public void processClient() {
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof IMemoryReceiver) {
                ((IMemoryReceiver)screen).receivedMemory(this.dim, this.memory, this.free);
            }
        }
    }

    public static class RequestUsed
    implements IPregenPacket {
        int dim;

        public RequestUsed() {
        }

        public RequestUsed(int dim) {
            this.dim = dim;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.writeInt(this.dim);
        }

        @Override
        public void read(PacketBuffer buffer) {
            this.dim = buffer.readInt();
        }

        @Override
        public void process(EntityPlayer player) {
            ChunkPregenerator.NETWORKING.sendToPlayer(new Answer(this.dim, TextUtil.getUsedMemory(this.dim), false), player);
        }

        @Override
        public boolean needsMainThreads() {
            return false;
        }
    }

    public static class RequestFree
    implements IPregenPacket.IRequestPacket {
        @Override
        public void process(EntityPlayer player) {
            ChunkPregenerator.NETWORKING.sendToPlayer(new Answer(0, TextUtil.getFreeMemory(), true), player);
        }

        @Override
        public boolean needsMainThreads() {
            return false;
        }
    }
}

