/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.network;

import java.io.IOException;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pregenerator.base.api.network.IPregenPacket;
import pregenerator.impl.client.gui.ProgressScreen;
import pregenerator.impl.client.helpers.IProgressListener;
import pregenerator.impl.processor.ServerManager;

public class ProgressPacket {

    public static class Complete
    implements IPregenPacket.IRequestPacket {
        @Override
        public void process(EntityPlayer player) {
            this.processClient();
        }

        @SideOnly(value=Side.CLIENT)
        public void processClient() {
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof IProgressListener) {
                ((IProgressListener)screen).onCompleted();
            }
        }
    }

    public static class Cancel
    implements IPregenPacket {
        UUID taskId;

        public Cancel() {
        }

        public Cancel(UUID taskId) {
            this.taskId = taskId;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.func_179252_a(this.taskId);
        }

        @Override
        public void read(PacketBuffer buffer) {
            this.taskId = buffer.func_179253_g();
        }

        @Override
        public void process(EntityPlayer player) {
            ServerManager.INSTANCE.interruptMiniTask(this.taskId);
        }
    }

    public static class Update
    implements IPregenPacket {
        long current;
        long max;

        public Update() {
        }

        public Update(long current, long max) {
            this.current = current;
            this.max = max;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.func_179254_b(this.current);
            buffer.func_179254_b(this.max);
        }

        @Override
        public void read(PacketBuffer buffer) {
            this.current = buffer.func_179260_f();
            this.max = buffer.func_179260_f();
        }

        @Override
        public void process(EntityPlayer player) {
            this.processClient();
        }

        @SideOnly(value=Side.CLIENT)
        public void processClient() {
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof IProgressListener) {
                ((IProgressListener)screen).updateProgress(this.current, this.max);
            }
        }
    }

    public static class Start
    implements IPregenPacket {
        long max;
        UUID taskId;
        ITextComponent message;

        public Start() {
        }

        public Start(long max, UUID taskId, ITextComponent message) {
            this.max = max;
            this.taskId = taskId;
            this.message = message;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.func_179254_b(this.max);
            buffer.func_179252_a(this.taskId);
            buffer.func_179256_a(this.message);
        }

        @Override
        public void read(PacketBuffer buffer) throws IOException {
            this.max = buffer.func_179260_f();
            this.taskId = buffer.func_179253_g();
            this.message = buffer.func_179258_d();
        }

        @Override
        public void process(EntityPlayer player) {
            this.processClient();
        }

        @SideOnly(value=Side.CLIENT)
        public void processClient() {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_147108_a((GuiScreen)new ProgressScreen(mc.field_71462_r, this.taskId, this.max, this.message));
        }
    }
}

