/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.network;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.TextUtil;
import pregenerator.base.api.network.IPregenPacket;
import pregenerator.impl.client.gui.commands.TaskScreen;
import pregenerator.impl.misc.PregenAction;
import pregenerator.impl.processor.IBaseTask;
import pregenerator.impl.processor.ServerManager;
import pregenerator.impl.processor.TaskActions;
import pregenerator.impl.processor.deleter.tasks.IDeletionTask;
import pregenerator.impl.processor.generator.tasks.ITask;

public class TaskPacket {

    public static interface ISpeedReceiver {
        public void acceptSpeedData(Map<Integer, Float> var1);
    }

    public static interface TaskFunction<T> {
        public T apply(List<IBaseTask> var1, UUID var2, boolean var3);
    }

    public static class AnswerSpeeds
    implements IPregenPacket {
        Map<Integer, Float> speeds = new LinkedHashMap<Integer, Float>();

        public AnswerSpeeds() {
        }

        public AnswerSpeeds(Map<Integer, Float> speeds) {
            this.speeds = speeds;
        }

        @Override
        public void write(PacketBuffer buffer) {
            IPregenPacket.writeMap(buffer, this.speeds, PacketBuffer::writeInt, PacketBuffer::writeFloat);
        }

        @Override
        public void read(PacketBuffer buffer) {
            IPregenPacket.readMap(buffer, this.speeds, PacketBuffer::readInt, PacketBuffer::readFloat);
        }

        @Override
        public void process(EntityPlayer player) {
            this.processClient();
        }

        @SideOnly(value=Side.CLIENT)
        public void processClient() {
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof ISpeedReceiver) {
                ((ISpeedReceiver)screen).acceptSpeedData(this.speeds);
            }
        }
    }

    public static class RequestSpeeds
    implements IPregenPacket.IRequestPacket {
        @Override
        public void process(EntityPlayer player) {
            if (!ChunkPregenerator.canDoAction(player, PregenAction.COMMANDS)) {
                player.func_146105_b(TextUtil.translate("network.chunk_pregen.failures.no_permissions"), false);
                return;
            }
            LinkedHashMap<Integer, Float> speeds = new LinkedHashMap<Integer, Float>();
            Integer[] integerArray = DimensionManager.getStaticDimensionIDs();
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int dim = integerArray[i];
                speeds.put(dim, Float.valueOf(ServerManager.INSTANCE.getChunksPerTick(dim)));
            }
            ChunkPregenerator.NETWORKING.sendToPlayer(new AnswerSpeeds(speeds), player);
        }
    }

    public static class AnswerTasks
    implements IPregenPacket {
        List<IBaseTask> tasks = new ArrayList<IBaseTask>();
        UUID activeTask;
        boolean activePaused;

        public AnswerTasks() {
        }

        public AnswerTasks(List<IBaseTask> tasks, UUID activeTask, boolean activePaused) {
            this.tasks = tasks;
            this.activeTask = activeTask;
            this.activePaused = activePaused;
        }

        @Override
        public void write(PacketBuffer buffer) {
            IPregenPacket.writeCollection(buffer, this.tasks, (T, B) -> B.func_150786_a(IBaseTask.saveTask(T)));
            buffer.writeBoolean(this.activeTask != null);
            if (this.activeTask != null) {
                buffer.func_179252_a(this.activeTask);
            }
            buffer.writeBoolean(this.activePaused);
        }

        @Override
        public void read(PacketBuffer buffer) {
            IPregenPacket.readCollection(buffer, this.tasks, T -> IBaseTask.loadTask(IPregenPacket.readNBT(T)));
            if (buffer.readBoolean()) {
                this.activeTask = buffer.func_179253_g();
            }
            this.activePaused = buffer.readBoolean();
        }

        @Override
        public void process(EntityPlayer player) {
            this.processClient();
        }

        @SideOnly(value=Side.CLIENT)
        public void processClient() {
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof TaskScreen) {
                ArrayList<ITask> gen = new ArrayList<ITask>();
                ArrayList<IDeletionTask> deletion = new ArrayList<IDeletionTask>();
                for (IBaseTask task : this.tasks) {
                    if (task instanceof ITask) {
                        gen.add((ITask)task);
                        continue;
                    }
                    if (!(task instanceof IDeletionTask)) continue;
                    deletion.add((IDeletionTask)task);
                }
                ((TaskScreen)screen).acceptTasks(gen, deletion, this.activeTask, this.activePaused);
            }
        }
    }

    public static class Action
    implements IPregenPacket {
        int action;
        String taskName;

        public Action() {
        }

        public Action(int action, String taskName) {
            this.action = action;
            this.taskName = taskName;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.func_150787_b(this.action);
            buffer.func_180714_a(this.taskName);
        }

        @Override
        public void read(PacketBuffer buffer) {
            this.action = buffer.func_150792_a();
            this.taskName = buffer.func_150789_c(Short.MAX_VALUE);
        }

        @Override
        public void process(EntityPlayer player) {
            if (!ChunkPregenerator.canDoAction(player, PregenAction.COMMANDS)) {
                player.func_146105_b(TextUtil.translate("network.chunk_pregen.failures.no_permissions"), false);
                return;
            }
            switch (this.action) {
                case 0: {
                    TaskActions.pauseTask(arg_0 -> ((EntityPlayer)player).func_145747_a(arg_0));
                    break;
                }
                case 1: {
                    TaskActions.resumeTask(arg_0 -> ((EntityPlayer)player).func_145747_a(arg_0));
                    break;
                }
                case 2: {
                    TaskActions.stopTask(arg_0 -> ((EntityPlayer)player).func_145747_a(arg_0));
                    break;
                }
                case 3: {
                    TaskActions.continueTask(this.taskName, player, arg_0 -> ((EntityPlayer)player).func_145747_a(arg_0));
                    break;
                }
                case 4: {
                    TaskActions.removeTask(this.taskName, arg_0 -> ((EntityPlayer)player).func_145747_a(arg_0));
                }
            }
            ChunkPregenerator.NETWORKING.sendToPlayer(ServerManager.INSTANCE.getTasks(AnswerTasks::new), player);
        }
    }

    public static class RequestTasks
    implements IPregenPacket.IRequestPacket {
        @Override
        public void process(EntityPlayer player) {
            if (!ChunkPregenerator.canDoAction(player, PregenAction.COMMANDS)) {
                player.func_146105_b(TextUtil.translate("network.chunk_pregen.failures.no_permissions"), false);
                return;
            }
            ChunkPregenerator.NETWORKING.sendToPlayer(ServerManager.INSTANCE.getTasks(AnswerTasks::new), player);
        }
    }
}

