/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.network;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.TextUtil;
import pregenerator.base.api.network.IPregenPacket;
import pregenerator.impl.client.helpers.IWorldAcceptor;
import pregenerator.impl.misc.PregenAction;
import pregenerator.impl.tracking.ServerTracker;
import pregenerator.impl.tracking.WorldTracker;
import pregenerator.impl.tracking.types.IWorldEntry;

public class TypePacket {

    public static class Answer
    implements IPregenPacket {
        int type;
        List<IWorldEntry> list = new ObjectArrayList();

        public Answer() {
        }

        public Answer(int type) {
            this.type = type;
        }

        public Answer(int type, List<IWorldEntry> list) {
            this.type = type;
            this.list = list;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.func_150787_b(this.type);
            IPregenPacket.writeCollection(buffer, this.list, IWorldEntry::write);
        }

        @Override
        public void read(PacketBuffer buffer) {
            this.type = buffer.func_150792_a();
            IPregenPacket.readCollection(buffer, this.list, IWorldEntry.byId(this.type));
        }

        @Override
        public void process(EntityPlayer player) {
            this.processClient();
        }

        @SideOnly(value=Side.CLIENT)
        public void processClient() {
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof IWorldAcceptor) {
                ((IWorldAcceptor)screen).acceptWorldData(this.type, this.list);
            }
        }
    }

    public static class DeleteAction
    implements IPregenPacket {
        int type;
        int dimension;
        IWorldEntry entry;

        public DeleteAction() {
        }

        public DeleteAction(int type, int dimension, IWorldEntry entry) {
            this.type = type;
            this.dimension = dimension;
            this.entry = entry;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.func_150787_b(this.type);
            buffer.writeInt(this.dimension);
            this.entry.write(buffer);
        }

        @Override
        public void read(PacketBuffer buffer) {
            this.type = buffer.func_150792_a();
            this.dimension = buffer.readInt();
            this.entry = IWorldEntry.byId(this.type).apply(buffer);
        }

        @Override
        public void process(EntityPlayer player) {
            if (!(player instanceof EntityPlayerMP)) {
                return;
            }
            if (!this.entry.canDelete(false)) {
                return;
            }
            if (!ChunkPregenerator.canDoAction(player, PregenAction.ALL_DELETION)) {
                player.func_146105_b(TextUtil.translate("network.chunk_pregen.failures.no_permissions"), false);
                return;
            }
            WorldTracker tracker = ServerTracker.INSTANCE.getWorld(this.dimension);
            if (tracker == null) {
                player.func_146105_b(TextUtil.translate("network.chunk_pregen.failures.no_dimension"), false);
                return;
            }
            player.func_145747_a(TextUtil.translate("gui.chunk_pregen.dimension_screen.deleted", TextUtil.NUMBERS.format(this.entry.deleteWorld(tracker, player)), this.entry.getName()));
            ChunkPregenerator.NETWORKING.sendToPlayer(new Answer(this.type, IWorldEntry.byLevel(this.type, tracker.world)), player);
        }
    }

    public static class Request
    implements IPregenPacket {
        int type;
        int dimension;

        public Request() {
        }

        public Request(int type, int dimension) {
            this.type = type;
            this.dimension = dimension;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.func_150787_b(this.type);
            buffer.writeInt(this.dimension);
        }

        @Override
        public void read(PacketBuffer buffer) {
            this.type = buffer.func_150792_a();
            this.dimension = buffer.readInt();
        }

        @Override
        public void process(EntityPlayer player) {
            if (!ChunkPregenerator.canDoAction(player, PregenAction.ALL_SCANNING)) {
                player.func_146105_b(TextUtil.translate("network.chunk_pregen.failures.no_permissions"), false);
                ChunkPregenerator.NETWORKING.sendToPlayer(new Answer(this.type), player);
                return;
            }
            WorldTracker tracker = ServerTracker.INSTANCE.getWorld(this.dimension);
            if (tracker == null) {
                ChunkPregenerator.NETWORKING.sendToPlayer(new Answer(this.type), player);
                return;
            }
            ChunkPregenerator.NETWORKING.sendToPlayer(new Answer(this.type, IWorldEntry.byLevel(this.type, tracker.world)), player);
        }
    }
}

