/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor;

import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.util.math.ChunkPos;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.processor.PrepareProgress;

public class ChunkCalculator {
    public static Map<Long, BitSet> getSquareShape(int xPos, int zPos, int radius, PrepareProgress progress) {
        LinkedHashMap<Long, BitSet> result = new LinkedHashMap<Long, BitSet>();
        for (int x = -radius; x < radius; ++x) {
            for (int z = -radius; z < radius; ++z) {
                ChunkCalculator.create(x + xPos, z + zPos, result);
                progress.growValue(1);
            }
        }
        return result;
    }

    public static Map<Long, BitSet> getSquareExspansionShape(int xPos, int zPos, int minRadius, int maxRadius, PrepareProgress progress) {
        LinkedHashMap<Long, BitSet> result = new LinkedHashMap<Long, BitSet>();
        for (int x = -maxRadius; x < maxRadius; ++x) {
            for (int z = -maxRadius; z < maxRadius; ++z) {
                progress.growValue(1);
                if (x > -minRadius && x <= minRadius && z > -minRadius && z <= minRadius) continue;
                ChunkCalculator.create(x + xPos, z + zPos, result);
            }
        }
        return result;
    }

    public static Map<Long, BitSet> getCircleShape(int xPos, int zPos, int radius, PrepareProgress progress) {
        LinkedHashMap<Long, BitSet> result = new LinkedHashMap<Long, BitSet>();
        for (int x = -radius; x < radius; ++x) {
            for (int z = -radius; z < radius; ++z) {
                progress.growValue(1);
                if (ChunkCalculator.isNotInReach(x, z, radius)) continue;
                ChunkCalculator.create(x + xPos, z + zPos, result);
            }
        }
        return result;
    }

    public static Map<Long, BitSet> getCircleExpansionShape(int xPos, int zPos, int minRadius, int maxRadius, PrepareProgress progress) {
        LinkedHashMap<Long, BitSet> result = new LinkedHashMap<Long, BitSet>();
        for (int x = -maxRadius; x < maxRadius; ++x) {
            for (int z = -maxRadius; z < maxRadius; ++z) {
                progress.growValue(1);
                if (ChunkCalculator.isNotInRange(x, z, minRadius, maxRadius)) continue;
                ChunkCalculator.create(x + xPos, z + zPos, result);
            }
        }
        return result;
    }

    public static Map<Long, BitSet> genSquareArea(int minX, int minZ, int maxX, int maxZ, PrepareProgress progress) {
        LinkedHashMap<Long, BitSet> result = new LinkedHashMap<Long, BitSet>();
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                ChunkCalculator.create(x, z, result);
                progress.growValue(1);
            }
        }
        return result;
    }

    public static Map<Long, BitSet> genCircleArea(int minX, int minZ, int maxX, int maxZ, PrepareProgress progress) {
        LinkedHashMap<Long, BitSet> result = new LinkedHashMap<Long, BitSet>();
        int xRadius = maxX - minX;
        int zRadius = maxZ - minZ;
        for (int x = 0; x < xRadius; ++x) {
            for (int z = 0; z < zRadius; ++z) {
                progress.growValue(1);
                if (ChunkCalculator.isNotInReachEllipse(x, z, xRadius, zRadius)) continue;
                ChunkCalculator.create(x + minX, z + minZ, result);
            }
        }
        return result;
    }

    public static Map<Long, BitSet> genSpecific(Collection<Long> chunks, PrepareProgress progress) {
        LinkedHashMap<Long, BitSet> result = new LinkedHashMap<Long, BitSet>();
        for (Long value : chunks) {
            progress.growValue(1);
            ChunkCalculator.create(FilePos.getX(value), FilePos.getZ(value), result);
        }
        return result;
    }

    static void create(int x, int z, Map<Long, BitSet> map) {
        long value = ChunkPos.func_77272_a((int)(x >> 5), (int)(z >> 5));
        BitSet set = map.get(value);
        if (set == null) {
            set = new BitSet(1024);
            map.put(value, set);
        }
        set.set((z & 0x1F) * 32 + (x & 0x1F));
    }

    static boolean isNotInRange(int x, int y, int minRadius, int maxRadius) {
        long distance = x * x + y * y;
        return distance >= (long)(maxRadius * maxRadius) || distance < (long)(minRadius * minRadius);
    }

    static boolean isNotInReachEllipse(int x, int y, int width, int height) {
        double posX = (double)x / (double)width - 0.5;
        double posY = (double)y / (double)height - 0.5;
        return posX * posX + posY * posY >= 0.25;
    }

    static boolean isNotInReach(int x, int y, int radius) {
        return x * x + y * y >= radius * radius;
    }
}

