/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.time.DurationFormatUtils;
import pregenerator.PregenConfig;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.config.SpeedEntry;
import pregenerator.impl.network.TaskPacket;
import pregenerator.impl.processor.IBaseTask;
import pregenerator.impl.processor.IProcessor;
import pregenerator.impl.processor.generator.ChunkProcessor;
import pregenerator.impl.processor.generator.tasks.ITask;
import pregenerator.impl.processor.minitasks.IMiniTask;
import pregenerator.impl.storage.GlobalListeners;
import pregenerator.impl.storage.PregenTaskStorage;

public class ServerManager {
    public static final ServerManager INSTANCE = new ServerManager();
    Map<UUID, IMiniTask> miniTasks = new LinkedHashMap<UUID, IMiniTask>();
    IProcessor active;
    boolean wasActive = false;

    @SubscribeEvent
    public void onServerTickEvent(TickEvent.ServerTickEvent event) {
        MinecraftServer server;
        if (event.phase == TickEvent.Phase.START) {
            if (this.active != null) {
                this.active.onTickStart();
            }
            return;
        }
        long startTime = System.currentTimeMillis();
        if (this.active != null) {
            this.active.onTickEnd();
        }
        if (this.active != null && PregenConfig.INSTANCE.enableLoginWarning.get()) {
            server = FMLCommonHandler.instance().getMinecraftServerInstance();
            long longest = this.active.getExpectedTime();
            ITextComponent time = TextUtil.applyTextStyle(TextUtil.literal("Pregeneration Active! ETA: ~" + DurationFormatUtils.formatDuration((long)longest, (String)"HH:mm:ss")), TextFormatting.RED);
            server.func_147134_at().func_151315_a(TextUtil.empty().func_150257_a(time).func_150258_a("\n").func_150257_a(TextUtil.literal(server.func_71273_Y())));
            this.wasActive = true;
        } else if (this.wasActive) {
            this.wasActive = false;
            server = FMLCommonHandler.instance().getMinecraftServerInstance();
            server.func_147134_at().func_151315_a(TextUtil.literal(server.func_71273_Y()));
        }
        boolean removed = false;
        Iterator<IMiniTask> iter = this.miniTasks.values().iterator();
        while (iter.hasNext()) {
            if (iter.next().update(startTime)) continue;
            iter.remove();
            removed = true;
        }
        if (removed && this.shouldFinishListening()) {
            GlobalListeners.INSTANCE.clearListeners();
        }
    }

    public byte[] sendData() {
        Object data;
        if (this.active == null && this.miniTasks.isEmpty()) {
            return new byte[0];
        }
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        IBaseTask baseTask = this.getActiveTask();
        buf.writeBoolean(this.active != null && baseTask != null);
        if (this.active != null && baseTask != null) {
            buf.writeInt(baseTask.getDimension());
            buf.writeByte((int)this.active.getClientDataId());
            PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
            this.active.sendClientData(buffer);
            data = new byte[buffer.writerIndex()];
            buffer.readBytes((byte[])data);
            buf.func_179250_a((byte[])data);
        }
        int usableMiniTasks = 0;
        for (IMiniTask iMiniTask : this.miniTasks.values()) {
            if (!iMiniTask.hasClientOverlay()) continue;
            ++usableMiniTasks;
        }
        buf.writeInt(usableMiniTasks);
        for (Map.Entry entry : this.miniTasks.entrySet()) {
            IMiniTask task = (IMiniTask)entry.getValue();
            if (!task.hasClientOverlay()) continue;
            buf.func_179252_a((UUID)entry.getKey());
            buf.writeByte((int)task.getClientDataId());
            PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
            task.writeData(buffer);
            byte[] data2 = new byte[buffer.writerIndex()];
            buffer.readBytes(data2);
            buf.func_179250_a(data2);
        }
        data = new byte[buf.writerIndex()];
        buf.readBytes((byte[])data);
        return data;
    }

    public <T> T getTasks(TaskPacket.TaskFunction<T> task) {
        return task.apply(new ArrayList<IBaseTask>(PregenTaskStorage.getStorage().getAllTasks()), this.getActiveId(), this.getActivePaused());
    }

    public float getChunksPerTick(int dim) {
        ChunkProcessor processor;
        ITask task;
        if (this.active instanceof ChunkProcessor && (task = (processor = (ChunkProcessor)this.active).getTask()) != null && task.getDimension() == dim) {
            return processor.getCounter().getAverage();
        }
        SpeedEntry entry = PregenConfig.INSTANCE.mappedSpeedConfig.get(dim);
        return entry == null ? 1.0f : entry.getSpeed();
    }

    public long[] getData(int dimension) {
        ChunkProcessor processor;
        ITask task;
        long[] data = new long[2];
        if (this.active instanceof ChunkProcessor && (task = (processor = (ChunkProcessor)this.active).getTask()) != null && task.getDimension() == dimension) {
            data[0] = processor.getMaxProcess();
            data[1] = processor.getCurrentProcessed();
        }
        return data;
    }

    public void startMiniTask(UUID taskId, IMiniTask task) {
        this.miniTasks.put(taskId, task);
    }

    public void interruptMiniTask(UUID taskId) {
        IMiniTask task = this.miniTasks.remove(taskId);
        if (task != null) {
            task.interrupt();
        }
    }

    public boolean isRunning() {
        return this.active != null;
    }

    public IProcessor getActiveProcess() {
        return this.active;
    }

    public IBaseTask getActiveTask() {
        return this.active != null ? this.active.getTask() : null;
    }

    private UUID getActiveId() {
        IBaseTask task = this.getActiveTask();
        return task == null ? null : task.getTaskId();
    }

    private boolean getActivePaused() {
        return this.active != null && this.active.isPaused();
    }

    public void setActiveTask(IProcessor processor) {
        this.active = processor;
    }

    public void onTaskCompleted() {
        this.active = null;
        if (this.shouldFinishListening()) {
            GlobalListeners.INSTANCE.clearListeners();
        }
    }

    public boolean shouldFinishListening() {
        return this.active == null && this.miniTasks.isEmpty();
    }
}

