/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.processor.IBaseTask;
import pregenerator.impl.processor.IProcessor;
import pregenerator.impl.processor.ServerManager;
import pregenerator.impl.processor.generator.BenchmarkManager;
import pregenerator.impl.storage.PregenTaskStorage;

public class TaskActions {
    public static void startTask(IBaseTask task, EntityPlayer player, Consumer<ITextComponent> listener) {
        TaskActions.startTask(task, player == null ? null : player.func_110124_au(), listener);
    }

    public static void pauseTask(Consumer<ITextComponent> listener) {
        IProcessor processor = TaskActions.getActiveProcessor();
        if (processor == null) {
            TaskActions.sendFailure(TextUtil.translate("commands.chunk_pregen.error.pause.no_task"), listener);
            return;
        }
        if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
            TaskActions.sendFailure(TextUtil.translate("commands.chunk_pregen.error.benchmark.pause"), listener);
            return;
        }
        if (processor.isPaused()) {
            TaskActions.sendFailure(TextUtil.translate("commands.chunk_pregen.error.pause.already"), listener);
            return;
        }
        processor.pauseTask();
        listener.accept(TextUtil.translate("commands.chunk_pregen.paused", processor.getTask().getName()));
    }

    public static void resumeTask(Consumer<ITextComponent> listener) {
        IProcessor processor = TaskActions.getActiveProcessor();
        if (processor == null) {
            TaskActions.sendFailure(TextUtil.translate("commands.chunk_pregen.error.resume.no_task"), listener);
            return;
        }
        if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
            TaskActions.sendFailure(TextUtil.translate("commands.chunk_pregen.error.benchmark.resume"), listener);
            return;
        }
        if (!processor.isPaused()) {
            TaskActions.sendFailure(TextUtil.translate("commands.chunk_pregen.error.resume.already"), listener);
            return;
        }
        processor.resumeTask();
        listener.accept(TextUtil.translate("commands.chunk_pregen.resumed", processor.getTask().getName()));
    }

    public static void stopTask(Consumer<ITextComponent> listener) {
        IProcessor processor = TaskActions.getActiveProcessor();
        if (processor == null) {
            TaskActions.sendFailure(TextUtil.translate("commands.chunk_pregen.error.stop.no_task"), listener);
            return;
        }
        String name = processor.getTask().getName();
        processor.stop(false);
        listener.accept(TextUtil.translate("commands.chunk_pregen.stopped", name));
    }

    public static void continueTask(EntityPlayer player, Consumer<ITextComponent> listener) {
        TaskActions.continueTask((String)null, player, listener);
    }

    public static void continueTask(String taskName, EntityPlayer player, Consumer<ITextComponent> listener) {
        IBaseTask task;
        IProcessor processor = TaskActions.getActiveProcessor();
        if (processor != null) {
            TaskActions.sendFailure(TextUtil.translate("commands.chunk_pregen.error.continue.already"), listener);
            return;
        }
        PregenTaskStorage storage = PregenTaskStorage.getStorage();
        IBaseTask iBaseTask = task = taskName != null ? storage.findTask(taskName) : storage.getNextTask();
        if (task == null) {
            TaskActions.sendFailure(TextUtil.translate("commands.chunk_pregen.error.continue.no_task"), listener);
            return;
        }
        TaskActions.continueTask(task, player, listener);
    }

    public static void removeTask(Consumer<ITextComponent> listener) {
        IProcessor processor = TaskActions.getActiveProcessor();
        if (processor != null) {
            String name = processor.getTask().getName();
            processor.stop(false);
            listener.accept(TextUtil.translate("commands.chunk_pregen.stopped", name));
        }
        PregenTaskStorage storage = PregenTaskStorage.getStorage();
        storage.clearAll();
        listener.accept(TextUtil.translate("commands.chunk_pregen.removed_all"));
    }

    public static void removeTask(String taskId, Consumer<ITextComponent> listener) {
        String name;
        IProcessor processor = TaskActions.getActiveProcessor();
        if (processor != null && (name = processor.getTask().getName()).equals(taskId)) {
            processor.stop(false);
            listener.accept(TextUtil.translate("commands.chunk_pregen.stopped", name));
        }
        if (PregenTaskStorage.getStorage().removeTask(taskId)) {
            listener.accept(TextUtil.translate("commands.chunk_pregen.removed", taskId));
            return;
        }
        TaskActions.sendFailure(TextUtil.translate("commands.chunk_pregen.error.remove.no_task", taskId), listener);
    }

    private static boolean isRunning() {
        return ServerManager.INSTANCE.getActiveProcess() != null;
    }

    private static IProcessor getActiveProcessor() {
        return ServerManager.INSTANCE.getActiveProcess();
    }

    private static void sendFailure(ITextComponent text, Consumer<ITextComponent> listener) {
        listener.accept(TextUtil.applyTextStyle(text.func_150259_f(), TextFormatting.RED));
    }

    private static boolean storeTask(IBaseTask task, Consumer<ITextComponent> listener) {
        return PregenTaskStorage.getStorage().storeTask(task, (MessagePassingQueue.Consumer<ITextComponent>)((MessagePassingQueue.Consumer)T -> TaskActions.sendFailure(T, listener)));
    }

    private static void startTask(IBaseTask task, UUID id, Consumer<ITextComponent> listener) {
        if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
            TaskActions.sendFailure(TextUtil.translate("commands.chunk_pregen.benchmark.active_queue"), listener);
            return;
        }
        if (!TaskActions.storeTask(task, listener)) {
            return;
        }
        PregenTaskStorage.getStorage().collectListeners(id);
        TaskActions.startWorkers(task, listener);
    }

    private static void continueTask(IBaseTask task, EntityPlayer player, Consumer<ITextComponent> listener) {
        if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
            TaskActions.sendFailure(TextUtil.translate("commands.chunk_pregen.benchmark.active_queue"), listener);
            return;
        }
        PregenTaskStorage.getStorage().collectListeners(player.func_110124_au());
        TaskActions.startWorkers(task, listener);
    }

    private static void startWorkers(IBaseTask task, Consumer<ITextComponent> listener) {
        if (TaskActions.isRunning()) {
            TaskActions.sendFailure(TextUtil.translate("commands.chunk_pregen.error.already_active"), listener);
            return;
        }
        task.start();
    }
}

