/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor.deleter.tasks;

import java.nio.file.Path;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.processor.ChunkCalculator;
import pregenerator.impl.processor.PrepareProgress;
import pregenerator.impl.processor.deleter.DeleteProcess;
import pregenerator.impl.processor.deleter.tasks.BaseDeletionTask;
import pregenerator.impl.processor.generator.tasks.ITask;

public class DeletionCircleExpansion
extends BaseDeletionTask {
    long center;
    int minRadius;
    int maxRadius;

    public DeletionCircleExpansion(String name, int dimensionId, FilePos center, int minRadius, int maxRadius) {
        super(name, dimensionId);
        this.center = center.asLong();
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
    }

    public DeletionCircleExpansion(NBTTagCompound nbt) {
        super(nbt);
        this.center = nbt.func_74763_f("center");
        this.minRadius = nbt.func_74762_e("min_radius");
        this.maxRadius = nbt.func_74762_e("max_radius");
    }

    @Override
    public NBTTagCompound write() {
        NBTTagCompound nbt = super.write();
        nbt.func_74772_a("center", this.center);
        nbt.func_74768_a("min_radius", this.minRadius);
        nbt.func_74768_a("max_radius", this.maxRadius);
        return nbt;
    }

    @Override
    public byte getId() {
        return 11;
    }

    @Override
    public ITextComponent getShapeName() {
        return TextUtil.translate("task.chunk_pregen.shape_type.circle_expansion");
    }

    @Override
    public ChunkPos getCenter() {
        return new ChunkPos(FilePos.getX(this.center), FilePos.getZ(this.center));
    }

    @Override
    public int getMaxRadius() {
        return this.maxRadius;
    }

    @Override
    public long getTaskSize() {
        return (long)((double)((long)this.maxRadius * 2L) * Math.PI) - (long)((double)((long)this.minRadius * 2L) * Math.PI);
    }

    @Override
    protected void append(ITextComponent text) {
        ChunkPos center = new ChunkPos(FilePos.getX(this.center), FilePos.getZ(this.center));
        ITask.insert("task.chunk_pregen.task_type", TextUtil.translate("task.chunk_pregen.shape_type.circle_expansion"), text, TextFormatting.DARK_PURPLE);
        ITask.insert("task.chunk_pregen.x_coord", center.field_77276_a, text, TextFormatting.YELLOW);
        ITask.insert("task.chunk_pregen.z_coord", center.field_77275_b, text, TextFormatting.YELLOW);
        ITask.insert("task.chunk_pregen.min_radius", this.minRadius, text, TextFormatting.BLUE);
        ITask.insert("task.chunk_pregen.max_radius", this.maxRadius, text, TextFormatting.BLUE);
    }

    @Override
    protected DeleteProcess createTask(WorldServer world, Path folder, PrepareProgress progress) {
        progress.setMax(this.getTaskSize());
        FilePos center = new FilePos(this.center);
        return new DeleteProcess(folder, ChunkCalculator.getCircleExpansionShape(center.x, center.z, this.minRadius, this.maxRadius, progress));
    }
}

