/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor.deleter.tasks;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.processor.ChunkCalculator;
import pregenerator.impl.processor.PrepareProgress;
import pregenerator.impl.processor.deleter.DeleteProcess;
import pregenerator.impl.processor.deleter.tasks.BaseDeletionTask;
import pregenerator.impl.processor.generator.tasks.ITask;

public class DeletionSpecific
extends BaseDeletionTask {
    List<Long> positions;

    public DeletionSpecific(NBTTagCompound nbt) {
        super(nbt);
        this.positions = new ArrayList<Long>();
        NBTTagList list = nbt.func_150295_c("positions", 4);
        int m = list.func_74745_c();
        for (int i = 0; i < m; ++i) {
            this.positions.add(((NBTPrimitive)list.func_179238_g(i)).func_150291_c());
        }
    }

    public DeletionSpecific(String name, int dimensionId, List<Long> positions) {
        super(name, dimensionId);
        this.positions = positions;
    }

    @Override
    public ChunkPos getCenter() {
        return new ChunkPos(0, 0);
    }

    @Override
    public int getMaxRadius() {
        return 0;
    }

    @Override
    public byte getId() {
        return 16;
    }

    @Override
    public ITextComponent getShapeName() {
        return TextUtil.translate("task.chunk_pregen.shape_type.specifc");
    }

    @Override
    public long getTaskSize() {
        return this.positions.size();
    }

    @Override
    public NBTTagCompound write() {
        NBTTagCompound nbt = super.write();
        NBTTagList list = new NBTTagList();
        for (Long entry : this.positions) {
            list.func_74742_a((NBTBase)new NBTTagLong(entry.longValue()));
        }
        nbt.func_74782_a("positions", (NBTBase)list);
        return nbt;
    }

    @Override
    protected void append(ITextComponent builder) {
        ITask.insert("task.chunk_pregen.amount", this.positions.size(), builder, TextFormatting.YELLOW);
    }

    @Override
    protected DeleteProcess createTask(WorldServer world, Path folder, PrepareProgress progress) {
        progress.setMax(this.getTaskSize());
        return new DeleteProcess(folder, ChunkCalculator.genSpecific(this.positions, progress));
    }
}

