/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor.deleter.tasks;

import java.nio.file.Path;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.processor.ChunkCalculator;
import pregenerator.impl.processor.PrepareProgress;
import pregenerator.impl.processor.deleter.DeleteProcess;
import pregenerator.impl.processor.deleter.tasks.BaseDeletionTask;
import pregenerator.impl.processor.generator.tasks.ITask;

public class DeletionSquare
extends BaseDeletionTask {
    long center;
    int radius;

    public DeletionSquare(String name, int dimensionId, FilePos center, int radius) {
        super(name, dimensionId);
        this.center = center.asLong();
        this.radius = radius;
    }

    public DeletionSquare(NBTTagCompound nbt) {
        super(nbt);
        this.center = nbt.func_74763_f("center");
        this.radius = nbt.func_74762_e("radius");
    }

    @Override
    public NBTTagCompound write() {
        NBTTagCompound nbt = super.write();
        nbt.func_74772_a("center", this.center);
        nbt.func_74768_a("radius", this.radius);
        return nbt;
    }

    @Override
    public byte getId() {
        return 8;
    }

    @Override
    public ITextComponent getShapeName() {
        return TextUtil.translate("task.chunk_pregen.shape_type.square");
    }

    @Override
    public ChunkPos getCenter() {
        return new ChunkPos(FilePos.getX(this.center), FilePos.getZ(this.center));
    }

    @Override
    public int getMaxRadius() {
        return this.radius;
    }

    @Override
    public long getTaskSize() {
        return (long)(this.radius * this.radius) * 4L;
    }

    @Override
    protected void append(ITextComponent text) {
        ChunkPos center = new ChunkPos(FilePos.getX(this.center), FilePos.getZ(this.center));
        ITask.insert("task.chunk_pregen.task_type", TextUtil.translate("task.chunk_pregen.shape_type.square"), text, TextFormatting.DARK_PURPLE);
        ITask.insert("task.chunk_pregen.x_coord", center.field_77276_a, text, TextFormatting.YELLOW);
        ITask.insert("task.chunk_pregen.z_coord", center.field_77275_b, text, TextFormatting.YELLOW);
        ITask.insert("task.chunk_pregen.radius", this.radius, text, TextFormatting.BLUE);
    }

    @Override
    protected DeleteProcess createTask(WorldServer world, Path folder, PrepareProgress progress) {
        progress.setMax(this.getTaskSize());
        FilePos center = new FilePos(this.center);
        return new DeleteProcess(folder, ChunkCalculator.getSquareShape(center.x, center.z, this.radius, progress));
    }
}

