/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor.deleter.tasks;

import java.nio.file.Path;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.misc.Area;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.processor.ChunkCalculator;
import pregenerator.impl.processor.PrepareProgress;
import pregenerator.impl.processor.deleter.DeleteProcess;
import pregenerator.impl.processor.deleter.tasks.BaseDeletionTask;
import pregenerator.impl.processor.generator.tasks.ITask;

public class DeletionSquareArea
extends BaseDeletionTask {
    long min;
    long max;
    long center;

    public DeletionSquareArea(String name, int dimensionId, FilePos min, FilePos max) {
        super(name, dimensionId);
        this.min = min.asLong();
        this.max = max.asLong();
        this.center = FilePos.asLong(min.x + (max.x - min.x) / 2, min.z + (max.z - min.z) / 2);
    }

    public DeletionSquareArea(NBTTagCompound nbt) {
        super(nbt);
        this.min = nbt.func_74763_f("min");
        this.max = nbt.func_74763_f("max");
        this.center = nbt.func_74763_f("center");
    }

    @Override
    public NBTTagCompound write() {
        NBTTagCompound tag = super.write();
        tag.func_74772_a("min", this.min);
        tag.func_74772_a("max", this.max);
        tag.func_74772_a("center", this.center);
        return tag;
    }

    @Override
    public ChunkPos getCenter() {
        return new ChunkPos(FilePos.getX(this.center), FilePos.getZ(this.center));
    }

    @Override
    public int getMaxRadius() {
        return Math.max((FilePos.getX(this.max) - FilePos.getX(this.min)) / 2, (FilePos.getZ(this.max) - FilePos.getZ(this.min)) / 2);
    }

    @Override
    public Area getArea() {
        return new Area(new ChunkPos(FilePos.getX(this.min), FilePos.getZ(this.min)), new ChunkPos(FilePos.getX(this.max), FilePos.getZ(this.max)));
    }

    @Override
    public byte getId() {
        return 12;
    }

    @Override
    public ITextComponent getShapeName() {
        return TextUtil.translate("task.chunk_pregen.shape_type.square_area");
    }

    @Override
    public long getTaskSize() {
        long x = FilePos.getX(this.max) - FilePos.getX(this.min);
        long z = FilePos.getZ(this.max) - FilePos.getZ(this.min);
        return x * z * 4L;
    }

    @Override
    public void append(ITextComponent builder) {
        FilePos min = new FilePos(this.min);
        FilePos max = new FilePos(this.max);
        ITask.insert("task.chunk_pregen.task_type", TextUtil.translate("task.chunk_pregen.shape_type.square_area"), builder, TextFormatting.DARK_PURPLE);
        ITask.insert("task.chunk_pregen.from", new Object[]{min.x, min.z}, builder, TextFormatting.YELLOW);
        ITask.insert("task.chunk_pregen.to", new Object[]{max.x, max.z}, builder, TextFormatting.YELLOW);
    }

    @Override
    public DeleteProcess createTask(WorldServer world, Path folder, PrepareProgress progress) {
        progress.setMax(this.getTaskSize());
        FilePos min = new FilePos(this.min);
        FilePos max = new FilePos(this.max);
        return new DeleteProcess(folder, ChunkCalculator.genSquareArea(min.x, min.z, max.x, max.z, progress));
    }
}

