/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor.generator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.lang3.time.DurationFormatUtils;
import pregenerator.PregenConfig;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.storage.GlobalListeners;
import pregenerator.impl.storage.ProcessListener;

public class BenchmarkManager {
    public static final BenchmarkManager INSTANCE = new BenchmarkManager();
    List<BenchmarkResult> results = new ObjectArrayList();
    UUID sessionInstance = UUID.randomUUID();
    UUID starter = null;

    public boolean isBenchmarkRunning() {
        return this.starter != null;
    }

    public void interruptBenchmark() {
        this.starter = null;
        this.results.clear();
    }

    public void startBenchmark(UUID starter) {
        this.starter = starter;
    }

    public void addBenchmarkResult(long original, long chunks, long time, boolean small, World type) {
        if (this.starter == null || (double)chunks / (double)original < 0.75) {
            return;
        }
        this.results.add(new BenchmarkResult(original, chunks, time, small, type.field_73011_w.getDimension()));
    }

    public void onBenchmarkFinished() {
        if (this.results.isEmpty() || this.starter == null) {
            this.results.clear();
            this.starter = null;
            return;
        }
        Consumer<ITextComponent> listener = GlobalListeners.INSTANCE::sendMessage;
        if (!GlobalListeners.INSTANCE.containsListener(ProcessListener.create(this.starter))) {
            listener = listener.andThen(ProcessListener.create(this.starter)::sendMessage);
        }
        int score = 0;
        long time = 0L;
        long chunks = 0L;
        for (BenchmarkResult result : this.results) {
            score += result.score();
            time += result.time;
            chunks += result.chunks;
        }
        listener.accept(TextUtil.translate("commands.chunk_pregen.benchmark.result"));
        listener.accept(TextUtil.translate("commands.chunk_pregen.benchmark.result.total", TextUtil.NUMBERS.format(chunks), this.time(time), TextUtil.FLOATING_NUMBERS_EXTENDED.format(score)));
        for (BenchmarkResult result : this.results) {
            listener.accept(TextUtil.translate("commands.chunk_pregen.benchmark.result.dimension", TextUtil.dimension(result.dim), TextUtil.NUMBERS.format(result.chunks), this.time(result.time), TextUtil.FLOATING_NUMBERS_EXTENDED.format(result.score())));
        }
        listener.accept(TextUtil.translate("commands.chunk_pregen.benchmark.result.info"));
        this.saveResults(listener);
        this.starter = null;
        this.results.clear();
    }

    private void saveResults(Consumer<ITextComponent> listener) {
        listener.accept(TextUtil.translate("commands.chunk_pregen.benchmark.result.saving"));
        File base = FMLCommonHandler.instance().getMinecraftServerInstance().func_71238_n();
        File userBenchmarks = new File(base, "Pregen_Benchmarks.json");
        JsonObject obj = new JsonObject();
        if (userBenchmarks.exists()) {
            try (BufferedReader reader2 = new BufferedReader(new FileReader(userBenchmarks));){
                obj = new JsonParser().parse((Reader)reader2).getAsJsonObject();
            }
            catch (Exception reader2) {
                // empty catch block
            }
        }
        JsonArray array = obj.has("results") ? obj.getAsJsonArray("results") : new JsonArray();
        obj.add("results", (JsonElement)array);
        array.add((JsonElement)this.createUserData());
        try (JsonWriter writer = new JsonWriter((Writer)new BufferedWriter(new FileWriter(userBenchmarks)));){
            writer.setIndent(" ");
            Streams.write((JsonElement)obj, (JsonWriter)writer);
            writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JsonObject createUserData() {
        JsonObject obj = new JsonObject();
        obj.addProperty("seed", (Number)DimensionManager.getWorld((int)0).func_72905_C());
        obj.addProperty("game_version", "1.12.2");
        obj.addProperty("starter", this.starter.toString());
        obj.addProperty("ms_per_tick", (Number)PregenConfig.INSTANCE.timePerTick.get());
        obj.addProperty("priority", Boolean.valueOf(PregenConfig.INSTANCE.priority.get().isPregenerator()));
        obj.addProperty("allocated_ram", (Number)Runtime.getRuntime().maxMemory());
        JsonArray data = new JsonArray();
        for (BenchmarkResult result : this.results) {
            data.add((JsonElement)result.save());
        }
        obj.add("results", (JsonElement)data);
        data = new JsonArray();
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            data.add((mod.getModId() + ";" + mod.getVersion()).toLowerCase());
        }
        obj.add("mods", (JsonElement)data);
        return obj;
    }

    private String time(long value) {
        return DurationFormatUtils.formatDuration((long)value, (String)"HH:mm:ss");
    }

    public static enum BenchmarkSize {
        SMALL_TASK,
        LARGE_TASK;


        public boolean isSmall() {
            return this == SMALL_TASK;
        }

        public boolean isLarge() {
            return this == LARGE_TASK;
        }
    }

    public static class BenchmarkResult {
        long originalChunks;
        long chunks;
        long time;
        boolean small;
        int dim;

        public BenchmarkResult(long originalChunks, long chunks, long time, boolean small, int dim) {
            this.originalChunks = originalChunks;
            this.chunks = chunks;
            this.small = small;
            this.dim = dim;
        }

        public int score() {
            return (int)(this.time / this.chunks);
        }

        public JsonObject save() {
            JsonObject obj = new JsonObject();
            obj.addProperty("original_size", (Number)this.originalChunks);
            obj.addProperty("chunks", (Number)this.chunks);
            obj.addProperty("score", (Number)this.score());
            obj.addProperty("time", (Number)this.time);
            obj.addProperty("dim", DimensionManager.getProviderType((int)this.dim).func_186065_b().toLowerCase(Locale.ROOT));
            obj.addProperty("size", (Number)(this.small ? 40000 : 250000));
            return obj;
        }
    }
}

