/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor.generator;

import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.storage.ThreadedFileIOBase;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import pregenerator.impl.misc.Area;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.misc.ProcessResult;
import pregenerator.impl.processor.PrepareProgress;
import pregenerator.impl.processor.generator.ChunkEntry;
import pregenerator.impl.processor.generator.ChunkHelper;
import pregenerator.impl.processor.generator.GenerationType;
import pregenerator.impl.processor.generator.tasks.ITask;
import pregenerator.impl.storage.PregenTaskStorage;

public class ChunkProcess {
    Map<File, RegionFile> fileSystem;
    WorldServer world;
    ChunkProviderServer chunkProvider;
    ChunkHelper helper;
    Area fullArea;
    File worldFile;
    ITask task;
    PregenTaskStorage.PregenMemory memory;
    Set<Long> forcedChunks = new HashSet<Long>();
    List<ChunkEntry> toLight = new ArrayList<ChunkEntry>();
    List<ChunkEntry> entries = new ArrayList<ChunkEntry>();
    long totalWorkList = 0L;
    long startMemory;
    int startingChunkCount = 0;
    long lastPos;

    public ChunkProcess(WorldServer server, ITask theTask) {
        this.world = server;
        this.worldFile = new File(server.getChunkSaveLocation(), "region");
        this.chunkProvider = server.func_72863_F();
        this.helper = new ChunkHelper(this.chunkProvider, server);
        this.startingChunkCount = this.chunkProvider.func_73152_e();
        this.task = theTask;
        this.fileSystem = (Map)ReflectionHelper.getPrivateValue(RegionFileCache.class, null, (String[])new String[]{"REGIONS_BY_FILE", "field_76553_a"});
        if (this.fileSystem == null) {
            throw new IllegalStateException("FileSystem couldn't be found");
        }
    }

    public void addTaskList(Map<Long, BitSet> positions, FilePos center, PrepareProgress progress) {
        this.memory = PregenTaskStorage.getStorage().getOrCreateMemory(this.task);
        this.fullArea = new Area(new ChunkPos(center.x, center.z), 0);
        progress.addMax(positions.size());
        ((ArrayList)this.entries).ensureCapacity(positions.size());
        GenerationType type = this.task.getType();
        RegionProvider provider = new RegionProvider(this);
        for (Map.Entry<Long, BitSet> entry : positions.entrySet()) {
            ChunkEntry chunk = new ChunkEntry(this, entry.getKey(), entry.getValue(), type);
            chunk.init(provider);
            int size = chunk.getMaxSize();
            if (size > 0) {
                this.totalWorkList += (long)size;
                if (chunk.isLighting()) {
                    this.toLight.add(chunk);
                } else {
                    this.entries.add(chunk);
                }
                this.fullArea.expand(chunk.getArea());
            }
            progress.growValue(1);
        }
        this.entries.sort(new Sorter(center).reversed());
    }

    public void onTickStart() {
        this.forcedChunks.clear();
        for (ChunkPos pos : this.world.getPersistentChunks().keys()) {
            this.forcedChunks.add(FilePos.asLong(pos.field_77276_a, pos.field_77275_b));
        }
        this.helper.cleanUp();
    }

    public void setStartMemory() {
        this.startMemory = this.getCurrentMemoryUsage();
    }

    public boolean memoryToBig() {
        long currentUsage = this.getCurrentMemoryUsage() - this.startMemory;
        return (currentUsage = currentUsage / 1024L / 1024L) > 2048L || this.fileSystem != null && this.fileSystem.size() > 120;
    }

    private long getCurrentMemoryUsage() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public void onRemove() {
        this.save();
        this.task.onTaskStopped((World)this.world, null, 0L);
        this.fileSystem = null;
        this.world = null;
        this.chunkProvider = null;
        this.helper = null;
        this.worldFile = null;
        this.task = null;
        this.forcedChunks = null;
    }

    public boolean hasWork() {
        return this.entries.size() > 0;
    }

    public ProcessResult tick() {
        ChunkEntry entry = this.entries.get(this.entries.size() - 1);
        this.lastPos = entry.getPos();
        ProcessResult result = entry.tick();
        if (entry.isDone()) {
            if (this.task.getType() != GenerationType.TERRAIN_ONLY) {
                this.toLight.add(this.entries.remove(this.entries.size() - 1));
            } else {
                this.entries.remove(this.entries.size() - 1);
            }
            entry.cleanup(false);
        }
        return result;
    }

    public boolean hasLight() {
        return this.toLight.size() > 0;
    }

    public void checkLight() {
        ChunkEntry entry = this.toLight.get(0);
        entry.checkLight();
        if (entry.isDone()) {
            this.toLight.remove(0);
            entry.cleanup(true);
        }
    }

    public long getTotalWorkList() {
        return this.totalWorkList;
    }

    public ITask getTask() {
        return this.task;
    }

    public int getActiveRegionFiles() {
        return this.fileSystem == null ? 0 : this.fileSystem.size();
    }

    public int getLoadedChunks() {
        return this.chunkProvider.func_73152_e();
    }

    public Area getWorkingArea() {
        return this.entries.isEmpty() ? null : this.entries.get(this.entries.size() - 1).getArea();
    }

    public boolean containsChunk(int x, int z) {
        return this.world.func_184164_w().func_187301_b(x, z) != null || this.forcedChunks.contains(FilePos.asLong(x, z));
    }

    public RegionFile getFile(int x, int z) {
        File file = new File(this.worldFile, "r." + (x >> 5) + "." + (z >> 5) + ".mca");
        return this.fileSystem.computeIfAbsent(file, T -> T.exists() ? new RegionFile(file) : null);
    }

    public void save() {
        try {
            ThreadedFileIOBase.func_178779_a().func_75734_a();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unloadChunks() {
        for (Chunk chunk : this.chunkProvider.func_189548_a()) {
            if (this.containsChunk(chunk.field_76635_g, chunk.field_76647_h)) continue;
            this.helper.unloadChunk(chunk);
        }
        int amount = this.helper.getChunkCount() - this.startingChunkCount;
        if (amount >= 3000) {
            if (this.helper.getChunkCount() > 5000) {
                amount = this.helper.getChunkCount();
            }
            amount /= 100;
            for (int i = 0; i < amount; ++i) {
                this.chunkProvider.func_73156_b();
            }
        }
    }

    public ChunkProviderServer getProvider() {
        return this.chunkProvider;
    }

    public void unloadChunk(Chunk chunk) {
        if (this.containsChunk(chunk.field_76635_g, chunk.field_76647_h)) {
            return;
        }
        this.helper.unloadChunk(chunk);
    }

    public ChunkHelper getHelper() {
        return this.helper;
    }

    static class RegionProvider {
        static final BitSet EMPTY = new BitSet(0);
        static final BitSet FULL = RegionProvider.create();
        Map<Long, BitSet> map = new LinkedHashMap<Long, BitSet>();
        ChunkProcess process;

        public RegionProvider(ChunkProcess process) {
            this.process = process;
        }

        public boolean getChunk(int chunkX, int chunkZ) {
            return this.get(chunkX, chunkZ).get((chunkZ & 0x1F) * 32 + (chunkX & 0x1F));
        }

        public BitSet get(int chunkX, int chunkZ) {
            BitSet set = this.map.get(ChunkPos.func_77272_a((int)(chunkX >> 5), (int)(chunkZ >> 5)));
            if (set == null) {
                RegionFile file = this.process.getFile(chunkX, chunkZ);
                if (file != null) {
                    set = new BitSet(1024);
                    set.clear();
                    for (int i = 0; i < 1024; ++i) {
                        if (!file.func_76709_c(i % 32, i / 32)) continue;
                        set.set(i);
                    }
                    if (set.equals(FULL)) {
                        set = FULL;
                    }
                    this.map.put(ChunkPos.func_77272_a((int)(chunkX >> 5), (int)(chunkZ >> 5)), set);
                } else {
                    this.map.put(ChunkPos.func_77272_a((int)(chunkX >> 5), (int)(chunkZ >> 5)), EMPTY);
                    set = EMPTY;
                }
            }
            return set;
        }

        static BitSet create() {
            BitSet set = new BitSet(1024);
            set.set(0, 1023);
            return set;
        }
    }

    public static class Sorter
    implements Comparator<ChunkEntry> {
        FilePos pos;

        public Sorter(FilePos pos) {
            this.pos = pos.toChunkFile();
        }

        @Override
        public int compare(ChunkEntry o1, ChunkEntry o2) {
            int value = o1.getPosition().getDistance(this.pos.x, this.pos.z) - o2.getPosition().getDistance(this.pos.x, this.pos.z);
            return value > 0 ? 1 : (value < 0 ? -1 : 0);
        }
    }
}

