/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor.minitasks;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.DataInputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import pregenerator.ChunkPregenerator;
import pregenerator.impl.misc.TrackedRegionFile;
import pregenerator.impl.processor.minitasks.BaseScanTask;

public abstract class BaseChunkScanTask<T>
extends BaseScanTask {
    protected int chunksScanned = 0;
    protected int totalChunks = 0;
    protected int filesScanned = 0;
    protected int totalFiles = 0;
    boolean started = false;
    int progress = 0;
    ExecutorCompletionService<Integer> service = new ExecutorCompletionService(ChunkPregenerator.CHUNK_PROCESS_QUEUE);
    List<Future<Integer>> tasks = new ArrayList<Future<Integer>>();

    public BaseChunkScanTask(int dimension, UUID source) {
        super(dimension, source);
    }

    @Override
    public void interrupt() {
        for (Future<Integer> entry : this.tasks) {
            if (entry.isDone()) continue;
            entry.cancel(false);
        }
        this.tasks.clear();
    }

    @Override
    public boolean update(long startTime) {
        if (!this.started) {
            this.started = true;
            for (Path path : this.getRegionFiles()) {
                this.tasks.add(this.service.submit(new Task(path)));
                this.totalChunks += 1024;
                ++this.totalFiles;
            }
            this.onInit();
            return true;
        }
        if (this.filesScanned < this.totalFiles) {
            Future<Integer> output = null;
            while (System.currentTimeMillis() - startTime < 50L && (output = this.service.poll()) != null) {
                int value = this.getSave(output);
                this.chunksScanned += value;
                this.totalChunks -= 1024 - value;
                ++this.filesScanned;
                int newProgress = (int)((float)this.filesScanned / (float)this.totalFiles * 100.0f);
                if (newProgress == this.progress) continue;
                this.progress = newProgress;
                this.onProgressReached(newProgress);
            }
            return true;
        }
        this.onCompletion();
        return false;
    }

    protected int process(Path regionFile) {
        ChunkPos region = this.getRegionPosition(regionFile);
        if (region == null) {
            return 0;
        }
        int result = 0;
        ObjectArrayList list = new ObjectArrayList();
        try {
            TrackedRegionFile file = new TrackedRegionFile(regionFile.toFile());
            for (int i = 0; i < 1024; ++i) {
                int x = i % 32;
                int z = i / 32;
                if (!file.func_76709_c(x, z)) continue;
                try (DataInputStream stream = file.func_76704_a(x, z);){
                    this.test(CompressedStreamTools.func_74794_a((DataInputStream)stream), ((List)list)::add);
                }
                catch (Exception e) {
                    this.onFailure(new ChunkPos((region.field_77276_a << 5) + x, (region.field_77275_b << 5) + z), ((List)list)::add);
                }
                ++result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.processResult((List<T>)list);
        return result;
    }

    protected abstract void test(NBTTagCompound var1, Consumer<T> var2);

    protected abstract void onFailure(ChunkPos var1, Consumer<T> var2);

    protected abstract void onInit();

    protected abstract void onProgressReached(int var1);

    protected abstract void processResult(List<T> var1);

    protected abstract void onCompletion();

    protected int getSave(Future<Integer> output) {
        try {
            return output.get();
        }
        catch (Exception e) {
            return 0;
        }
    }

    private class Task
    implements Callable<Integer> {
        Path path;

        public Task(Path path) {
            this.path = path;
        }

        @Override
        public Integer call() throws Exception {
            return BaseChunkScanTask.this.process(this.path);
        }
    }
}

