/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.retrogen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringJoiner;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import pregenerator.PregenConfig;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.misc.TrackerSet;

public final class RetrogenManager {
    public static final RetrogenManager INSTANCE = new RetrogenManager();
    Set<IWorldGenerator> generators;
    Map<IWorldGenerator, ModContainer> generatorToId = new HashMap<IWorldGenerator, ModContainer>();
    Map<ModContainer, List<IWorldGenerator>> idToGenerator = new HashMap<ModContainer, List<IWorldGenerator>>();
    Map<String, IWorldGenerator> activeGenerators = new LinkedHashMap<String, IWorldGenerator>();
    Set<Long> chunksToIgnore = new HashSet<Long>();

    private RetrogenManager() {
    }

    public void fetchGenerators() {
        this.generators = this.getGenerators();
    }

    public void preInit() {
        this.updateActiveGenerators(Arrays.asList(PregenConfig.INSTANCE.activeRetrogenerators.get()));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public List<String> getAllGenerators() {
        ArrayList<String> result = new ArrayList<String>();
        for (IWorldGenerator generator : this.generators) {
            result.add(generator.getClass().getName());
        }
        return result;
    }

    public List<String> getInactiveGenerators() {
        List<String> result = this.getAllGenerators();
        result.removeIf(this.activeGenerators::containsKey);
        return result;
    }

    public boolean isValidGenerator(String name) {
        for (IWorldGenerator generator : this.generators) {
            if (!generator.getClass().getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isActive(String name) {
        return this.activeGenerators.containsKey(name);
    }

    public Set<String> getActiveGenerators() {
        return new LinkedHashSet<String>(this.activeGenerators.keySet());
    }

    public List<String> getKnownMods() {
        LinkedHashSet<String> output = new LinkedHashSet<String>();
        HashSet<IWorldGenerator> generators = new HashSet<IWorldGenerator>(this.generators);
        for (Map.Entry<IWorldGenerator, ModContainer> entry : this.generatorToId.entrySet()) {
            generators.remove(entry.getKey());
            output.add(entry.getValue().getModId());
        }
        if (generators.size() > 0) {
            output.add("Unknown");
        }
        return new ArrayList<String>(output);
    }

    public List<String> getGeneratorsForMod(String mod) {
        if (mod == null || mod.equalsIgnoreCase("Unknown")) {
            ArrayList<String> list = new ArrayList<String>();
            for (IWorldGenerator generator : this.generators) {
                if (this.generatorToId.containsKey(generator)) continue;
                list.add(generator.getClass().getName());
            }
            return list;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (IWorldGenerator generator : this.idToGenerator.getOrDefault(Loader.instance().getIndexedModList().get(mod), Collections.emptyList())) {
            list.add(generator.getClass().getName());
        }
        return list;
    }

    public void updateActiveGenerators(List<String> list) {
        this.activeGenerators.clear();
        for (String value : list) {
            IWorldGenerator generator = this.findGenerator(value);
            if (generator == null) continue;
            this.activeGenerators.put(generator.getClass().getName(), generator);
        }
    }

    public boolean isGeneratorActive(String name) {
        return this.activeGenerators.containsKey(name);
    }

    private IWorldGenerator findGenerator(String name) {
        for (IWorldGenerator gen : this.generators) {
            if (!gen.getClass().getName().equalsIgnoreCase(name)) continue;
            return gen;
        }
        return null;
    }

    public String getModForGenerator(String id) {
        IWorldGenerator generator = this.findGenerator(id);
        if (generator == null) {
            return "Unknown";
        }
        ModContainer container = this.generatorToId.get(generator);
        return container == null ? "Unknown" : container.getName();
    }

    public void toggleClient(String name, boolean state) {
        if (state) {
            IWorldGenerator generator = this.findGenerator(name);
            if (generator != null) {
                this.activeGenerators.put(generator.getClass().getName(), generator);
            }
            return;
        }
        this.activeGenerators.remove(name);
    }

    public void enableGenerator(String name) {
        IWorldGenerator generator = this.findGenerator(name);
        if (generator != null) {
            this.activeGenerators.put(generator.getClass().getName(), generator);
            this.updateConfig();
        }
    }

    public void disableGenerator(String name) {
        if (this.activeGenerators.remove(name) != null) {
            this.updateConfig();
        }
    }

    private void updateConfig() {
        PregenConfig config = PregenConfig.INSTANCE;
        config.activeRetrogenerators.set(this.activeGenerators.keySet().toArray(new String[this.activeGenerators.size()]));
        config.save();
    }

    public boolean retrogenChunk(Chunk chunk, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int chunkX = chunk.field_76635_g;
        int chunkZ = chunk.field_76647_h;
        long chunkPos = FilePos.asLong(chunkX, chunkZ);
        if (this.chunksToIgnore.contains(chunkPos)) {
            return false;
        }
        World world = chunk.func_177412_p();
        long worldSeed = world.func_72905_C();
        Random fmlRandom = new Random(worldSeed);
        long xSeed = fmlRandom.nextLong() >> 3;
        long zSeed = fmlRandom.nextLong() >> 3;
        long chunkSeed = xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed;
        for (IWorldGenerator generator : this.activeGenerators.values()) {
            try {
                fmlRandom.setSeed(chunkSeed);
                generator.generate(fmlRandom, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.chunksToIgnore.add(chunkPos);
        return true;
    }

    private Set<IWorldGenerator> getGenerators() {
        try {
            TrackerSet<IWorldGenerator> generators = (TrackerSet<IWorldGenerator>)ReflectionHelper.getPrivateValue(GameRegistry.class, null, (String[])new String[]{"worldGenerators"});
            generators = new TrackerSet<IWorldGenerator>(generators, this::mapMod);
            ReflectionHelper.setPrivateValue(GameRegistry.class, null, generators, (String[])new String[]{"worldGenerators"});
            return generators;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashSet<IWorldGenerator>();
        }
    }

    private void mapMod(IWorldGenerator generator) {
        ModContainer container = Loader.instance().activeModContainer();
        if (container == null) {
            return;
        }
        this.generatorToId.put(generator, container);
        this.idToGenerator.computeIfAbsent(container, T -> new ArrayList()).add(generator);
    }

    private String getCurrentType() {
        StringJoiner joiner = new StringJoiner(";");
        this.activeGenerators.keySet().forEach(joiner::add);
        return joiner.toString();
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load evt) {
        if (this.activeGenerators.size() > 0 && evt.getData().func_74764_b(this.getCurrentType())) {
            Chunk chunk = evt.getChunk();
            this.chunksToIgnore.add(FilePos.asLong(chunk.field_76635_g, chunk.field_76647_h));
        }
    }

    @SubscribeEvent
    public void onChunkSave(ChunkDataEvent.Save evt) {
        Chunk chunk = evt.getChunk();
        if (this.chunksToIgnore.contains(FilePos.asLong(chunk.field_76635_g, chunk.field_76647_h))) {
            evt.getData().func_74757_a(this.getCurrentType(), true);
        }
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload evt) {
        Chunk chunk = evt.getChunk();
        this.chunksToIgnore.remove(FilePos.asLong(chunk.field_76635_g, chunk.field_76647_h));
    }

    public void onServerStopped() {
        this.chunksToIgnore.clear();
    }
}

