/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.tracking.types;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.BlockStateContainer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IBlockStatePalette;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.registries.ForgeRegistry;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.network.ProgressPacket;
import pregenerator.impl.processor.ServerManager;
import pregenerator.impl.processor.minitasks.IMiniTask;
import pregenerator.impl.tracking.ServerTracker;
import pregenerator.impl.tracking.WorldTracker;
import pregenerator.impl.tracking.types.BaseWorldEntry;
import pregenerator.impl.tracking.types.IWorldEntry;

public class BlockEntry
extends BaseWorldEntry {
    public BlockEntry(PacketBuffer buf) {
        super(buf);
    }

    public BlockEntry(Block block, int count) {
        super(BlockEntry.getId(ForgeRegistries.BLOCKS, block), count);
    }

    public BlockEntry(int id, int count) {
        super(id, count);
    }

    public boolean isTicking() {
        return this.getType().func_149653_t();
    }

    public Block getType() {
        return (Block)((ForgeRegistry)ForgeRegistries.BLOCKS).getValue(this.id);
    }

    @Override
    protected ResourceLocation getKey(int id) {
        return ((Block)((ForgeRegistry)ForgeRegistries.BLOCKS).getValue(id)).getRegistryName();
    }

    @Override
    public ITextComponent getName() {
        return TextUtil.translate(this.getType().func_149732_F());
    }

    public static List<IWorldEntry> getLevel(WorldServer level) {
        return FetchBlocks.fetch(ServerTracker.INSTANCE.getWorld(level.field_73011_w.getDimension()));
    }

    public static List<IWorldEntry> getChunk(Chunk chunk) {
        BaseWorldEntry.Counter<Block> counter = BlockEntry.countBlocks(chunk);
        counter.remove(T -> T.func_149688_o(T.func_176223_P()) == Material.field_151579_a);
        return counter.map(BlockEntry::new);
    }

    private static BaseWorldEntry.Counter<Block> countBlocks(Chunk chunk) {
        BaseWorldEntry.Counter<Block> counter = new BaseWorldEntry.Counter<Block>();
        for (ExtendedBlockStorage section : chunk.func_76587_i()) {
            if (section == null || section.func_76663_a()) continue;
            for (int i = 0; i < 4096; ++i) {
                counter.add(section.func_177485_a(i & 0xF, i >> 8 & 0xF, i >> 4 & 0xF).func_177230_c());
            }
        }
        return counter;
    }

    @Override
    public boolean canDelete(boolean chunk) {
        return true;
    }

    @Override
    public int deleteWorld(WorldTracker tracker, EntityPlayer player) {
        if (this.getCount() >= 100000) {
            UUID taskId = UUID.randomUUID();
            LongArrayList list = new LongArrayList();
            for (Chunk chunk : tracker.getChunks()) {
                ChunkPos pos = chunk.func_76632_l();
                list.add(FilePos.asLong(pos.field_77276_a, pos.field_77275_b));
            }
            ChunkPregenerator.NETWORKING.sendToPlayer(new ProgressPacket.Start(this.getCount(), taskId, TextUtil.literal("Deleting Blocks")), player);
            ServerManager.INSTANCE.startMiniTask(taskId, new DeletionTask(tracker, (LongList)list, player, this.getType(), this.getCount()));
            return this.getCount();
        }
        int count = 0;
        Block block = this.getType();
        for (Chunk chunk : tracker.getChunks()) {
            int xOff = chunk.func_76632_l().field_77276_a << 4;
            int zOff = chunk.func_76632_l().field_77275_b << 4;
            ExtendedBlockStorage[] sections = chunk.func_76587_i();
            for (int y = sections.length - 1; y >= 0; --y) {
                ExtendedBlockStorage section = sections[y];
                if (section == null || section.func_76663_a() || !BlockEntry.containsBlock(section, block)) continue;
                for (int i = 0; i < 4096; ++i) {
                    BlockPos pos = new BlockPos(i % 16 + xOff, i / 16 % 16 + section.func_76662_d(), i / 256 + zOff);
                    if (chunk.func_177435_g(pos).func_177230_c() != block) continue;
                    tracker.world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    ++count;
                }
            }
        }
        return count;
    }

    @Override
    public int deleteChunk(WorldTracker tracker, long position) {
        Chunk chunk = tracker.getChunk(position);
        if (chunk == null) {
            return 0;
        }
        int xOff = FilePos.getX(position) << 4;
        int zOff = FilePos.getZ(position) << 4;
        Block block = this.getType();
        int count = 0;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (ExtendedBlockStorage section : chunk.func_76587_i()) {
            if (section == null || section.func_76663_a() || !BlockEntry.containsBlock(section, block)) continue;
            for (int i = 0; i < 4096; ++i) {
                int x = i % 16;
                int y = i / 16 % 16;
                int z = i / 256;
                if (section.func_177485_a(x, y, z).func_177230_c() != block) continue;
                tracker.world.func_175698_g((BlockPos)pos.func_181079_c(x + xOff, y + section.func_76662_d(), z + zOff));
                ++count;
            }
        }
        return count;
    }

    public static boolean containsBlock(ExtendedBlockStorage section, Block block) {
        try {
            IBlockStatePalette palette = (IBlockStatePalette)ReflectionHelper.getPrivateValue(BlockStateContainer.class, (Object)section.func_186049_g(), (String[])new String[]{"palette", "field_186022_c"});
            int m = Block.field_176229_d.func_186804_a();
            for (int i = 0; i < m; ++i) {
                IBlockState state = palette.func_186039_a(i);
                if (state == null) {
                    return false;
                }
                if (state.func_177230_c() != block) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    private static class FetchBlocks
    extends RecursiveAction {
        private static final long serialVersionUID = 7982665640808749376L;
        WorldTracker tracker;
        List<IWorldEntry> result = new ObjectArrayList();

        private FetchBlocks(WorldTracker tracker) {
            this.tracker = tracker;
        }

        @Override
        protected void compute() {
            ObjectArrayList tasks = new ObjectArrayList();
            for (Chunk chunk : this.tracker.getChunks()) {
                tasks.add(ForkJoinTask.adapt(() -> BlockEntry.countBlocks(chunk)));
            }
            FetchBlocks.invokeAll(tasks);
            BaseWorldEntry.Counter<Block> globalCounter = new BaseWorldEntry.Counter<Block>();
            for (ForkJoinTask entry : tasks) {
                globalCounter.merge((BaseWorldEntry.Counter)entry.getRawResult());
            }
            globalCounter.remove(T -> T.func_149688_o(T.func_176223_P()) == Material.field_151579_a);
            this.result = globalCounter.map(BlockEntry::new);
        }

        public static List<IWorldEntry> fetch(WorldTracker tracker) {
            FetchBlocks task = new FetchBlocks(tracker);
            ForkJoinPool.commonPool().invoke(task);
            task.quietlyJoin();
            return task.result;
        }
    }

    public static class DeletionTask
    implements IMiniTask {
        WorldTracker tracker;
        LongList chunks;
        EntityPlayer owner;
        Block block;
        int index = 0;
        long current;
        long max;

        public DeletionTask(WorldTracker tracker, LongList chunks, EntityPlayer owner, Block block, long max) {
            this.tracker = tracker;
            this.chunks = chunks;
            this.owner = owner;
            this.block = block;
            this.max = max;
        }

        @Override
        public void interrupt() {
            ChunkPregenerator.NETWORKING.sendToPlayer(new ProgressPacket.Complete(), this.owner);
        }

        @Override
        public boolean update(long startTime) {
            int flags;
            int n = flags = this.block instanceof BlockLiquid ? 2 : 3;
            while (System.currentTimeMillis() - startTime < 50L && this.index < this.chunks.size()) {
                long position = this.chunks.getLong(this.index);
                Chunk chunk = this.tracker.getChunk(position);
                if (chunk != null) {
                    int xOff = chunk.func_76632_l().field_77276_a << 4;
                    int zOff = chunk.func_76632_l().field_77275_b << 4;
                    ExtendedBlockStorage[] sections = chunk.func_76587_i();
                    for (int y = sections.length - 1; y >= 0; --y) {
                        ExtendedBlockStorage section = sections[y];
                        if (section == null || section.func_76663_a() || !BlockEntry.containsBlock(section, this.block)) continue;
                        for (int i = 0; i < 4096; ++i) {
                            BlockPos pos = new BlockPos(i % 16 + xOff, i / 16 % 16 + section.func_76662_d(), i / 256 + zOff);
                            if (chunk.func_177435_g(pos).func_177230_c() != this.block) continue;
                            this.tracker.world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), flags);
                            ++this.current;
                        }
                    }
                }
                ++this.index;
                ChunkPregenerator.NETWORKING.sendToPlayer(new ProgressPacket.Update(this.current, this.max), this.owner);
            }
            if (this.index >= this.chunks.size()) {
                ChunkPregenerator.NETWORKING.sendToPlayer(new ProgressPacket.Complete(), this.owner);
                return false;
            }
            return true;
        }

        @Override
        public boolean hasClientOverlay() {
            return false;
        }

        @Override
        public byte getClientDataId() {
            return 0;
        }

        @Override
        public void writeData(PacketBuffer buffer) {
        }
    }
}

