/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.tracking.types;

import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.tracking.WorldTracker;
import pregenerator.impl.tracking.types.BaseWorldEntry;
import pregenerator.impl.tracking.types.IWorldEntry;

public class EntityTypeEntry
extends BaseWorldEntry {
    public EntityTypeEntry(int id, int count) {
        super(id, count);
    }

    public EntityTypeEntry(PacketBuffer buf) {
        super(buf);
    }

    public EntityEntry getEntity() {
        return (EntityEntry)((ForgeRegistry)ForgeRegistries.ENTITIES).getValue(this.id);
    }

    @Override
    protected ResourceLocation getKey(int id) {
        return ((EntityEntry)((ForgeRegistry)ForgeRegistries.ENTITIES).getValue(id)).getRegistryName();
    }

    @Override
    public ITextComponent getName() {
        return TextUtil.translate("entity." + this.getEntity().getName() + ".name");
    }

    @Override
    public boolean canDelete(boolean chunk) {
        return true;
    }

    @Override
    public int deleteWorld(WorldTracker tracker, EntityPlayer player) {
        EntityEntry type = (EntityEntry)((ForgeRegistry)ForgeRegistries.ENTITIES).getValue(this.id);
        if (type == null) {
            return 0;
        }
        return tracker.world.func_175644_a(type.getEntityClass(), T -> {
            T.func_70106_y();
            return true;
        }).size();
    }

    @Override
    public int deleteChunk(WorldTracker tracker, long position) {
        EntityEntry type = (EntityEntry)((ForgeRegistry)ForgeRegistries.ENTITIES).getValue(this.id);
        if (type == null) {
            return 0;
        }
        WorldServer level = tracker.world;
        ChunkPos pos = new ChunkPos(FilePos.getX(position), FilePos.getZ(position));
        AxisAlignedBB box = new AxisAlignedBB(pos.func_180331_a(0, 0, 0), pos.func_180331_a(16, 256, 16));
        return level.func_175647_a(type.getEntityClass(), box, T -> {
            T.func_70106_y();
            return true;
        }).size();
    }

    public static List<IWorldEntry> getLevel(WorldServer level) {
        BaseWorldEntry.Counter<EntityEntry> counter = new BaseWorldEntry.Counter<EntityEntry>();
        level.field_72996_f.forEach(T -> {
            if (T instanceof EntityPlayer) {
                return;
            }
            counter.add(EntityRegistry.getEntry(T.getClass()));
        });
        return counter.map((T, C) -> new EntityTypeEntry(((ForgeRegistry)ForgeRegistries.ENTITIES).getID((IForgeRegistryEntry)T), C));
    }

    public static List<IWorldEntry> getChunk(Chunk chunk) {
        BaseWorldEntry.Counter<EntityEntry> counter = new BaseWorldEntry.Counter<EntityEntry>();
        AxisAlignedBB box = new AxisAlignedBB(chunk.func_76632_l().func_180331_a(0, 0, 0), chunk.func_76632_l().func_180331_a(16, 256, 16));
        chunk.func_177430_a(Entity.class, box, new EmptyList(), T -> {
            if (T instanceof EntityPlayer) {
                return false;
            }
            counter.add(EntityRegistry.getEntry(T.getClass()));
            return true;
        });
        return counter.map((T, C) -> new EntityTypeEntry(((ForgeRegistry)ForgeRegistries.ENTITIES).getID((IForgeRegistryEntry)T), C));
    }

    private static class EmptyList<T>
    extends AbstractList<T> {
        private EmptyList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void add(int index, T element) {
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            return false;
        }

        @Override
        public T get(int index) {
            return null;
        }
    }
}

