/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.block;

import WayofTime.bloodmagic.block.base.BlockEnum;
import WayofTime.bloodmagic.item.block.base.ItemBlockEnum;
import WayofTime.bloodmagic.tile.TileMimic;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemBlockMimic
extends ItemBlockEnum {
    public ItemBlockMimic(BlockEnum block) {
        super(block);
        this.func_77627_a(true);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_70093_af()) {
            return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
        }
        if (player.func_175151_a(pos, facing, stack)) {
            IBlockState replacedBlockstate = world.func_180495_p(pos);
            Block replacedBlock = replacedBlockstate.func_177230_c();
            ItemStack replacedStack = replacedBlock.func_185473_a(world, pos, replacedBlockstate);
            IBlockState mimicBlockstate = this.getBlock().func_176203_a(stack.func_77960_j());
            if (!this.canReplaceBlock(world, pos, replacedBlockstate)) {
                return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
            }
            TileEntity tileReplaced = world.func_175625_s(pos);
            if (!this.canReplaceTile(tileReplaced)) {
                return EnumActionResult.FAIL;
            }
            NBTTagCompound tileTag = this.getTagFromTileEntity(tileReplaced);
            if (tileReplaced != null) {
                NBTTagCompound voidTag = new NBTTagCompound();
                voidTag.func_74768_a("x", pos.func_177958_n());
                voidTag.func_74768_a("y", pos.func_177956_o());
                voidTag.func_74768_a("z", pos.func_177952_p());
                tileReplaced.func_145839_a(voidTag);
            }
            stack.func_190918_g(1);
            world.func_180501_a(pos, mimicBlockstate, 3);
            SoundType soundtype = this.field_150939_a.func_185467_w();
            world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileMimic) {
                TileMimic mimic = (TileMimic)tile;
                mimic.tileTag = tileTag;
                mimic.setReplacedState(replacedBlockstate);
                mimic.func_70299_a(0, replacedStack);
                mimic.refreshTileEntity();
                if (player.field_71075_bZ.field_75098_d) {
                    mimic.dropItemsOnBreak = false;
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public boolean canReplaceTile(TileEntity tile) {
        if (tile instanceof TileEntityChest) {
            return true;
        }
        return tile == null;
    }

    public boolean canReplaceBlock(World world, BlockPos pos, IBlockState state) {
        return state.func_185887_b(world, pos) != -1.0f;
    }

    public NBTTagCompound getTagFromTileEntity(TileEntity tile) {
        NBTTagCompound tag = new NBTTagCompound();
        if (tile != null) {
            return tile.func_189515_b(tag);
        }
        return tag;
    }

    @Override
    public int func_77647_b(int meta) {
        return meta;
    }
}

