/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.dupefixproject.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.relauncher.CoreModManager;

public class ModHandler {
    private static final HashMap<String, File> cachedMods = new HashMap();

    private static void scan(File folder) {
        File[] mods;
        if (folder.exists() && folder.isDirectory() && folder.listFiles() != null && (mods = folder.listFiles(f -> f.getName().endsWith(".jar") || f.isDirectory())) != null) {
            for (File mod : mods) {
                if (mod.isDirectory() && mod.getName().equals("1.12.2")) {
                    ModHandler.scan(mod);
                }
                try {
                    String modid = ModHandler.getModID(mod);
                    if (modid == null) continue;
                    cachedMods.put(modid, mod);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private static String getModID(File file) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> zipEntryEnumeration = zipFile.entries();
        while (zipEntryEnumeration.hasMoreElements()) {
            String read;
            ZipEntry zipEntry = zipEntryEnumeration.nextElement();
            if (zipEntry == null || !zipEntry.getName().equalsIgnoreCase("mcmod.info")) continue;
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((read = bufferedReader.readLine()) != null) {
                if (!read.contains("\"modid\"")) continue;
                return read.replace("\"", "").replace("modid", "").replace(":", "").replace(",", "").replace("\t", "").replace("\n", "").replace(" ", "").replace("{", "").replace("}", "");
            }
        }
        return null;
    }

    public static boolean isPresent(String modid) {
        return cachedMods.containsKey(modid);
    }

    public static boolean load(String modid) {
        if (!ModHandler.isPresent(modid)) {
            return false;
        }
        try {
            ModHandler.loadJar(cachedMods.get(modid));
        }
        catch (MalformedURLException ignored) {
            return false;
        }
        return true;
    }

    private static void loadJar(File jar) throws MalformedURLException {
        ((LaunchClassLoader)ModHandler.class.getClassLoader()).addURL(jar.toURI().toURL());
        CoreModManager.getReparseableCoremods().add(jar.getName());
    }

    public static void clear() {
        cachedMods.clear();
    }

    static {
        File folder = new File("mods");
        ModHandler.scan(folder);
    }
}

