/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.tileentity;

import com.google.common.collect.Sets;
import gcewing.sg.BaseBlockUtils;
import gcewing.sg.BaseConfiguration;
import gcewing.sg.BaseMod;
import gcewing.sg.BaseTileInventory;
import gcewing.sg.BaseUtils;
import gcewing.sg.SGCraft;
import gcewing.sg.Trans3;
import gcewing.sg.Vector3;
import gcewing.sg.block.SGBaseBlock;
import gcewing.sg.entity.EntityStargateIris;
import gcewing.sg.features.ic2.IC2PowerTE;
import gcewing.sg.features.ic2.zpm.ZpmInterfaceCartTE;
import gcewing.sg.features.oc.OCInterfaceTE;
import gcewing.sg.features.oc.OCWirelessEndpoint;
import gcewing.sg.features.zpm.ZpmAddon;
import gcewing.sg.features.zpm.ZpmConsoleTE;
import gcewing.sg.generator.GeneratorAddressRegistry;
import gcewing.sg.interfaces.IComputerInterface;
import gcewing.sg.interfaces.ISGEnergySource;
import gcewing.sg.interfaces.LoopingSoundSource;
import gcewing.sg.tileentity.DHDTE;
import gcewing.sg.tileentity.SGInterfaceTE;
import gcewing.sg.tileentity.SGPowerTE;
import gcewing.sg.tileentity.SGRingTE;
import gcewing.sg.tileentity.data.GateAccessData;
import gcewing.sg.tileentity.data.PlayerAccessData;
import gcewing.sg.util.FakeTeleporter;
import gcewing.sg.util.GeneralAddressRegistry;
import gcewing.sg.util.IrisState;
import gcewing.sg.util.SGAddressing;
import gcewing.sg.util.SGLocation;
import gcewing.sg.util.SGState;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ITeleporter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SGBaseTE
extends BaseTileInventory
implements ITickable,
LoopingSoundSource {
    static boolean debugState = false;
    public static boolean debugEnergyUse = false;
    static boolean debugConnect = false;
    static boolean debugTransientDamage = false;
    static boolean debugTeleport = false;
    static boolean debugZPM = false;
    static final DecimalFormat dFormat = new DecimalFormat("###,###,###,##0");
    public static SoundEvent m_dialFailSound;
    public static SoundEvent p_dialFailSound;
    public static SoundEvent m_connectSound;
    public static SoundEvent p_connectSound;
    public static SoundEvent disconnectSound;
    public static SoundEvent irisOpenSound;
    public static SoundEvent irisCloseSound;
    public static SoundEvent irisHitSound;
    public static SoundEvent m_dhdPressSound;
    public static SoundEvent p_dhdPressSound;
    public static SoundEvent m_dhdDialSound;
    public static SoundEvent p_dhdDialSound;
    public static SoundEvent m_chevronOutgoingSound;
    public static SoundEvent m_chevronIncomingSound;
    public static SoundEvent p_chevronOutgoingSound;
    public static SoundEvent p_chevronIncomingSound;
    public static SoundEvent lockOutgoingSound;
    public static SoundEvent lockIncomingSound;
    public static SoundEvent m_gateRollSound;
    public static SoundEvent p_gateRollSound;
    public static SoundEvent eventHorizonSound;
    public static SoundEvent teleportSound;
    public static SoundEvent malfunctionSound;
    public static final String symbolChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    public static final int numRingSymbols;
    public static final double ringSymbolAngle;
    public static final double irisZPosition = 0.1;
    public static final double irisThickness = 0.2;
    public static final DamageSource irisDamageSource;
    public static final float irisDamageAmount = 1000000.0f;
    public static int minutesOpenPerFuelItem;
    static final int interDiallingTime = 10;
    public int syncAwaitTime = 30;
    static final int transientDuration = 20;
    static final int disconnectTime = 40;
    static final double openingTransientIntensity = 1.3;
    static final double openingTransientRandomness = 0.25;
    static final double closingTransientRandomness = 0.25;
    static final double transientDamageRate = 50.0;
    static final int maxIrisPhase = 70;
    public static int firstCamouflageSlot;
    public static int numCamouflageSlots;
    public static int numInventorySlots;
    static float defaultChevronAngle;
    static float[][] chevronAngles;
    static int chunkLoadingRange;
    static boolean logStargateEvents;
    public static float soundVolume;
    static boolean variableChevronPositions;
    public static double energyToOpen;
    static double energyUsePerTick;
    static Random random;
    static DamageSource transientDamageSource;
    public static BaseConfiguration cfg;
    public boolean isMerged;
    public SGState state = SGState.Idle;
    public double startRingAngle;
    public double ringAngle;
    public double lastRingAngle;
    public double targetRingAngle;
    public int numEngagedChevrons;
    public String dialledAddress = "";
    public boolean isLinkedToController;
    public BlockPos linkedPos = new BlockPos(0, 0, 0);
    public boolean hasChevronUpgrade;
    public boolean hasIrisUpgrade;
    public IrisState irisState = IrisState.Open;
    public int irisPhase = 70;
    public int lastIrisPhase = 70;
    public OCWirelessEndpoint ocWirelessEndpoint;
    public boolean debugCCInterface = false;
    public int dialedDigit = 0;
    public String enteredAddress = "";
    public String immediateDialAddress = "";
    public boolean errorState = false;
    public boolean checkForMalfunction = false;
    private boolean performBlockDamage = true;
    public SGLocation connectedLocation;
    public boolean isInitiator;
    public boolean redstoneInput;
    public boolean loaded;
    int timeout;
    int maxTimeout;
    public double energyInBuffer;
    public double distanceFactor;
    public String homeAddress;
    public String addressError;
    private int updated = 0;
    IInventory inventory = new InventoryBasic("Stargate", false, numInventorySlots);
    public boolean zpmPowered = false;
    public boolean destinationRequiresZPM = false;
    public boolean wasIrisClosed = false;
    public int gateType = 1;
    public int gateOrientation = 1;
    public int secondsToStayOpen = 300;
    public int ticksToStayOpen = 20 * this.secondsToStayOpen;
    public boolean oneWayTravel = true;
    public double ringRotationSpeed = 2.0;
    public double maxEnergyBuffer = 1000.0;
    public double energyPerFuelItem = 96000.0;
    public double distanceFactorMultiplier = 1.0;
    public double interDimensionMultiplier = 4.0;
    public int gateOpeningsPerFuelItem = 24;
    public boolean reverseWormholeKills = false;
    public boolean closeFromEitherEnd = true;
    public boolean preserveInventory = false;
    public boolean allowIncomingConnections = true;
    public boolean allowOutgoingConnections = true;
    public boolean chevronsLockOnDial = false;
    public boolean returnToPreviousIrisState = false;
    public int facingDirectionOfBase = 0;
    public boolean requiresNoPower = false;
    public boolean transientDamage = true;
    public boolean transparency = true;
    public boolean defaultAllowIncoming = true;
    public boolean defaultAllowOutgoing = true;
    public boolean defaultAllowGateAccess = true;
    public boolean defaultAllowIrisAccess = true;
    public boolean defaultAllowAdminAccess = true;
    public boolean useDHDFuelSource = true;
    public boolean allowRedstoneOutput = true;
    public boolean allowRedstoneInput = true;
    private List<PlayerAccessData> playerAccessData;
    private List<GateAccessData> gateAccessData;
    double[][][] ehGrid;
    private static Set<UUID> messagesQueue;
    List<TrackedEntity> trackedEntities = new ArrayList<TrackedEntity>();
    static int[] rdx;
    static int[] rdz;

    public static void registerSounds(SGCraft mod) {
        m_dialFailSound = mod.newSound("m_dial_fail");
        p_dialFailSound = mod.newSound("p_dial_fail");
        m_connectSound = mod.newSound("m_gate_open");
        p_connectSound = mod.newSound("p_gate_open");
        disconnectSound = mod.newSound("gate_close");
        irisOpenSound = mod.newSound("iris_open");
        irisCloseSound = mod.newSound("iris_close");
        irisHitSound = mod.newSound("iris_hit");
        m_dhdPressSound = mod.newSound("m_dhd_press");
        p_dhdPressSound = mod.newSound("p_dhd_press");
        m_dhdDialSound = mod.newSound("m_dhd_dial");
        p_dhdDialSound = mod.newSound("p_dhd_dial");
        m_chevronOutgoingSound = mod.newSound("m_chevron_outgoing");
        m_chevronIncomingSound = mod.newSound("m_chevron_incoming");
        p_chevronOutgoingSound = mod.newSound("p_chevron_outgoing");
        p_chevronIncomingSound = mod.newSound("p_chevron_incoming");
        lockOutgoingSound = mod.newSound("lock_outgoing");
        lockIncomingSound = mod.newSound("lock_incoming");
        m_gateRollSound = mod.newSound("m_gate_roll");
        p_gateRollSound = mod.newSound("p_gate_roll");
        eventHorizonSound = mod.newSound("event_horizon");
        teleportSound = mod.newSound("teleport");
        malfunctionSound = mod.newSound("malfunction");
    }

    public SGBaseTE() {
        this.hasIrisUpgrade = cfg.getBoolean("stargate", "irisUpgrade", this.hasIrisUpgrade);
        this.hasChevronUpgrade = cfg.getBoolean("stargate", "chevronUpgrade", this.hasChevronUpgrade);
        this.gateType = cfg.getInteger("stargate", "gateType", this.gateType);
        this.secondsToStayOpen = cfg.getInteger("stargate", "secondsToStayOpen", this.secondsToStayOpen);
        this.oneWayTravel = cfg.getBoolean("stargate", "oneWayTravel", this.oneWayTravel);
        this.ringRotationSpeed = cfg.getDouble("stargate", "ringRotationSpeed", this.ringRotationSpeed);
        this.maxEnergyBuffer = cfg.getDouble("stargate", "maxEnergyBuffer", this.maxEnergyBuffer);
        this.energyPerFuelItem = cfg.getDouble("stargate", "energyPerFuelItem", this.energyPerFuelItem);
        this.gateOpeningsPerFuelItem = cfg.getInteger("stargate", "gateOpeningsPerFuelItem", this.gateOpeningsPerFuelItem);
        this.distanceFactorMultiplier = cfg.getDouble("stargate", "distanceFactorMultiplier", this.distanceFactorMultiplier);
        this.interDimensionMultiplier = cfg.getDouble("stargate", "interDimensionMultiplier", this.interDimensionMultiplier);
        this.reverseWormholeKills = cfg.getBoolean("stargate", "reverseWormholeKills", this.reverseWormholeKills);
        this.closeFromEitherEnd = cfg.getBoolean("stargate", "closeFromEitherEnd", this.closeFromEitherEnd);
        this.preserveInventory = cfg.getBoolean("iris", "preserveInventory", this.preserveInventory);
        this.chevronsLockOnDial = cfg.getBoolean("stargate", "chevronsLockOnDial", this.chevronsLockOnDial);
        this.returnToPreviousIrisState = cfg.getBoolean("stargate", "returnToPreviousIrisState", this.returnToPreviousIrisState);
        this.requiresNoPower = cfg.getBoolean("stargate", "requiresNoPower", this.requiresNoPower);
        this.transparency = cfg.getBoolean("stargate", "transparency", this.transparency);
        this.defaultAllowIncoming = cfg.getBoolean("gate-access", "defaultAllowIncoming", this.defaultAllowIncoming);
        this.defaultAllowOutgoing = cfg.getBoolean("gate-access", "defaultAllowOutgoing", this.defaultAllowOutgoing);
        this.defaultAllowGateAccess = cfg.getBoolean("player-access", "defaultAllowGateAccess", this.defaultAllowGateAccess);
        this.defaultAllowIrisAccess = cfg.getBoolean("player-access", "defaultAllowIrisAccess", this.defaultAllowIrisAccess);
        this.defaultAllowAdminAccess = cfg.getBoolean("player-access", "defaultAllowAdminAccess", this.defaultAllowAdminAccess);
        this.useDHDFuelSource = cfg.getBoolean("dhd", "useDHDFuelSource", this.useDHDFuelSource);
        this.allowRedstoneOutput = cfg.getBoolean("stargate", "allowRedstoneOutput", this.allowRedstoneOutput);
        this.allowRedstoneInput = cfg.getBoolean("iris", "allowRedstoneInput", this.allowRedstoneInput);
    }

    public static void configure(BaseConfiguration cfg) {
        SGBaseTE.cfg = cfg;
        cfg.getDouble("stargate", "energyPerFuelItem", 96000.0);
        cfg.getInteger("stargate", "gateOpeningsPerFuelItem", 24);
        cfg.getInteger("stargate", "secondsToStayOpen", 300);
        cfg.getBoolean("stargate", "oneWayTravel", true);
        cfg.getBoolean("stargate", "reverseWormholeKills", false);
        cfg.getBoolean("stargate", "closeFromEitherEnd", true);
        cfg.getDouble("stargate", "maxEnergyBuffer", 1000.0);
        cfg.getDouble("stargate", "distanceFactorMultiplier", 1.0);
        cfg.getDouble("stargate", "interDimensionMultiplier", 4.0);
        cfg.getBoolean("iris", "preserveInventory", false);
        cfg.getInteger("stargate", "gateType", 1);
        cfg.getBoolean("stargate", "chevronsLockOnDial", false);
        cfg.getBoolean("stargate", "returnToPreviousIrisState", false);
        cfg.getDouble("stargate", "ringRotationSpeed", 2.0);
        cfg.getBoolean("stargate", "irisUpgrade", false);
        cfg.getBoolean("stargate", "chevronUpgrade", false);
        cfg.getBoolean("stargate", "requiresNoPower", false);
        cfg.getBoolean("stargate", "transientDamage", true);
        cfg.getBoolean("stargate", "transparency", true);
        cfg.getBoolean("gate-access", "defaultAllowIncoming", true);
        cfg.getBoolean("gate-access", "defaultAllowOutgoing", true);
        cfg.getBoolean("player-access", "defaultAllowGateAccess", true);
        cfg.getBoolean("player-access", "defaultAllowIrisAccess", true);
        cfg.getBoolean("player-access", "defaultAllowAdminAccess", true);
        cfg.getBoolean("dhd", "useDHDFuelSource", true);
        cfg.getBoolean("stargate", "allowRedstoneOutput", true);
        cfg.getBoolean("iris", "allowRedstoneInput", true);
        minutesOpenPerFuelItem = cfg.getInteger("stargate", "minutesOpenPerFuelItem", minutesOpenPerFuelItem);
        chunkLoadingRange = cfg.getInteger("options", "chunkLoadingRange", chunkLoadingRange);
        logStargateEvents = cfg.getBoolean("options", "logStargateEvents", logStargateEvents);
        soundVolume = (float)cfg.getDouble("stargate", "soundVolume", soundVolume);
        variableChevronPositions = cfg.getBoolean("stargate", "variableChevronPositions", variableChevronPositions);
    }

    public static SGBaseTE get(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof SGBaseTE) {
            return (SGBaseTE)te;
        }
        if (te instanceof SGRingTE) {
            return ((SGRingTE)te).getBaseTE();
        }
        return null;
    }

    public String toString() {
        return String.format("SGBaseTE(%s,%s)", this.field_174879_c, this.field_145850_b.field_73011_w.getDimension());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        return new AxisAlignedBB((double)(x - 2), (double)y, (double)(z - 2), (double)(x + 3), (double)(y + 5), (double)(z + 3));
    }

    public double func_145833_n() {
        return 32768.0;
    }

    @Override
    public void onAddedToWorld() {
        if (SGBaseBlock.debugMerge) {
            System.out.print("SGBaseTE.onAddedToWorld\n");
        }
        this.updateChunkLoadingStatus();
    }

    void updateChunkLoadingStatus() {
        if (this.state != SGState.Idle || this.state == SGState.attemptToDial) {
            int n = chunkLoadingRange;
            if (n >= 0) {
                SGCraft.chunkManager.setForcedChunkRange(this, -n, -n, n, n);
            }
        } else {
            SGCraft.chunkManager.clearForcedChunkRange(this);
        }
    }

    public static SGBaseTE at(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof SGBaseTE ? (SGBaseTE)te : null;
    }

    public static SGBaseTE at(SGLocation loc) {
        WorldServer world;
        if (loc != null && (world = SGAddressing.getWorld(loc.dimension)) != null) {
            return SGBaseTE.at((IBlockAccess)world, loc.pos);
        }
        return null;
    }

    public static SGBaseTE at(IBlockAccess world, NBTTagCompound nbt) {
        BlockPos pos = new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
        return SGBaseTE.at(world, pos);
    }

    protected void func_190201_b(World world) {
        this.field_145850_b = world;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isMerged = nbt.func_74767_n("isMerged");
        SGState oldState = this.state = SGState.values()[nbt.func_74762_e("state")];
        this.ringAngle = nbt.func_74769_h("ringAngle");
        this.startRingAngle = nbt.func_74769_h("startRingAngle");
        this.targetRingAngle = nbt.func_74769_h("targetRingAngle");
        this.numEngagedChevrons = nbt.func_74762_e("numEngagedChevrons");
        this.dialledAddress = nbt.func_74779_i("dialledAddress");
        this.isLinkedToController = nbt.func_74767_n("isLinkedToController");
        int x = nbt.func_74762_e("linkedX");
        int y = nbt.func_74762_e("linkedY");
        int z = nbt.func_74762_e("linkedZ");
        this.linkedPos = new BlockPos(x, y, z);
        if (nbt.func_74764_b("connectedLocation")) {
            this.connectedLocation = new SGLocation(nbt.func_74775_l("connectedLocation"));
        }
        this.isInitiator = nbt.func_74767_n("isInitiator");
        this.timeout = nbt.func_74762_e("timeout");
        this.maxTimeout = nbt.func_74762_e("maxTimeout");
        this.energyInBuffer = nbt.func_74764_b("energyInBuffer") ? nbt.func_74769_h("energyInBuffer") : (double)nbt.func_74762_e("fuelBuffer");
        this.distanceFactor = nbt.func_74769_h("distanceFactor");
        this.irisState = IrisState.values()[nbt.func_74762_e("irisState")];
        this.irisPhase = nbt.func_74762_e("irisPhase");
        this.redstoneInput = nbt.func_74767_n("redstoneInput");
        this.homeAddress = this.getStringOrNull(nbt, "address");
        this.addressError = nbt.func_74779_i("addressError");
        if (oldState != this.state && this.state == SGState.Connected && this.field_145850_b.field_72995_K) {
            SGCraft.playSound(this, eventHorizonSound);
        }
        this.hasIrisUpgrade = nbt.func_74764_b("hasIrisUpgrade") && !SGCraft.forceSGBaseTEUpdate ? nbt.func_74767_n("hasIrisUpgrade") : cfg.getBoolean("stargate", "irisUpgrade", this.hasIrisUpgrade);
        this.hasChevronUpgrade = nbt.func_74764_b("hasChevronUpgrade") && !SGCraft.forceSGBaseTEUpdate ? nbt.func_74767_n("hasChevronUpgrade") : cfg.getBoolean("stargate", "chevronUpgrade", this.hasChevronUpgrade);
        this.gateType = nbt.func_74764_b("gateType") && !SGCraft.forceSGBaseTEUpdate ? nbt.func_74762_e("gateType") : cfg.getInteger("stargate", "gateType", this.gateType);
        this.secondsToStayOpen = nbt.func_74764_b("secondsToStayOpen") && !SGCraft.forceSGBaseTEUpdate ? nbt.func_74762_e("secondsToStayOpen") : cfg.getInteger("stargate", "secondsToStayOpen", this.secondsToStayOpen);
        this.oneWayTravel = nbt.func_74764_b("oneWayTravel") && !SGCraft.forceSGBaseTEUpdate ? nbt.func_74767_n("oneWayTravel") : cfg.getBoolean("stargate", "oneWayTravel", this.oneWayTravel);
        this.ringRotationSpeed = nbt.func_74764_b("ringRotationSpeed") && !SGCraft.forceSGBaseTEUpdate ? nbt.func_74769_h("ringRotationSpeed") : cfg.getDouble("stargate", "ringRotationSpeed", this.ringRotationSpeed);
        this.maxEnergyBuffer = nbt.func_74764_b("maxEnergyBuffer") && !SGCraft.forceSGBaseTEUpdate ? nbt.func_74769_h("maxEnergyBuffer") : cfg.getDouble("stargate", "maxEnergyBuffer", this.maxEnergyBuffer);
        this.energyPerFuelItem = nbt.func_74764_b("energyPerFuelItem") && !SGCraft.forceSGBaseTEUpdate ? nbt.func_74769_h("energyPerFuelItem") : cfg.getDouble("stargate", "energyPerFuelItem", this.energyPerFuelItem);
        this.gateOpeningsPerFuelItem = nbt.func_74764_b("gateOpeningsPerFuelItem") && !SGCraft.forceSGBaseTEUpdate ? nbt.func_74762_e("gateOpeningsPerFuelItem") : cfg.getInteger("stargate", "gateOpeningsPerFuelItem", this.gateOpeningsPerFuelItem);
        this.distanceFactorMultiplier = nbt.func_74764_b("distanceFactorMultiplier") && !SGCraft.forceSGBaseTEUpdate ? nbt.func_74769_h("distanceFactorMultiplier") : cfg.getDouble("stargate", "distanceFactorMultiplier", this.distanceFactorMultiplier);
        this.interDimensionMultiplier = nbt.func_74764_b("interDimensionalMultiplier") && !SGCraft.forceSGBaseTEUpdate ? nbt.func_74769_h("interDimensionalMultiplier") : cfg.getDouble("stargate", "interDimensionMultiplier", this.interDimensionMultiplier);
        this.reverseWormholeKills = nbt.func_74764_b("reverseWormholeKills") && !SGCraft.forceSGBaseTEUpdate ? nbt.func_74767_n("reverseWormholeKills") : cfg.getBoolean("stargate", "reverseWormholeKills", this.reverseWormholeKills);
        this.closeFromEitherEnd = nbt.func_74764_b("closeFromEitherEnd") && !SGCraft.forceSGBaseTEUpdate ? nbt.func_74767_n("closeFromEitherEnd") : cfg.getBoolean("stargate", "closeFromEitherEnd", this.closeFromEitherEnd);
        this.preserveInventory = nbt.func_74764_b("preserveInventory") && !SGCraft.forceSGBaseTEUpdate ? nbt.func_74767_n("preserveInventory") : cfg.getBoolean("iris", "preserveInventory", this.preserveInventory);
        this.allowIncomingConnections = nbt.func_74764_b("allowIncomingConnections") && !SGCraft.forceSGBaseTEUpdate ? nbt.func_74767_n("allowIncomingConnections") : true;
        this.allowOutgoingConnections = nbt.func_74764_b("allowOutgoingConnections") && !SGCraft.forceSGBaseTEUpdate ? nbt.func_74767_n("allowOutgoingConnections") : true;
        this.chevronsLockOnDial = nbt.func_74764_b("chevronsLockOnDial") && !SGCraft.forceSGBaseTEUpdate ? nbt.func_74767_n("chevronsLockOnDial") : cfg.getBoolean("stargate", "chevronsLockOnDial", this.chevronsLockOnDial);
        this.returnToPreviousIrisState = nbt.func_74764_b("returnToPreviousIrisState") && !SGCraft.forceSGBaseTEUpdate ? nbt.func_74767_n("returnToPreviousIrisState") : cfg.getBoolean("stargate", "returnToPreviousIrisState", this.returnToPreviousIrisState);
        this.gateOrientation = nbt.func_74764_b("gateOrientation") ? nbt.func_74762_e("gateOrientation") : 1;
        this.requiresNoPower = nbt.func_74764_b("requiresNoPower") && !SGCraft.forceSGBaseTEUpdate ? nbt.func_74767_n("requiresNoPower") : cfg.getBoolean("stargate", "requiresNoPower", this.requiresNoPower);
        this.transientDamage = nbt.func_74764_b("transientDamage") && !SGCraft.forceSGBaseTEUpdate ? nbt.func_74767_n("transientDamage") : cfg.getBoolean("stargate", "transientDamage", this.requiresNoPower);
        this.transparency = nbt.func_74764_b("transparency") && !SGCraft.forceSGBaseTEUpdate ? nbt.func_74767_n("transparency") : cfg.getBoolean("stargate", "transparency", this.transparency);
        this.useDHDFuelSource = nbt.func_74764_b("useDHDFuelSource") && !SGCraft.forceDHDCfgUpdate ? nbt.func_74767_n("useDHDFuelSource") : cfg.getBoolean("dhd", "useDHDFuelSource", this.useDHDFuelSource);
        this.facingDirectionOfBase = nbt.func_74762_e("facingDirectionOfBase");
        this.errorState = nbt.func_74767_n("errorState");
        this.ticksToStayOpen = 20 * this.secondsToStayOpen;
        energyToOpen = this.energyPerFuelItem / (double)this.gateOpeningsPerFuelItem;
        energyUsePerTick = this.energyPerFuelItem / (double)(minutesOpenPerFuelItem * 60 * 20);
        if (SGCraft.pdd != null) {
            this.playerAccessData = PlayerAccessData.getPlayerAccessList(nbt);
            this.gateAccessData = GateAccessData.getGateAccessList(nbt);
        }
        this.defaultAllowIncoming = nbt.func_74764_b("defaultAllowIncoming") && !SGCraft.forceGateAccessSystemReset ? nbt.func_74767_n("defaultAllowIncoming") : cfg.getBoolean("gate-access", "defaultAllowIncoming", this.defaultAllowIncoming);
        this.defaultAllowOutgoing = nbt.func_74764_b("defaultAllowOutgoing") && !SGCraft.forceGateAccessSystemReset ? nbt.func_74767_n("defaultAllowOutgoing") : cfg.getBoolean("gate-access", "defaultAllowOutgoing", this.defaultAllowOutgoing);
        this.defaultAllowGateAccess = nbt.func_74764_b("defaultAllowGateAccess") && !SGCraft.forcePlayerAccessSystemReset ? nbt.func_74767_n("defaultAllowGateAccess") : cfg.getBoolean("player-access", "defaultAllowGateAccess", this.defaultAllowGateAccess);
        this.defaultAllowIrisAccess = nbt.func_74764_b("defaultAllowIrisAccess") && !SGCraft.forcePlayerAccessSystemReset ? nbt.func_74767_n("defaultAllowIrisAccess") : cfg.getBoolean("player-access", "defaultAllowIrisAccess", this.defaultAllowIrisAccess);
        this.defaultAllowAdminAccess = nbt.func_74764_b("defaultAllowAdminAccess") && !SGCraft.forcePlayerAccessSystemReset ? nbt.func_74767_n("defaultAllowAdminAccess") : cfg.getBoolean("player-access", "defaultAllowAdminAccess", this.defaultAllowAdminAccess);
        this.allowRedstoneOutput = nbt.func_74764_b("allowRedstoneOutput") && !SGCraft.forceSGBaseTEUpdate ? nbt.func_74767_n("allowRedstoneOutput") : cfg.getBoolean("stargate", "allowRedstoneOutput", this.allowRedstoneOutput);
        this.allowRedstoneInput = nbt.func_74764_b("allowRedstoneInput") && !SGCraft.forceSGBaseTEUpdate ? nbt.func_74767_n("allowRedstoneInput") : cfg.getBoolean("iris", "allowRedstoneInput", this.allowRedstoneInput);
    }

    protected String getStringOrNull(NBTTagCompound nbt, String name) {
        return nbt.func_74764_b(name) ? nbt.func_74779_i(name) : null;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("isMerged", this.isMerged);
        nbt.func_74768_a("state", this.state.ordinal());
        nbt.func_74780_a("ringAngle", this.ringAngle);
        nbt.func_74780_a("startRingAngle", this.startRingAngle);
        nbt.func_74780_a("targetRingAngle", this.targetRingAngle);
        nbt.func_74768_a("numEngagedChevrons", this.numEngagedChevrons);
        nbt.func_74778_a("dialledAddress", this.dialledAddress);
        nbt.func_74757_a("isLinkedToController", this.isLinkedToController);
        nbt.func_74768_a("linkedX", this.linkedPos.func_177958_n());
        nbt.func_74768_a("linkedY", this.linkedPos.func_177956_o());
        nbt.func_74768_a("linkedZ", this.linkedPos.func_177952_p());
        nbt.func_74757_a("isInitiator", this.isInitiator);
        nbt.func_74768_a("timeout", this.timeout);
        nbt.func_74768_a("maxTimeout", this.maxTimeout);
        nbt.func_74780_a("energyInBuffer", this.energyInBuffer);
        nbt.func_74780_a("distanceFactor", this.distanceFactor);
        nbt.func_74768_a("irisState", this.irisState.ordinal());
        nbt.func_74768_a("irisPhase", this.irisPhase);
        nbt.func_74757_a("redstoneInput", this.redstoneInput);
        nbt.func_74757_a("hasIrisUpgrade", this.hasIrisUpgrade);
        nbt.func_74757_a("hasChevronUpgrade", this.hasChevronUpgrade);
        nbt.func_74768_a("gateType", this.gateType);
        nbt.func_74768_a("secondsToStayOpen", this.secondsToStayOpen);
        nbt.func_74757_a("oneWayTravel", this.oneWayTravel);
        nbt.func_74780_a("ringRotationSpeed", this.ringRotationSpeed);
        nbt.func_74780_a("maxEnergyBuffer", this.maxEnergyBuffer);
        nbt.func_74780_a("energyPerFuelItem", this.energyPerFuelItem);
        nbt.func_74768_a("gateOpeningsPerFuelItem", this.gateOpeningsPerFuelItem);
        nbt.func_74780_a("distanceFactorMultiplier", this.distanceFactorMultiplier);
        nbt.func_74780_a("interDimensionMultiplier", this.interDimensionMultiplier);
        nbt.func_74757_a("reverseWormholeKills", this.reverseWormholeKills);
        nbt.func_74757_a("closeFromEitherEnd", this.closeFromEitherEnd);
        nbt.func_74757_a("preserveInventory", this.preserveInventory);
        nbt.func_74757_a("allowIncomingConnections", this.allowIncomingConnections);
        nbt.func_74757_a("allowOutgoingConnections", this.allowOutgoingConnections);
        nbt.func_74757_a("chevronsLockOnDial", this.chevronsLockOnDial);
        nbt.func_74757_a("returnToPreviousIrisState", this.returnToPreviousIrisState);
        nbt.func_74768_a("gateOrientation", this.gateOrientation);
        nbt.func_74768_a("facingDirectionOfBase", this.facingDirectionOfBase);
        nbt.func_74757_a("requiresNoPower", this.requiresNoPower);
        nbt.func_74757_a("transientDamage", this.transientDamage);
        nbt.func_74757_a("transparency", this.transparency);
        nbt.func_74757_a("errorState", this.errorState);
        nbt.func_74757_a("useDHDFuelSource", this.useDHDFuelSource);
        if (this.connectedLocation != null) {
            nbt.func_74782_a("connectedLocation", (NBTBase)this.connectedLocation.toNBT());
        }
        if (this.homeAddress != null) {
            nbt.func_74778_a("address", this.homeAddress);
        }
        if (this.addressError != null) {
            nbt.func_74778_a("addressError", this.addressError);
        }
        if (SGCraft.pdd != null) {
            if (this.playerAccessData == null) {
                this.playerAccessData = PlayerAccessData.getPlayerAccessList(nbt);
            }
            if (this.gateAccessData == null) {
                this.gateAccessData = GateAccessData.getGateAccessList(nbt);
            }
            if (this.playerAccessData != null) {
                PlayerAccessData.writeAddresses(nbt, this.playerAccessData);
            }
            if (this.gateAccessData != null) {
                GateAccessData.writeAddresses(nbt, this.gateAccessData);
            }
        }
        nbt.func_74757_a("defaultAllowIncoming", this.defaultAllowIncoming);
        nbt.func_74757_a("defaultAllowOutgoing", this.defaultAllowOutgoing);
        nbt.func_74757_a("defaultAllowGateAccess", this.defaultAllowGateAccess);
        nbt.func_74757_a("defaultAllowIrisAccess", this.defaultAllowIrisAccess);
        nbt.func_74757_a("defaultAllowAdminAccess", this.defaultAllowAdminAccess);
        nbt.func_74757_a("allowRedstoneOutput", this.allowRedstoneOutput);
        nbt.func_74757_a("allowRedstoneInput", this.allowRedstoneInput);
        return nbt;
    }

    private String tryToGetHomeAddress() {
        try {
            return this.getHomeAddress();
        }
        catch (SGAddressing.AddressingError e) {
            return null;
        }
    }

    public boolean isActive() {
        return this.state != SGState.Idle && this.state != SGState.Disconnecting;
    }

    public static char symbolToChar(int i) {
        return SGAddressing.symbolToChar(i);
    }

    public static int charToSymbol(char c) {
        return SGAddressing.charToSymbol(c);
    }

    public int getNumChevrons() {
        return this.hasChevronUpgrade ? 9 : 7;
    }

    public boolean chevronIsEngaged(int i) {
        return i < this.numEngagedChevrons;
    }

    public float angleBetweenChevrons() {
        if (variableChevronPositions) {
            int c9 = this.getNumChevrons() > 7 ? 1 : 0;
            int bc = this.baseCornerCamouflage();
            return chevronAngles[c9][bc];
        }
        return defaultChevronAngle;
    }

    public String getHomeAddress() throws SGAddressing.AddressingError {
        return SGAddressing.addressForLocation(new SGLocation(this));
    }

    public SGBaseBlock getBlock() {
        return (SGBaseBlock)this.func_145838_q();
    }

    public double interpolatedRingAngle(double partialTicks) {
        return this.isInitiator ? this.lastRingAngle + (this.ringAngle - this.lastRingAngle) * partialTicks : 0.0;
    }

    public void setMerged(boolean state) {
        if (this.isMerged != state) {
            this.isMerged = state;
            this.markBlockChanged();
            String address = this.tryToGetHomeAddress();
            if (address != null) {
                Logger log = LogManager.getLogger();
                String action = this.isMerged ? "ADDED" : "REMOVED";
                String name = this.func_145831_w().func_72912_H().func_76065_j();
                if (this.isMerged) {
                    this.homeAddress = address;
                }
                if (logStargateEvents) {
                    log.info(String.format("STARGATE %s %s %s %s", action, name, this.field_174879_c, address));
                }
                if (state) {
                    GeneralAddressRegistry.addAddress(this.field_145850_b, this.homeAddress);
                } else {
                    GeneratorAddressRegistry.removeAddress(this.field_145850_b, this.homeAddress);
                    GeneralAddressRegistry.removeAddress(this.field_145850_b, this.homeAddress);
                }
            }
            this.updateIrisEntity();
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.clientUpdate();
        } else {
            this.serverUpdate();
            this.checkForEntitiesInPortal();
        }
        this.irisUpdate();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && this.ocWirelessEndpoint != null) {
            this.ocWirelessEndpoint.remove();
        }
    }

    public void onNeighborBlockChange() {
        boolean newInput;
        if (!this.field_145850_b.field_72995_K && this.redstoneInput != (newInput = BaseBlockUtils.blockIsGettingExternallyPowered(this.field_145850_b, this.field_174879_c))) {
            this.redstoneInput = newInput;
            this.func_70296_d();
            if (this.allowRedstoneInput) {
                if (this.redstoneInput) {
                    this.closeIris();
                } else {
                    this.openIris();
                }
            }
        }
    }

    private String side() {
        return this.field_145850_b.field_72995_K ? "Client" : "Server";
    }

    private void enterState(SGState newState, int newTimeout) {
        String newDesc;
        String oldDesc;
        if (debugState) {
            System.out.printf("SGBaseTE: at %s in dimension %s entering state %s with timeout %s\n", new Object[]{this.field_174879_c, this.field_145850_b.field_73011_w.getDimension(), newState, newTimeout});
        }
        SGState oldState = this.state;
        this.state = newState;
        this.startRingAngle = this.ringAngle;
        this.maxTimeout = newTimeout;
        this.timeout = newTimeout;
        this.markChanged();
        if (oldState == SGState.Idle != (newState == SGState.Idle)) {
            this.updateChunkLoadingStatus();
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
        }
        if (!(oldDesc = this.sgStateDescription(oldState)).equals(newDesc = this.sgStateDescription(newState))) {
            this.postEvent("sgStargateStateChange", newDesc, oldDesc);
        }
    }

    public boolean isConnected() {
        return this.state == SGState.SyncAwait || this.state == SGState.Transient || this.state == SGState.Connected || this.state == SGState.Disconnecting;
    }

    public DHDTE getLinkedControllerTE() {
        TileEntity cte;
        if (this.isLinkedToController && (cte = this.field_145850_b.func_175625_s(this.linkedPos)) instanceof DHDTE) {
            return (DHDTE)cte;
        }
        return null;
    }

    public void checkForLink() {
        int rangeXY = BaseUtils.max(DHDTE.linkRangeX, DHDTE.linkRangeY);
        int rangeZ = DHDTE.linkRangeZ;
        if (SGBaseBlock.debugMerge) {
            System.out.printf("SGBaseTE.checkForLink: in range +/-(%d,%d,%d) of %s\n", rangeXY, rangeZ, rangeXY, this.field_174879_c);
        }
        for (int i = -rangeXY; i <= rangeXY; ++i) {
            for (int j = -rangeZ; j <= rangeZ; ++j) {
                for (int k = -rangeXY; k <= rangeXY; ++k) {
                    TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(i, j, k));
                    if (!(te instanceof DHDTE)) continue;
                    ((DHDTE)te).checkForLink();
                }
            }
        }
    }

    public void unlinkFromController() {
        if (this.isLinkedToController) {
            DHDTE cte = this.getLinkedControllerTE();
            if (cte != null) {
                cte.clearLinkToStargate();
            }
            this.clearLinkToController();
        }
    }

    public void clearLinkToController() {
        if (SGBaseBlock.debugMerge) {
            System.out.printf("SGBaseTE: Unlinking stargate at %d from controller\n", this.field_174879_c);
        }
        this.isLinkedToController = false;
        this.func_70296_d();
    }

    public void connectOrDisconnect(String address, EntityPlayer player) {
        if (debugConnect) {
            System.out.printf("SGBaseTE: %s: connectOrDisconnect('%s') in state %s by %s\n", new Object[]{this.side(), address, this.state, player});
        }
        if (address.length() > 0) {
            DHDTE te = this.getLinkedControllerTE();
            if (te != null && this.connect(address, player, false) != null) {
                this.numEngagedChevrons = 0;
                this.markChanged();
            }
        } else {
            this.disconnect(player);
        }
    }

    public String disconnect(EntityPlayer player) {
        boolean canDisconnect = this.disconnectionAllowed();
        SGBaseTE dte = this.getConnectedStargateTE();
        if (canDisconnect) {
            if (this.state != SGState.Disconnecting) {
                this.disconnect();
            }
            return null;
        }
        return this.operationFailure(player, "incomingConnection", new Object[0]);
    }

    public boolean disconnectionAllowed() {
        if (this.isInitiator) {
            return true;
        }
        return this.closeFromEitherEnd;
    }

    public String connect(String address, EntityPlayer player, boolean ccInterface) {
        SGBaseTE targetGate;
        debugEnergyUse = false;
        if (this.state != SGState.Idle) {
            return this.diallingFailure(player, "selfBusy", new Object[0]);
        }
        String homeAddress = this.findHomeAddress();
        if (homeAddress.equals("")) {
            return this.diallingFailure(player, "selfOutOfRange", new Object[0]);
        }
        boolean isPermissionsAdmin = false;
        if (player != null) {
            boolean bl = isPermissionsAdmin = SGCraft.hasPermissionSystem() && SGCraft.hasPermission(player, "sgcraft.admin");
            if (!this.allowGateAccess(player.func_70005_c_()) && !isPermissionsAdmin) {
                return this.diallingFailure(player, "accessFromDenied", new Object[0]);
            }
        }
        try {
            targetGate = SGAddressing.findAddressedStargate(address, this.field_145850_b);
        }
        catch (SGAddressing.AddressingError e) {
            return this.diallingFailure(player, e.getMessage(), new Object[0]);
        }
        if (targetGate == null || !targetGate.isMerged) {
            return this.diallingFailure(player, "unknownAddress", address);
        }
        if (this.func_145831_w() == targetGate.func_145831_w()) {
            address = SGAddressing.localAddress(address);
            homeAddress = SGAddressing.localAddress(homeAddress);
        }
        if (!targetGate.allowIncomingConnections) {
            return this.diallingFailure(player, "cannotDialToThisGate", address);
        }
        if (!this.allowOutgoingConnections) {
            return this.diallingFailure(player, "cannotDialFromThisGate", address);
        }
        if (address.length() > this.getNumChevrons()) {
            return this.diallingFailure(player, "selfLackChevrons", address);
        }
        if (targetGate == this) {
            return this.diallingFailure(player, "diallingItself", new Object[0]);
        }
        if (player != null && !targetGate.allowGateAccess(player.func_70005_c_()) && !isPermissionsAdmin) {
            return this.diallingFailure(player, "playerAccessToDenied", new Object[0]);
        }
        boolean accessSystemDialDestination = true;
        if (this.defaultAllowOutgoing) {
            if (!this.allowOutgoingAddress(address, true)) {
                accessSystemDialDestination = false;
            }
        } else if (!this.allowOutgoingAddress(address, false)) {
            accessSystemDialDestination = false;
        }
        if (!accessSystemDialDestination && !isPermissionsAdmin) {
            return this.diallingFailure(player, "accessSystemDeniedOrigin", new Object[0]);
        }
        boolean accessSystemAcceptIncoming = true;
        if (targetGate.defaultAllowIncoming) {
            if (!targetGate.allowIncomingAddress(this.homeAddress, true)) {
                accessSystemAcceptIncoming = false;
            }
        } else if (!this.allowIncomingAddress(this.homeAddress, false)) {
            accessSystemAcceptIncoming = false;
        }
        if (!accessSystemAcceptIncoming && !isPermissionsAdmin) {
            return this.diallingFailure(player, "accessSystemDeniedDestination", new Object[0]);
        }
        if (debugConnect) {
            System.out.printf("SGBaseTE.connect: to %s in dimension %d with state %s\n", new Object[]{targetGate.func_174877_v(), targetGate.func_145831_w().field_73011_w.getDimension(), targetGate.state});
        }
        if (targetGate.getNumChevrons() < homeAddress.length()) {
            return this.diallingFailure(player, "targetLackChevrons", new Object[0]);
        }
        if (targetGate.state != SGState.Idle) {
            return this.diallingFailure(player, "targetBusy", address);
        }
        this.distanceFactor = this.distanceFactorForCoordDifference(this, targetGate);
        if (debugEnergyUse) {
            System.out.printf("SGBaseTE: distanceFactor = %s\n", this.distanceFactor);
        }
        if (!this.requiresNoPower) {
            energyToOpen = this.energyPerFuelItem / (double)this.gateOpeningsPerFuelItem;
            if (debugEnergyUse) {
                System.out.println("EnergyToOpen: " + energyToOpen);
            }
        } else {
            energyToOpen = 0.0;
        }
        if (!this.requiresNoPower) {
            String destinationName;
            String originName = this.func_145831_w().func_72912_H().func_76065_j().toLowerCase();
            if (ZpmAddon.routeRequiresZpm(originName, destinationName = targetGate.func_145831_w().func_72912_H().func_76065_j().toLowerCase())) {
                long power = (long)ZpmAddon.zpmPowerAvailable(this.field_145850_b, this.field_174879_c, 4, false);
                if (power <= 0L) {
                    return this.diallingFailure(player, "zpmNotFound", new Object[0]);
                }
                if (!((double)power > energyToOpen * this.distanceFactor)) {
                    return this.diallingFailure(player, "zpmLowPower", new Object[0]);
                }
                this.syncAwaitTime = 30;
                this.destinationRequiresZPM = true;
            } else {
                this.syncAwaitTime = 10;
                this.destinationRequiresZPM = false;
            }
            if (debugEnergyUse || debugZPM) {
                System.out.println("-------------------   Power Usage Debug   --------------------------");
                System.out.println("EnergyPerFuelItem: " + dFormat.format(this.energyPerFuelItem));
                System.out.println("Gate Openings Per Fuel: " + this.gateOpeningsPerFuelItem);
                System.out.println("SGPU Energy to Open with Distance Factor: " + dFormat.format(energyToOpen * this.distanceFactor));
                System.out.println("--------------------------------------------------------------------");
                System.out.println("IC2 Energy to Open with Distance Factor: " + dFormat.format(energyToOpen * this.distanceFactor * SGCraft.Ic2euPerSGEnergyUnit));
                System.out.println("--------------------------------------------------------------------");
                System.out.println("ZPM Required: " + this.destinationRequiresZPM);
                System.out.println("ZPM Multiplier: " + ZpmAddon.routeZpmMultiplier(originName, destinationName));
                System.out.println("--------------------------------------------------------------------");
                System.out.println("Energy to Open: " + energyToOpen);
                System.out.println("Distance Factor: " + this.distanceFactor);
                System.out.println("--------------------------------------------------------------------");
                System.out.println("Energy Available: " + this.availableEnergy());
                System.out.println("Energy Required: " + energyToOpen * this.distanceFactor);
                System.out.println("Energy per Tick: " + energyUsePerTick);
                System.out.println("Energy Used per Tick: " + energyUsePerTick * this.distanceFactor);
                System.out.println("--------------------------------------------------------------------");
            }
        }
        if (!this.requiresNoPower && !this.energyIsAvailable(energyToOpen * this.distanceFactor)) {
            return this.diallingFailure(player, "insufficientEnergy", new Object[0]);
        }
        if (this.hasIrisUpgrade) {
            this.wasIrisClosed = this.irisIsClosed();
        }
        if (targetGate.hasChevronUpgrade) {
            targetGate.wasIrisClosed = targetGate.irisIsClosed();
        }
        if (!GeneralAddressRegistry.addressExists(this.field_145850_b, this.homeAddress)) {
            GeneralAddressRegistry.addAddress(this.field_145850_b, this.homeAddress);
        }
        this.startDiallingStargate(address, targetGate, true, this.chevronsLockOnDial && !ccInterface);
        targetGate.enterState(SGState.attemptToDial, 0);
        targetGate.startDiallingStargate(homeAddress, this, false, this.chevronsLockOnDial && !ccInterface);
        if (this.isInitiator) {
            this.checkForMalfunction = true;
        }
        this.performBlockDamage = true;
        targetGate.performBlockDamage = true;
        return null;
    }

    public double distanceFactorForCoordDifference(TileEntity te1, TileEntity te2) {
        double dx = te1.func_174877_v().func_177958_n() - te2.func_174877_v().func_177958_n();
        double dz = te1.func_174877_v().func_177952_p() - te2.func_174877_v().func_177952_p();
        double d = Math.sqrt(dx * dx + dz * dz);
        if (debugEnergyUse) {
            System.out.printf("SGBaseTE: Connection distance = %s\n", d);
        }
        double ld = Math.log(0.05 * d + 1.0);
        double lm = Math.log(223948.0);
        double lr = ld / lm;
        double f = 1.0 + 14.0 * this.distanceFactorMultiplier * lr * lr;
        if (te1.func_145831_w() != te2.func_145831_w()) {
            f *= this.distanceFactorMultiplier;
            String originName = te1.func_145831_w().func_72912_H().func_76065_j().toLowerCase();
            String destinationName = te2.func_145831_w().func_72912_H().func_76065_j().toLowerCase();
            if (ZpmAddon.routeRequiresZpm(te1.func_145831_w().func_72912_H().func_76065_j().toLowerCase(), te2.func_145831_w().func_72912_H().func_76065_j().toLowerCase())) {
                f += (double)ZpmAddon.routeZpmMultiplier(originName, destinationName);
            }
        }
        return f;
    }

    public String diallingFailure(EntityPlayer player, String msg, Object ... args) {
        if (player != null && this.state == SGState.Idle) {
            if (this.gateType == 1) {
                this.playSGSoundEffect(m_dialFailSound, 1.0f, 1.0f);
            } else {
                this.playSGSoundEffect(p_dialFailSound, 1.0f, 1.0f);
            }
        }
        this.errorState = true;
        return this.operationFailure(player, msg, args);
    }

    public String operationFailure(EntityPlayer player, String msg, Object ... args) {
        if (player != null) {
            SGBaseTE.sendErrorMsg(player, msg, args);
        }
        return msg;
    }

    public void resetStargate() {
        this.disconnect();
        this.markChanged();
    }

    public static void sendErrorMsg(EntityPlayer player, String msg, Object ... args) {
        TextComponentTranslation component = new TextComponentTranslation("message.sgcraft:" + msg, args);
        component.func_150256_b().func_150238_a(TextFormatting.RED);
        player.func_145747_a((ITextComponent)component);
    }

    public static void sendBasicMsg(EntityPlayer player, String msg, Object ... args) {
        TextComponentTranslation component = new TextComponentTranslation("message.sgcraft:" + msg, args);
        player.func_145747_a((ITextComponent)component);
    }

    public static void sendGenericErrorMsg(EntityPlayer player, String message) {
        TextComponentString component = new TextComponentString(message);
        component.func_150256_b().func_150238_a(TextFormatting.RED);
        player.func_145747_a((ITextComponent)component);
    }

    public boolean allowOutgoingAddress(String inputRawAddress, boolean defaultValue) {
        if (inputRawAddress.length() == 9) {
            inputRawAddress = SGAddressing.formatAddress(inputRawAddress, "-", "-");
        }
        String address = inputRawAddress;
        if (this.gateAccessData != null && this.gateAccessData.stream().filter(g -> g.getAddress().equalsIgnoreCase(address)).findFirst().isPresent()) {
            GateAccessData gateAccessEntry = this.gateAccessData.stream().filter(g -> g.getAddress().equalsIgnoreCase(address)).findFirst().get();
            return gateAccessEntry.hasOutgoingAccess();
        }
        return defaultValue;
    }

    public void setAllowOutgoingAddress(String address, boolean value) {
        if (this.gateAccessData != null && this.gateAccessData.stream().filter(g -> g.getAddress().equalsIgnoreCase(address)).findFirst().isPresent()) {
            GateAccessData gateAccessEntry = this.gateAccessData.stream().filter(g -> g.getAddress().equalsIgnoreCase(address)).findFirst().get();
            gateAccessEntry.setOutgoingAccess(value);
        }
    }

    public boolean allowIncomingAddress(String inputRawAddress, boolean defaultValue) {
        if (inputRawAddress.length() == 9) {
            inputRawAddress = SGAddressing.formatAddress(inputRawAddress, "-", "-");
        }
        String address = inputRawAddress;
        if (this.gateAccessData != null && this.gateAccessData.stream().filter(g -> g.getAddress().equalsIgnoreCase(address)).findFirst().isPresent()) {
            GateAccessData gateAccessEntry = this.gateAccessData.stream().filter(g -> g.getAddress().equalsIgnoreCase(address)).findFirst().get();
            return gateAccessEntry.hasIncomingAccess();
        }
        return defaultValue;
    }

    public void setAllowIncomingAddress(String address, boolean value) {
        if (this.gateAccessData != null && this.gateAccessData.stream().filter(g -> g.getAddress().equalsIgnoreCase(address)).findFirst().isPresent()) {
            GateAccessData gateAccessEntry = this.gateAccessData.stream().filter(g -> g.getAddress().equalsIgnoreCase(address)).findFirst().get();
            gateAccessEntry.setIncomingAccess(value);
        }
    }

    public boolean allowAccessToIrisController(String playerName) {
        boolean isPermissionsAdmin;
        EntityPlayer player;
        boolean value = true;
        if (!this.defaultAllowIrisAccess) {
            value = false;
        }
        if (this.playerAccessData != null && this.playerAccessData.stream().filter(g -> g.getPlayerName().equalsIgnoreCase(playerName)).findFirst().isPresent()) {
            PlayerAccessData playerAccessEntry = this.playerAccessData.stream().filter(g -> g.getPlayerName().equalsIgnoreCase(playerName)).findFirst().get();
            value = playerAccessEntry.hasIrisAccess();
        }
        if (!this.field_145850_b.field_72995_K && SGCraft.hasPermissionSystem() && (player = this.field_145850_b.func_72924_a(playerName)) != null && (isPermissionsAdmin = SGCraft.hasPermission(player, "sgcraft.admin"))) {
            return true;
        }
        return value;
    }

    public void setAllowAccessToIrisController(String playerName, boolean value) {
        if (this.playerAccessData != null && this.playerAccessData.stream().filter(g -> g.getPlayerName().equalsIgnoreCase(playerName)).findFirst().isPresent()) {
            PlayerAccessData gateAccessEntry = this.playerAccessData.stream().filter(g -> g.getPlayerName().equalsIgnoreCase(playerName)).findFirst().get();
            gateAccessEntry.setIrisAccess(value);
        }
    }

    public boolean allowGateAccess(String playerName) {
        boolean isPermissionsAdmin;
        EntityPlayer player;
        boolean value = true;
        if (!this.defaultAllowGateAccess) {
            value = false;
        }
        if (this.playerAccessData != null && this.playerAccessData.stream().filter(g -> g.getPlayerName().equalsIgnoreCase(playerName)).findFirst().isPresent()) {
            PlayerAccessData playerAccessEntry = this.playerAccessData.stream().filter(g -> g.getPlayerName().equalsIgnoreCase(playerName)).findFirst().get();
            value = playerAccessEntry.hasGateAccess();
        }
        if (!this.field_145850_b.field_72995_K && SGCraft.hasPermissionSystem() && (player = this.field_145850_b.func_72924_a(playerName)) != null && (isPermissionsAdmin = SGCraft.hasPermission(player, "sgcraft.admin"))) {
            return true;
        }
        return value;
    }

    public void setAllowGateAccessAccess(String playerName, boolean value) {
        if (this.playerAccessData != null && this.playerAccessData.stream().filter(g -> g.getPlayerName().equalsIgnoreCase(playerName)).findFirst().isPresent()) {
            PlayerAccessData gateAccessEntry = this.playerAccessData.stream().filter(g -> g.getPlayerName().equalsIgnoreCase(playerName)).findFirst().get();
            gateAccessEntry.setGateAccess(value);
        }
    }

    public boolean allowAdminAccess(String playerName) {
        boolean isPermissionsAdmin;
        EntityPlayer player;
        boolean value = true;
        if (!this.defaultAllowAdminAccess) {
            value = false;
        }
        if (this.playerAccessData != null && this.playerAccessData.stream().filter(g -> g.getPlayerName().equalsIgnoreCase(playerName)).findFirst().isPresent()) {
            PlayerAccessData playerAccessEntry = this.playerAccessData.stream().filter(g -> g.getPlayerName().equalsIgnoreCase(playerName)).findFirst().get();
            value = playerAccessEntry.isAdmin();
        }
        if (!this.field_145850_b.field_72995_K && SGCraft.hasPermissionSystem() && (player = this.field_145850_b.func_72924_a(playerName)) != null && (isPermissionsAdmin = SGCraft.hasPermission(player, "sgcraft.admin"))) {
            return true;
        }
        return value;
    }

    public void setAllowAccessAdmin(String playerName, boolean value) {
        if (this.playerAccessData != null && this.playerAccessData.stream().filter(g -> g.getPlayerName().equalsIgnoreCase(playerName)).findFirst().isPresent()) {
            PlayerAccessData gateAccessEntry = this.playerAccessData.stream().filter(g -> g.getPlayerName().equalsIgnoreCase(playerName)).findFirst().get();
            gateAccessEntry.setAdmin(value);
        }
    }

    public List<GateAccessData> getGateAccessData() {
        if (this.gateAccessData != null) {
            return this.gateAccessData;
        }
        System.err.println("Exception in SGBaseTE: getGateAccessData is null when it shouldn't be.");
        Thread.dumpStack();
        return null;
    }

    public List<PlayerAccessData> getPlayerAccessData() {
        if (this.playerAccessData != null) {
            return this.playerAccessData;
        }
        System.err.println("Exception in SGBaseTE: getPlayerAccessData is null when it shouldn't be.");
        return null;
    }

    String findHomeAddress() {
        try {
            return this.getHomeAddress();
        }
        catch (SGAddressing.AddressingError e) {
            return "";
        }
    }

    public void disconnect() {
        SGBaseTE dte;
        if (debugConnect) {
            System.out.printf("SGBaseTE: %s: disconnect()\n", this.side());
        }
        if ((dte = SGBaseTE.at(this.connectedLocation)) != null) {
            dte.clearConnection();
        }
        this.clearConnection();
    }

    public void clearIdleConnection() {
        if (this.state == SGState.Idle) {
            this.dialledAddress = "";
            this.dialedDigit = 0;
            this.enteredAddress = "";
            this.immediateDialAddress = "";
            this.connectedLocation = null;
            this.numEngagedChevrons = 0;
            this.isInitiator = false;
            this.performBlockDamage = false;
            this.checkForMalfunction = false;
            this.markChanged();
        }
    }

    public void clearConnection() {
        if (this.state != SGState.Idle || this.connectedLocation != null) {
            this.dialledAddress = "";
            this.immediateDialAddress = "";
            this.dialedDigit = 0;
            this.enteredAddress = "";
            this.connectedLocation = null;
            this.checkForMalfunction = false;
            this.performBlockDamage = false;
            this.markChanged();
            if (this.state == SGState.Connected) {
                this.enterState(SGState.Disconnecting, 40);
                this.playSGSoundEffect(disconnectSound, 1.0f, 1.0f);
            } else {
                this.numEngagedChevrons = 0;
                if (this.state != SGState.Idle && this.state != SGState.Disconnecting) {
                    if (this.gateType == 1) {
                        this.playSGSoundEffect(m_dialFailSound, 1.0f, 1.0f);
                    } else {
                        this.playSGSoundEffect(p_dialFailSound, 1.0f, 1.0f);
                    }
                } else {
                    this.playSGSoundEffect(m_chevronOutgoingSound, 1.0f, 1.0f);
                }
                this.enterState(SGState.Idle, 0);
            }
            this.isInitiator = false;
            this.markChanged();
        }
    }

    public void immediateDialSymbol(String address, EntityPlayer player, int digit) {
        char currentSymbol = address.charAt(digit);
        String check = String.valueOf(currentSymbol);
        if (!SGAddressing.isValidSymbolChar(check)) {
            this.diallingFailure(player, "malformedAddress", address);
            return;
        }
        if (address.length() > this.getNumChevrons()) {
            this.diallingFailure(player, "selfLackChevrons", address);
            return;
        }
        if (address.length() <= this.getNumChevrons()) {
            this.enteredAddress = this.enteredAddress + currentSymbol;
            ++this.dialedDigit;
            boolean last = address.length() == this.dialedDigit;
            this.finishDiallingSymbol(Character.toString(currentSymbol), true, false, last);
            this.dialledAddress = this.enteredAddress;
            this.numEngagedChevrons = this.enteredAddress.length();
            if (last) {
                String value = this.connect(address, player, false);
                if (value != null) {
                    this.clearIdleConnection();
                }
            } else {
                this.markChanged();
            }
        }
    }

    public void malfunction() throws SGAddressing.AddressingError {
        SGBaseTE malfunctionDestinationGate;
        String randomAddress = GeneratorAddressRegistry.randomAddress(this.field_145850_b, this.homeAddress, new Random());
        if (randomAddress != null && this.allowOutgoingAddress(randomAddress, this.defaultAllowOutgoing) && (malfunctionDestinationGate = SGAddressing.findAddressedStargate(randomAddress, this.field_145850_b)) != null && malfunctionDestinationGate.allowIncomingAddress(this.homeAddress, malfunctionDestinationGate.defaultAllowIncoming)) {
            this.getConnectedStargateTE().clearConnection();
            this.connectedLocation = new SGLocation(malfunctionDestinationGate);
            malfunctionDestinationGate.numEngagedChevrons = 7;
            malfunctionDestinationGate.connectedLocation = new SGLocation(this);
            SGCraft.playSound(this, malfunctionSound);
            malfunctionDestinationGate.enterState(SGState.Connected, 0);
        }
    }

    void startDiallingStargate(String address, SGBaseTE dte, boolean initiator, boolean immediate) {
        this.dialledAddress = address;
        this.connectedLocation = new SGLocation(dte);
        this.isInitiator = initiator;
        this.func_70296_d();
        if (this.isInitiator && !immediate) {
            this.startDiallingNextSymbol();
        }
        this.postEvent(initiator ? "sgDialOut" : "sgDialIn", address);
        if (immediate) {
            this.numEngagedChevrons = this.dialledAddress.length();
            if (!initiator) {
                this.playSGSoundEffect(m_chevronIncomingSound, 1.0f, 1.0f);
            }
            this.enterState(SGState.SyncAwait, this.syncAwaitTime);
        } else {
            this.numEngagedChevrons = 0;
        }
    }

    private void startDiallingSymbol(char c) {
        int i = SGAddressing.charToSymbol(c);
        if (debugState) {
            System.out.printf("SGBaseTE.startDiallingSymbol: %s\n", i);
        }
        if (i >= 0 && i < numRingSymbols) {
            double targetAngle = (double)i * ringSymbolAngle;
            double diff = targetAngle - this.ringAngle;
            if (Math.abs(diff) < 180.0) {
                diff = (targetAngle -= Math.copySign(360.0, this.ringAngle)) - this.ringAngle;
            }
            int delay = (int)Math.abs(diff / this.ringRotationSpeed);
            this.targetRingAngle = targetAngle;
            this.enterState(SGState.Dialling, delay);
        } else {
            System.out.printf("SGCraft: Stargate jammed trying to dial symbol %s\n", Character.valueOf(c));
            this.dialledAddress = "";
            this.enterState(SGState.Idle, 0);
        }
    }

    public void unsetSymbol(char symbol) {
        --this.numEngagedChevrons;
        this.postEvent("sgChevronUnset", this.numEngagedChevrons, Character.valueOf(symbol));
    }

    public void finishDiallingSymbol(String symbol, boolean outgoing, boolean changeState, boolean lastOne) {
        ++this.numEngagedChevrons;
        this.postEvent("sgChevronEngaged", this.numEngagedChevrons, symbol);
        if (lastOne) {
            if (changeState) {
                this.enterState(SGState.SyncAwait, this.syncAwaitTime);
            }
            if (!this.field_145850_b.field_72995_K) {
                if (this.gateType == 1) {
                    this.playSGSoundEffect(outgoing ? m_chevronOutgoingSound : m_chevronIncomingSound, 1.0f, 1.0f);
                } else {
                    this.playSGSoundEffect(outgoing ? p_chevronOutgoingSound : p_chevronIncomingSound, 1.0f, 1.0f);
                }
            }
        } else {
            if (changeState) {
                this.enterState(SGState.InterDialling, 10);
            }
            if (!this.field_145850_b.field_72995_K) {
                if (this.gateType == 1) {
                    this.playSGSoundEffect(outgoing ? m_chevronOutgoingSound : m_chevronIncomingSound, 1.0f, 1.0f);
                } else {
                    this.playSGSoundEffect(outgoing ? p_chevronOutgoingSound : p_chevronIncomingSound, 1.0f, 1.0f);
                }
            }
        }
    }

    private void attemptToLockStargate() {
        if (!this.isInitiator || this.useEnergy(energyToOpen * this.distanceFactor)) {
            this.enterState(SGState.EstablishingConnection, 30);
        } else {
            this.disconnect();
        }
    }

    private void openStargate() {
        if (debugConnect) {
            System.out.printf("SGBaseTE: Connecting to '%s'\n", this.dialledAddress);
        }
        this.enterState(SGState.Transient, 20);
    }

    public boolean canTravelFromThisEnd() {
        return this.isInitiator || !this.oneWayTravel;
    }

    private boolean symbolsRemaining(boolean before) {
        int n = this.numEngagedChevrons;
        return n < this.dialledAddress.length() - (before ? 1 : 0);
    }

    private void startDiallingNextSymbol() {
        if (debugState) {
            System.out.printf("SGBaseTE.startDiallingNextSymbol: %s of %s\n", this.numEngagedChevrons, this.dialledAddress);
        }
        this.startDiallingSymbol(this.dialledAddress.charAt(this.numEngagedChevrons));
    }

    void tickEnergyUsage() {
        if (this.state == SGState.Connected && this.isInitiator && !this.requiresNoPower && !this.useEnergy(energyUsePerTick * this.distanceFactor)) {
            this.disconnect();
        }
    }

    public double availableEnergy() {
        List<ISGEnergySource> sources = this.findEnergySources(this.destinationRequiresZPM);
        return this.energyInBuffer + this.energyAvailableFrom(sources);
    }

    public boolean energyIsAvailable(double amount) {
        double energy = this.availableEnergy();
        if (debugEnergyUse) {
            System.out.printf("SGBaseTE.energyIsAvailable: need %s, have %s\n", amount, energy);
        }
        return energy >= amount;
    }

    public boolean useEnergy(double amount) {
        debugEnergyUse = false;
        if (this.requiresNoPower) {
            return true;
        }
        if (debugEnergyUse) {
            System.out.printf("SGBaseTE.useEnergy: %s; buffered: %s\n", amount, this.energyInBuffer);
        }
        if (amount <= this.energyInBuffer) {
            this.energyInBuffer -= amount;
            if (this.updated++ > 10) {
                this.markChanged();
                this.updated = 0;
            }
            return true;
        }
        List<ISGEnergySource> sources = this.findEnergySources(this.destinationRequiresZPM);
        double energyAvailable = this.energyInBuffer + this.energyAvailableFrom(sources);
        if (debugEnergyUse) {
            System.out.printf("SGBaseTE.useEnergy: %s available\n", energyAvailable);
        }
        if (amount > energyAvailable) {
            if (debugEnergyUse) {
                System.out.print("SGBaseTE: Not enough energy available\n");
            }
            return false;
        }
        double desiredEnergy = BaseUtils.max(amount, this.maxEnergyBuffer);
        double targetEnergy = BaseUtils.min(desiredEnergy, energyAvailable);
        double energyRequired = targetEnergy - this.energyInBuffer;
        if (debugEnergyUse) {
            System.out.printf("SGBaseTE.useEnergy: another %s required\n", energyRequired);
        }
        double energyOnHand = this.energyInBuffer + this.drawEnergyFrom(sources, energyRequired);
        if (debugEnergyUse) {
            System.out.printf("SGBaseTE.useEnergy: %s now on hand, need %s\n", energyOnHand, amount);
        }
        if (amount - 1.0E-4 > energyOnHand) {
            if (debugEnergyUse) {
                System.out.printf("SGBaseTE: Energy sources only delivered %s of promised %s\n", energyOnHand - this.energyInBuffer, energyAvailable);
            }
            return false;
        }
        this.setEnergyInBuffer(energyOnHand - amount);
        if (debugEnergyUse) {
            System.out.printf("SGBaseTE.useEnergy: %s left over in buffer\n", this.energyInBuffer);
        }
        return true;
    }

    private List<ISGEnergySource> findEnergySources(boolean requireZPM) {
        boolean ccLoaded = BaseMod.isModLoaded("computercraft");
        boolean ocLoaded = BaseMod.isModLoaded("opencomputers");
        boolean ic2Loaded = BaseMod.isModLoaded("ic2");
        DHDTE te = this.getLinkedControllerTE();
        if (debugEnergyUse) {
            System.out.printf("SGBaseTe.findEnergySources: for %s\n", this.getSoundPos());
        }
        ArrayList<ISGEnergySource> result = new ArrayList<ISGEnergySource>();
        int radius = 4;
        for (BlockPos.MutableBlockPos nearPos : BlockPos.func_177975_b((BlockPos)this.field_174879_c.func_177982_a(-radius, -radius, -radius), (BlockPos)this.field_174879_c.func_177982_a(radius, radius, radius))) {
            TileEntity nte = this.field_145850_b.func_175625_s((BlockPos)nearPos);
            if (debugEnergyUse) {
                // empty if block
            }
            if (!(nte instanceof ISGEnergySource)) continue;
            if (ic2Loaded && nte instanceof IC2PowerTE) {
                result.add((ISGEnergySource)nte);
                if (debugEnergyUse) {
                    System.out.println("Found IC2PowerTE at: " + nte.func_174877_v());
                }
            }
            if (ic2Loaded && nte instanceof ZpmInterfaceCartTE) {
                if (!((ZpmInterfaceCartTE)nte).func_191420_l()) {
                    result.add((ISGEnergySource)nte);
                }
                if (debugEnergyUse) {
                    System.out.println("Found ZpmInterfaceCartTE at: " + nte.func_174877_v());
                }
            }
            if (nte instanceof ZpmConsoleTE) {
                if (!((ZpmConsoleTE)nte).func_191420_l()) {
                    result.add((ISGEnergySource)nte);
                }
                if (debugEnergyUse) {
                    System.out.println("Added the ZpmConsoleTE to a Source");
                }
            }
            if (nte instanceof SGPowerTE) {
                result.add((ISGEnergySource)nte);
                if (debugEnergyUse) {
                    System.out.println("Found SGPowerTE at: " + nte.func_174877_v());
                }
            }
            if (!ocLoaded || !(nte instanceof OCInterfaceTE)) continue;
            result.add((ISGEnergySource)nte);
            if (!debugEnergyUse) continue;
            System.out.println("Found OCInterfaceTE at: " + nte.func_174877_v());
        }
        if (te != null) {
            if (this.useDHDFuelSource) {
                if (!requireZPM) {
                    result.add(te);
                    if (debugEnergyUse) {
                        System.out.println("Found DHDTE at: " + te.func_174877_v());
                    }
                } else if (debugEnergyUse) {
                    System.out.println("Found DHDTE at: " + te.func_174877_v() + " but was not added because destination requires ZPM");
                }
            } else if (debugEnergyUse) {
                System.out.println("Found DHDTE at: " + te.func_174877_v() + " but was not added because it is disabled in the config.");
            }
        }
        return result;
    }

    private double energyAvailableFrom(List<ISGEnergySource> sources) {
        double energy = 0.0;
        for (ISGEnergySource source : sources) {
            double e = source.availableEnergy();
            if (debugEnergyUse) {
                System.out.printf("SGBaseTe.energyAvailableFrom: %s can supply %s\n", source, e);
            }
            energy += e;
        }
        if (debugEnergyUse) {
            System.out.println("Energy from Sources: " + energy);
        }
        return energy;
    }

    private double drawEnergyFrom(List<ISGEnergySource> sources, double amount) {
        double total = 0.0;
        for (ISGEnergySource source : sources) {
            if (total >= amount) break;
            double e = source.drawEnergyDouble(amount - total);
            if (debugEnergyUse) {
                System.out.printf("SGBaseTe.drawEnergyFrom: %s supplied %s\n", source, e);
            }
            total += e;
        }
        if (total < amount && debugEnergyUse) {
            System.out.printf("SGCraft: Warning: Energy sources did not deliver promised energy (%s requested, %s delivered)\n", amount, total);
        }
        return total;
    }

    private void setEnergyInBuffer(double amount) {
        if (this.energyInBuffer != amount) {
            this.energyInBuffer = amount;
            this.func_70296_d();
        }
    }

    private void performTransientDamage() {
        if (this.gateOrientation == 1) {
            Trans3 t = this.localToGlobalTransformation();
            Vector3 p0 = t.p(-1.5, 0.5, 0.5);
            Vector3 p1 = t.p(1.5, 3.5, 5.5);
            Vector3 q0 = p0.min(p1);
            Vector3 q1 = p0.max(p1);
            AxisAlignedBB box = new AxisAlignedBB(q0.x, q0.y, q0.z, q1.x, q1.y, q1.z);
            if (debugTransientDamage) {
                System.out.print("SGBaseTE.performTransientDamage: players in world:\n");
                for (Entity ent : this.field_145850_b.field_72996_f) {
                    if (!(ent instanceof EntityPlayer)) continue;
                    System.out.printf("--- %s\n", ent);
                }
                System.out.printf("SGBaseTE.performTransientDamage: box = %s\n", box);
            }
            List ents = this.field_145850_b.func_72872_a(EntityLivingBase.class, box);
            for (EntityLivingBase ent : ents) {
                Vector3 ep = new Vector3(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
                Vector3 gp = t.p(0.0, 2.0, 0.5);
                double dist = ep.distance(gp);
                if (debugTransientDamage) {
                    System.out.printf("SGBaseTE.performTransientDamage: found %s\n", ent);
                }
                if (dist > 1.0) {
                    dist = 1.0;
                }
                int damage = (int)Math.ceil(dist * 50.0);
                if (debugTransientDamage) {
                    System.out.printf("SGBaseTE.performTransientDamage: distance = %s, damage = %s\n", dist, damage);
                }
                ent.func_70097_a(transientDamageSource, (float)damage);
            }
            t = this.localToGlobalTransformation();
            p0 = t.p(-1.0, 0.5, 0.5);
            p1 = t.p(1.0, 2.5, 2.5);
            if (this.performBlockDamage && !this.irisIsClosed()) {
                BlockPos startPos = new BlockPos(p0.x, p0.y, p0.z);
                BlockPos endPos = new BlockPos(p1.x, p1.y, p1.z);
                for (BlockPos nearPos : BlockPos.func_177980_a((BlockPos)startPos, (BlockPos)endPos)) {
                    this.field_145850_b.func_175656_a(nearPos, Blocks.field_150350_a.func_176223_P());
                }
                this.performBlockDamage = false;
            }
        }
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    public ItemStack getCamouflageStack(BlockPos cpos) {
        int i;
        Trans3 t = this.localToGlobalTransformation();
        Vector3 p = t.ip(Vector3.blockCenter(cpos));
        if (p.y == 0.0 && (i = 2 + p.roundX()) >= 0 && i < 5) {
            return this.func_70301_a(firstCamouflageSlot + i);
        }
        return null;
    }

    boolean isCamouflageSlot(int slot) {
        return slot >= firstCamouflageSlot && slot < firstCamouflageSlot + numCamouflageSlots;
    }

    @Override
    protected void onInventoryChanged(int slot) {
        super.onInventoryChanged(slot);
        if (this.isCamouflageSlot(slot)) {
            for (int dx = -2; dx <= 2; ++dx) {
                for (int dz = -2; dz <= 2; ++dz) {
                    BaseBlockUtils.markBlockForUpdate(this.field_145850_b, this.field_174879_c.func_177982_a(dx, 0, dz));
                }
            }
        }
    }

    protected int baseCornerCamouflage() {
        return BaseUtils.max(this.baseCamouflageAt(0), this.baseCamouflageAt(4));
    }

    protected int baseCamouflageAt(int i) {
        ItemStack stack = this.func_70301_a(i);
        if (stack != null) {
            Item item = stack.func_77973_b();
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            if (block != Blocks.field_150350_a) {
                if (block instanceof BlockSlab) {
                    return 1;
                }
                int meta = item.getMetadata(stack);
                IBlockState state = block.func_176203_a(meta);
                if (state.func_185917_h()) {
                    return 2;
                }
            }
        }
        return 0;
    }

    String repr(Entity entity) {
        if (entity != null) {
            String s = String.format("%s#%s", entity.getClass().getSimpleName(), entity.func_145782_y());
            if (entity.field_70128_L) {
                s = s + "(dead)";
            }
            return s;
        }
        return "null";
    }

    void checkForEntitiesInPortal() {
        if (this.state == SGState.Connected) {
            for (TrackedEntity trk : this.trackedEntities) {
                this.entityInPortal(trk.entity, trk.lastPos);
            }
            this.trackedEntities.clear();
            Vector3 p0 = null;
            Vector3 p1 = null;
            if (this.gateOrientation == 1) {
                p0 = new Vector3(-1.5, 0.5, -1.5);
                p1 = new Vector3(1.5, 3.5, 1.5);
            }
            if (this.gateOrientation == 2 || this.gateOrientation == 3) {
                p0 = new Vector3(1.5, -1.5, -0.5);
                p1 = new Vector3(-1.5, 1.5, -3.5);
            }
            Trans3 t = this.localToGlobalTransformation();
            AxisAlignedBB box = t.box(p0, p1);
            List ents = this.field_145850_b.func_72872_a(Entity.class, box);
            for (Entity entity : ents) {
                if (entity instanceof EntityFishHook || entity instanceof EntityStargateIris || entity.field_70128_L || entity.func_184187_bx() != null) continue;
                if (entity instanceof EntityPlayer) {
                    // empty if block
                }
                this.trackedEntities.add(new TrackedEntity(entity));
            }
        } else {
            this.trackedEntities.clear();
        }
    }

    public void entityInPortal(Entity entity, Vector3 prevPos) {
        if (!entity.field_70128_L && this.state == SGState.Connected) {
            Trans3 t = this.localToGlobalTransformation();
            double vx = entity.field_70165_t - prevPos.x;
            double vy = entity.field_70163_u - prevPos.y;
            double vz = entity.field_70161_v - prevPos.z;
            Vector3 p1 = t.ip(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            Vector3 p0 = t.ip(2.0 * prevPos.x - entity.field_70165_t, 2.0 * prevPos.y - entity.field_70163_u, 2.0 * prevPos.z - entity.field_70161_v);
            double z0 = 0.0;
            double zx = -2.0;
            if (this.gateOrientation == 1 && p0.z >= z0 && p1.z < z0 && p1.z > z0 - 5.0 || this.gateOrientation == 2 && p0.y >= z0 && p1.y < z0 && p1.y > z0 - 5.0 || this.gateOrientation == 3 && p0.y <= zx && p1.y > zx && p1.y > zx + 0.0) {
                entity.field_70159_w = vx;
                entity.field_70181_x = vy;
                entity.field_70179_y = vz;
                SGBaseTE dte = this.getConnectedStargateTE();
                if (dte != null) {
                    Trans3 dt = dte.localToGlobalTransformation();
                    while (entity.func_184187_bx() != null) {
                        entity = entity.func_184187_bx();
                    }
                    this.teleportEntityAndRiders(entity, t, dt, this.connectedLocation.dimension, dte.irisIsClosed());
                }
            }
        }
    }

    private boolean playerHasTeleportAccess(Entity entity) {
        SGBaseTE dte = this.getConnectedStargateTE();
        boolean allowTeleport = true;
        if (!(!(entity instanceof EntityPlayer) || this.allowGateAccess(entity.func_70005_c_()) && dte.allowGateAccess(entity.func_70005_c_()))) {
            allowTeleport = false;
        }
        if (!allowTeleport) {
            if (entity instanceof EntityPlayer) {
                entity.func_145747_a((ITextComponent)new TextComponentString("Transport Failed.  Gate Access Denied!"));
            }
            if (entity.func_184187_bx() != null && entity.func_184187_bx() instanceof EntityPlayer) {
                entity.func_145747_a((ITextComponent)new TextComponentString("Rider Transport failed.  Gate Access Denied!"));
            }
            return false;
        }
        return true;
    }

    Entity teleportEntityAndRiders(Entity entity, Trans3 t1, Trans3 t2, int dimension, boolean destBlocked) {
        Entity rider2;
        int i;
        boolean canProceed = true;
        if (debugTeleport) {
            System.out.printf("SGBaseTE.teleportEntityAndRiders: destBlocked = %s\n", destBlocked);
        }
        List riders = entity.func_184188_bt();
        for (i = 0; i < riders.size(); ++i) {
            rider2 = (Entity)riders.get(i);
            if (!(rider2 instanceof EntityPlayer) || this.playerHasTeleportAccess(rider2)) continue;
            canProceed = false;
        }
        if (entity instanceof EntityPlayer && !this.playerHasTeleportAccess(entity)) {
            canProceed = false;
        }
        if (canProceed) {
            for (i = 0; i < riders.size(); ++i) {
                rider2 = (Entity)riders.get(i);
                rider2.func_184210_p();
                rider2 = this.teleportEntityAndRiders(rider2, t1, t2, dimension, destBlocked);
                riders.set(i, rider2);
            }
            this.unleashEntity(entity);
            entity = this.teleportEntity(entity, t1, t2, dimension, destBlocked);
            if (entity != null && !entity.field_70128_L) {
                for (Entity rider2 : riders) {
                    if (rider2 == null || rider2.field_70128_L) continue;
                    rider2.func_184205_a(entity, true);
                }
            }
        }
        return entity;
    }

    protected void unleashEntity(Entity entity) {
        if (entity instanceof EntityLiving) {
            ((EntityLiving)entity).func_110160_i(true, false);
        }
        for (EntityLiving entity2 : this.entitiesWithinLeashRange(entity)) {
            if (!entity2.func_110167_bD() || entity2.func_110166_bE() != entity) continue;
            entity2.func_110160_i(true, false);
        }
    }

    protected List<EntityLiving> entitiesWithinLeashRange(Entity entity) {
        AxisAlignedBB box = new AxisAlignedBB(entity.field_70165_t - 7.0, entity.field_70163_u - 7.0, entity.field_70161_v - 7.0, entity.field_70165_t + 7.0, entity.field_70163_u + 7.0, entity.field_70161_v + 7.0);
        return entity.field_70170_p.func_72872_a(EntityLiving.class, box);
    }

    Entity teleportEntity(Entity entity, Trans3 t1, Trans3 t2, int dimension, boolean destBlocked) {
        EntityPlayer player;
        Entity newEntity = null;
        if (debugTeleport) {
            System.out.printf("SGBaseTE.teleportEntity: %s (in dimension %d)  to dimension %d\n", this.repr(entity), entity.field_71093_bK, dimension);
            System.out.printf("SGBaseTE.teleportEntity: pos (%.2f, %.2f, %.2f) prev (%.2f, %.2f, %.2f) last (%.2f, %.2f, %.2f) pitch %.2f yaw %.2f\n", entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70169_q, entity.field_70167_r, entity.field_70166_s, entity.field_70142_S, entity.field_70137_T, entity.field_70136_U, Float.valueOf(entity.field_70125_A), Float.valueOf(entity.field_70177_z));
        }
        Vector3 p = t1.ip(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        Vector3 v = t1.iv(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
        Vector3 r = t1.iv(this.yawVector(entity));
        Vector3 q = t2.p(-p.x, p.y, -p.z);
        Vector3 original = t2.p(0.0, 0.0, 0.0);
        Vector3 u = t2.v(-v.x, v.y, -v.z);
        Vector3 s = t2.v(r.mul(-1.0));
        if (this.getConnectedStargateTE().gateOrientation == 2) {
            q = t2.p(0.0, 0.0, -2.0);
            if (this.gateOrientation == 1) {
                u = t2.v(0.0, -v.z, 0.0);
            } else if (this.gateOrientation == 2) {
                u = t2.v(0.0, -v.y, 0.0);
            } else if (this.gateOrientation == 3) {
                u = t2.v(0.0, -v.z, 0.0);
            }
        }
        if (this.getConnectedStargateTE().gateOrientation == 3) {
            q = t2.p(0.0, 0.0, -2.0);
            u = t2.v(0.0, v.y, 0.0);
        }
        if (this.gateOrientation >= 2 && this.getConnectedStargateTE().gateOrientation == 1) {
            q = t2.p(0.0, 0.5, 0.0);
            if (this.gateOrientation == 2) {
                u = t2.v(0.0, 0.0, -v.y);
            } else if (this.gateOrientation == 3) {
                u = t2.v(0.0, 0.0, v.y);
            }
        }
        if (debugTeleport) {
            System.out.printf("SGBaseTE.teleportEntity: Facing old %s new %s\n", r, s);
        }
        double a = this.yawAngle(s, entity);
        if (debugTeleport) {
            System.out.printf("SGBaseTE.teleportEntity: new yaw %.2f\n", a);
        }
        if (!this.canTravelFromThisEnd() && !this.isInitiator) {
            if (this.reverseWormholeKills) {
                this.terminateEntityByReverseWormhole(entity);
                return entity;
            }
            return entity;
        }
        if (entity instanceof EntityPlayer && (player = (EntityPlayer)entity) != null && !player.func_184592_cb().func_190926_b() && player.func_184592_cb().func_77973_b().equals(SGCraft.tollan_phase_shift_device)) {
            destBlocked = false;
        }
        if (!destBlocked) {
            this.playTeleportSound(entity.func_130014_f_(), new Vector3(entity.func_174791_d()), entity);
            newEntity = entity.field_71093_bK == dimension ? this.teleportWithinDimension(entity, q, u, a, destBlocked) : this.teleportToOtherDimension(entity, q, u, a, dimension, destBlocked);
        } else {
            this.terminateEntityByIrisImpact(entity);
            this.playIrisHitSound((World)SGBaseTE.worldForDimension(dimension), q, entity);
        }
        this.playTeleportSound(entity.func_130014_f_(), new Vector3(entity.func_174791_d()), entity);
        return newEntity;
    }

    public void terminateEntityByIrisImpact(Entity entity) {
        if (entity instanceof EntityPlayer) {
            this.terminatePlayerByIrisImpact((EntityPlayer)entity);
        } else {
            entity.func_70106_y();
        }
    }

    public void terminatePlayerByIrisImpact(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            SGBaseTE.sendErrorMsg(player, "irisAtDestination", new Object[0]);
        } else {
            if (!this.preserveInventory && !player.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
                player.field_71071_by.func_174888_l();
            }
            player.func_70097_a(irisDamageSource, 1000000.0f);
        }
    }

    public void terminateEntityByReverseWormhole(Entity entity) {
        if (entity instanceof EntityPlayer) {
            this.terminatePlayerByReverseWormhole((EntityPlayer)entity);
        } else {
            entity.func_70106_y();
        }
    }

    public void terminatePlayerByReverseWormhole(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            SGBaseTE.sendErrorMsg(player, "reverseWormhole", new Object[0]);
        } else {
            if (!this.preserveInventory && !player.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
                player.field_71071_by.func_174888_l();
            }
            player.func_70097_a(transientDamageSource, 1000000.0f);
            if (!player.field_70128_L) {
                player.func_70606_j(0.0f);
            }
        }
    }

    static WorldServer worldForDimension(int dimension) {
        return SGAddressing.getWorld(dimension);
    }

    Entity teleportWithinDimension(Entity entity, Vector3 p, Vector3 v, double a, boolean destBlocked) {
        if (entity instanceof EntityPlayerMP) {
            return this.teleportPlayerWithinDimension((EntityPlayerMP)entity, p, v, a);
        }
        return this.teleportEntityToWorld(entity, p, v, a, (WorldServer)entity.field_70170_p, destBlocked);
    }

    Entity teleportPlayerWithinDimension(EntityPlayerMP entity, Vector3 p, Vector3 v, double a) {
        entity.field_70177_z = (float)a;
        this.setEntityLocationAndPitch((Entity)entity, p, a);
        SGBaseTE.setVelocity((Entity)entity, v);
        entity.field_70170_p.func_72866_a((Entity)entity, false);
        entity.field_70133_I = true;
        return entity;
    }

    Entity teleportToOtherDimension(Entity entity, Vector3 p, Vector3 v, double a, int dimension, boolean destBlocked) {
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            Vector3 q = p.add(this.yawVector(a));
            this.transferPlayerToDimension(player, dimension, q, v, a);
            return player;
        }
        SGBaseTE.setVelocity(entity, v);
        return this.teleportEntityToDimension(entity, p, v, a, dimension, destBlocked);
    }

    void transferPlayerToDimension(EntityPlayerMP player, int newDimension, Vector3 p, Vector3 v, double a) {
        FakeTeleporter fakeTeleporter = new FakeTeleporter();
        player.changeDimension(newDimension, (ITeleporter)fakeTeleporter);
        if (player.field_71093_bK == newDimension) {
            this.setEntityLocationAndPitch((Entity)player, p, a);
            SGBaseTE.setVelocity((Entity)player, v);
            player.field_70133_I = true;
        }
    }

    Entity teleportEntityToDimension(Entity entity, Vector3 p, Vector3 v, double a, int dimension, boolean destBlocked) {
        MinecraftServer server = BaseUtils.getMinecraftServer();
        WorldServer world = server.func_71218_a(dimension);
        return this.teleportEntityToWorld(entity, p, v, a, world, destBlocked);
    }

    Entity teleportEntityToWorld(Entity entity, Vector3 p, Vector3 v, double a, WorldServer newWorld, boolean destBlocked) {
        if (destBlocked && !(entity instanceof EntityLivingBase)) {
            return null;
        }
        if (this.field_145850_b == newWorld) {
            entity.field_70177_z = (float)a;
            this.setEntityLocationAndPitch(entity, p, a);
            SGBaseTE.setVelocity(entity, v);
            entity.field_70170_p.func_72866_a(entity, false);
            entity.field_70133_I = true;
            return entity;
        }
        FakeTeleporter fakeTeleporter = new FakeTeleporter();
        Entity newEntity = entity.changeDimension(newWorld.field_73011_w.getDimension(), (ITeleporter)fakeTeleporter);
        if (newEntity.field_71093_bK == newWorld.field_73011_w.getDimension()) {
            this.setEntityLocationAndPitch(newEntity, p, a);
            SGBaseTE.setVelocity(newEntity, v);
            newEntity.field_70133_I = true;
        }
        return newEntity;
    }

    private void setEntityLocationAndPitch(Entity entity, Vector3 p, double yaw) {
        float pitch = entity.field_70125_A;
        if (this.getConnectedStargateTE().gateOrientation == 2) {
            pitch -= 90.0f;
        }
        if (this.getConnectedStargateTE().gateOrientation == 3) {
            pitch += 90.0f;
        }
        double x = p.x;
        double y = p.y;
        double z = p.z;
        if (this.getConnectedStargateTE().gateOrientation == 3) {
            y -= 4.0;
        }
        if (entity instanceof EntityPlayerMP) {
            ((EntityPlayerMP)entity).field_71135_a.func_147364_a(x, y, z, (float)yaw, pitch);
        } else {
            entity.func_70012_b(x, y, z, (float)yaw, -pitch);
        }
    }

    static void setVelocity(Entity entity, Vector3 v) {
        entity.field_70159_w = v.x;
        entity.field_70181_x = v.y;
        entity.field_70179_y = v.z;
    }

    protected static int yawSign(Entity entity) {
        return entity instanceof EntityArrow ? -1 : 1;
    }

    Vector3 yawVector(Entity entity) {
        return this.yawVector((float)SGBaseTE.yawSign(entity) * entity.field_70177_z);
    }

    Vector3 yawVector(double yaw) {
        double a = Math.toRadians(yaw);
        Vector3 v = new Vector3(-Math.sin(a), 0.0, Math.cos(a));
        return v;
    }

    double yawAngle(Vector3 v, Entity entity) {
        double a = Math.atan2(-v.x, v.z);
        double d = Math.toDegrees(a);
        return (double)SGBaseTE.yawSign(entity) * d;
    }

    public SGBaseTE getConnectedStargateTE() {
        return this.isConnected() && this.connectedLocation != null ? this.connectedLocation.getStargateTE() : null;
    }

    static void copyMoreEntityData(EntityLiving oldEntity, EntityLiving newEntity) {
        float s = oldEntity.func_70689_ay();
        if (s != 0.0f) {
            newEntity.func_70659_e(s);
        }
    }

    public void updateIrisEntity() {
        if (this.isMerged && this.hasIrisUpgrade) {
            if (!this.hasIrisEntity()) {
                EntityStargateIris ent = new EntityStargateIris(this);
                this.field_145850_b.func_72838_d((Entity)ent);
            }
        } else {
            for (EntityStargateIris ent : this.findIrisEntities()) {
                this.field_145850_b.func_72900_e((Entity)ent);
            }
        }
    }

    boolean hasIrisEntity() {
        return this.findIrisEntities().size() != 0;
    }

    List<EntityStargateIris> findIrisEntities() {
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        AxisAlignedBB box = new AxisAlignedBB((double)(x - 3), (double)(y - 3), (double)(z - 3), (double)(x + 3), (double)(y + 3), (double)(z + 3));
        return this.field_145850_b.func_72872_a(EntityStargateIris.class, box);
    }

    @Override
    public float getSoundVolume(SoundEvent sound) {
        return soundVolume;
    }

    @Override
    public World getSoundWorld() {
        return this.field_145850_b;
    }

    @Override
    public BlockPos getSoundPos() {
        return this.field_174879_c;
    }

    @Override
    public boolean isSoundActive(SoundEvent sound) {
        if (this.func_145837_r() || !this.field_145850_b.func_175667_e(this.field_174879_c) || this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        if (sound == m_gateRollSound || sound == p_gateRollSound) {
            return this.state == SGState.Dialling;
        }
        if (sound == irisOpenSound) {
            return this.irisState == IrisState.Opening;
        }
        if (sound == irisCloseSound) {
            return this.irisState == IrisState.Closing;
        }
        if (sound == eventHorizonSound || sound == malfunctionSound) {
            return this.state == SGState.Connected;
        }
        return false;
    }

    void playIrisHitSound(World world, Vector3 pos, Entity entity) {
        float volume = (float)BaseUtils.min(entity.field_70130_N * entity.field_70131_O, 1.0);
        float pitch = 2.0f - volume;
        if (debugTeleport) {
            System.out.printf("SGBaseTE.playIrisHitSound: at (%.3f,%.3f,%.3f) volume %.3f pitch %.3f\n", pos.x, pos.y, pos.z, Float.valueOf(volume), Float.valueOf(pitch));
        }
        this.playSoundEffect(world, pos.x, pos.y, pos.z, irisHitSound, volume * soundVolume, pitch);
    }

    void playTeleportSound(World world, Vector3 pos, Entity entity) {
        float volume = (float)BaseUtils.min(entity.field_70130_N * entity.field_70131_O, 1.0);
        float pitch = 2.0f - volume;
        if (debugTeleport) {
            System.out.printf("SGBaseTE.playTeleportSound: at (%.3f,%.3f,%.3f) volume %.3f pitch %.3f\n", pos.x, pos.y, pos.z, Float.valueOf(volume), Float.valueOf(pitch));
        }
        this.playSoundEffect(world, pos.x, pos.y, pos.z, teleportSound, volume * soundVolume, pitch);
    }

    public void playSGSoundEffect(SoundEvent se, float volume, float pitch) {
        this.playSoundEffect(se, volume * soundVolume, pitch);
    }

    void serverUpdate() {
        if (!this.loaded) {
            this.loaded = true;
            try {
                this.homeAddress = this.getHomeAddress();
                this.addressError = "";
            }
            catch (SGAddressing.AddressingError e) {
                this.homeAddress = null;
                this.addressError = e.getMessage();
            }
            if (SGCraft.ocIntegration != null) {
                SGCraft.ocIntegration.onSGBaseTEAdded(this);
            }
        }
        if (this.isMerged) {
            if (debugState && this.state != SGState.Connected && this.timeout > 0) {
                int dimension = this.field_145850_b.field_73011_w.getDimension();
                System.out.printf("SGBaseTE.serverUpdate at %s in dimension %d: state %s, timeout %s\n", new Object[]{this.field_174879_c, dimension, this.state, this.timeout});
            }
            this.tickEnergyUsage();
            if (this.timeout > 0) {
                switch (this.state) {
                    case Transient: {
                        if (this.irisIsClosed() || !this.transientDamage) break;
                        this.performTransientDamage();
                        break;
                    }
                    case Dialling: {
                        double step = (double)(this.maxTimeout - this.timeout) / (double)this.maxTimeout;
                        this.ringAngle = this.startRingAngle + (this.targetRingAngle - this.startRingAngle) * step;
                        break;
                    }
                    case EstablishingConnection: {
                        if (this.timeout != 25) break;
                        if (this.gateType == 1) {
                            this.playSGSoundEffect(m_connectSound, 1.0f, 1.0f);
                            break;
                        }
                        this.playSGSoundEffect(p_connectSound, 1.0f, 1.0f);
                        break;
                    }
                    case Connected: {
                        Random rand;
                        if (!this.checkForMalfunction || !this.isInitiator) break;
                        BlockPos rainCheckPos = this.gateType == 1 ? new BlockPos(this.func_174877_v().func_177958_n(), this.getY() + 5, this.getZ()) : new BlockPos(this.func_174877_v().func_177958_n(), this.getY(), this.getZ());
                        if (rainCheckPos != null && this.field_145850_b.func_72896_J() && this.field_145850_b.func_175727_C(rainCheckPos) && (rand = new Random()).nextInt(100) <= 5) {
                            try {
                                this.field_145850_b.func_72942_c((Entity)new EntityLightningBolt(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), true));
                                this.malfunction();
                            }
                            catch (SGAddressing.AddressingError addressingError) {
                                addressingError.printStackTrace();
                            }
                        }
                        this.checkForMalfunction = false;
                    }
                }
                --this.timeout;
            } else {
                switch (this.state) {
                    case Idle: {
                        if (!this.symbolsRemaining(false) || !this.isInitiator) break;
                        this.startDiallingNextSymbol();
                        break;
                    }
                    case Dialling: {
                        if (!this.isInitiator) break;
                        try {
                            char charTargetSymbol = this.dialledAddress.charAt(this.numEngagedChevrons);
                            char charOwnSymbol = this.homeAddress.charAt(this.numEngagedChevrons);
                            String targetSymbol = Character.toString(charTargetSymbol);
                            String ownSymbol = Character.toString(charOwnSymbol);
                            this.finishDiallingSymbol(targetSymbol, true, true, !this.symbolsRemaining(true));
                            SGBaseTE targetGate = SGBaseTE.at(this.connectedLocation);
                            targetGate.finishDiallingSymbol(ownSymbol, false, true, !targetGate.symbolsRemaining(true));
                        }
                        catch (Exception e) {
                            this.clearConnection();
                            this.resetStargate();
                        }
                        break;
                    }
                    case InterDialling: {
                        if (!this.isInitiator) break;
                        this.startDiallingNextSymbol();
                        break;
                    }
                    case SyncAwait: {
                        this.attemptToLockStargate();
                        break;
                    }
                    case EstablishingConnection: {
                        this.openStargate();
                        break;
                    }
                    case Transient: {
                        this.enterState(SGState.Connected, this.isInitiator ? this.ticksToStayOpen : 0);
                        break;
                    }
                    case Connected: {
                        if (!this.isInitiator || this.ticksToStayOpen <= 0) break;
                        this.disconnect();
                        break;
                    }
                    case Disconnecting: {
                        this.numEngagedChevrons = 0;
                        this.enterState(SGState.Idle, 0);
                        if (!this.hasIrisUpgrade || !this.returnToPreviousIrisState || !this.wasIrisClosed) break;
                        this.closeIris();
                    }
                }
            }
        }
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        IrisState oldIrisState = this.irisState;
        SGState oldState = this.state;
        super.onDataPacket(net, pkt);
        if (this.isMerged) {
            if (this.state != oldState) {
                switch (this.state) {
                    case Transient: {
                        this.initiateOpeningTransient();
                        break;
                    }
                    case Disconnecting: {
                        this.initiateClosingTransient();
                        break;
                    }
                    case Dialling: {
                        if (!this.isInitiator || this.timeout <= 0) break;
                        if (this.gateType == 1) {
                            SGCraft.playSound(this, m_gateRollSound);
                            break;
                        }
                        SGCraft.playSound(this, p_gateRollSound);
                        break;
                    }
                    case Connected: {
                        SGCraft.playSound(this, eventHorizonSound);
                    }
                }
            }
            if (this.irisState != oldIrisState) {
                switch (this.irisState) {
                    case Opening: {
                        SGCraft.playSound(this, irisOpenSound);
                        break;
                    }
                    case Closing: {
                        SGCraft.playSound(this, irisCloseSound);
                    }
                }
            }
        }
    }

    void clientUpdate() {
        this.lastRingAngle = this.ringAngle;
        switch (this.state) {
            case Dialling: {
                if (this.timeout <= 0) break;
                double step = (double)(this.maxTimeout - this.timeout) / (double)this.maxTimeout;
                this.ringAngle = this.startRingAngle + (this.targetRingAngle - this.startRingAngle) * step;
                --this.timeout;
                break;
            }
            case Transient: 
            case Connected: 
            case Disconnecting: {
                this.applyRandomImpulse();
                this.updateEventHorizon();
            }
        }
    }

    public EnumActionResult applyChevronUpgrade(ItemStack stack, EntityPlayer player) {
        if (!this.func_145831_w().field_72995_K && !this.hasChevronUpgrade && stack.func_190916_E() > 0) {
            this.hasChevronUpgrade = true;
            stack.func_190918_g(1);
            this.markChanged();
        }
        return EnumActionResult.SUCCESS;
    }

    public EnumActionResult applyIrisUpgrade(ItemStack stack, EntityPlayer player) {
        if (!this.func_145831_w().field_72995_K && !this.hasIrisUpgrade && stack.func_190916_E() > 0) {
            this.hasIrisUpgrade = true;
            stack.func_190918_g(1);
            this.markChanged();
            this.updateIrisEntity();
        }
        return EnumActionResult.SUCCESS;
    }

    public EnumActionResult applyPegasusUpgrade(ItemStack stack, EntityPlayer player) {
        if (!this.func_145831_w().field_72995_K && this.gateType != 2) {
            this.gateType = 2;
            this.ringRotationSpeed = 6.0;
            stack.func_190918_g(1);
            this.markChanged();
        }
        return EnumActionResult.SUCCESS;
    }

    public double[][][] getEventHorizonGrid() {
        if (this.ehGrid == null) {
            int m = 5;
            int n = 32;
            this.ehGrid = new double[2][n + 2][m + 1];
            for (int i = 0; i < 2; ++i) {
                this.ehGrid[i][0] = this.ehGrid[i][n];
                this.ehGrid[i][n + 1] = this.ehGrid[i][1];
            }
        }
        return this.ehGrid;
    }

    void initiateOpeningTransient() {
        double[][] v = this.getEventHorizonGrid()[1];
        int n = 32;
        for (int j = 0; j <= n + 1; ++j) {
            v[j][0] = 1.3;
            v[j][1] = v[j][0] + 0.25 * random.nextGaussian();
        }
    }

    void initiateClosingTransient() {
        double[][] v = this.getEventHorizonGrid()[1];
        int m = 5;
        int n = 32;
        for (int i = 1; i < m; ++i) {
            for (int j = 1; j <= n; ++j) {
                double[] dArray = v[j];
                int n2 = i;
                dArray[n2] = dArray[n2] + 0.25 * random.nextGaussian();
            }
        }
    }

    void applyRandomImpulse() {
        double[][] v = this.getEventHorizonGrid()[1];
        int m = 5;
        int n = 32;
        int i = random.nextInt(m - 1) + 1;
        int j = random.nextInt(n) + 1;
        double[] dArray = v[j];
        int n2 = i;
        dArray[n2] = dArray[n2] + 0.05 * random.nextGaussian();
    }

    void updateEventHorizon() {
        int j;
        int j2;
        int i;
        double[][][] grid = this.getEventHorizonGrid();
        double[][] u = grid[0];
        double[][] v = grid[1];
        int m = 5;
        int n = 32;
        double dt = 1.0;
        double asq = 0.03;
        double d = 0.95;
        for (i = 1; i < m; ++i) {
            for (j2 = 1; j2 <= n; ++j2) {
                double du_dr = 0.5 * (u[j2][i + 1] - u[j2][i - 1]);
                double d2u_drsq = u[j2][i + 1] - 2.0 * u[j2][i] + u[j2][i - 1];
                double d2u_dthsq = u[j2 + 1][i] - 2.0 * u[j2][i] + u[j2 - 1][i];
                v[j2][i] = d * v[j2][i] + asq * dt * (d2u_drsq + du_dr / (double)i + d2u_dthsq / (double)(i * i));
            }
        }
        for (i = 1; i < m; ++i) {
            for (j2 = 1; j2 <= n; ++j2) {
                double[] dArray = u[j2];
                int n2 = i;
                dArray[n2] = dArray[n2] + v[j2][i] * dt;
            }
        }
        double u0 = 0.0;
        double v0 = 0.0;
        for (j = 1; j <= n; ++j) {
            u0 += u[j][1];
            v0 += v[j][1];
        }
        u0 /= (double)n;
        v0 /= (double)n;
        for (j = 1; j <= n; ++j) {
            u[j][0] = u0;
            v[j][0] = v0;
        }
    }

    void dumpGrid(String label, double[][] g) {
        System.out.printf("SGBaseTE: %s:\n", label);
        int m = 5;
        int n = 32;
        for (int j = 0; j <= n + 1; ++j) {
            for (int i = 0; i <= m; ++i) {
                System.out.printf(" %6.3f", g[j][i]);
            }
            System.out.print("\n");
        }
    }

    public boolean irisIsClosed() {
        return this.hasIrisUpgrade && this.irisPhase <= 35;
    }

    public double getIrisAperture(double partialTicks) {
        return ((double)this.lastIrisPhase * (1.0 - partialTicks) + (double)this.irisPhase * partialTicks) / 70.0;
    }

    void irisUpdate() {
        this.lastIrisPhase = this.irisPhase;
        switch (this.irisState) {
            case Opening: {
                if (this.irisPhase < 70) {
                    ++this.irisPhase;
                    break;
                }
                this.enterIrisState(IrisState.Open);
                break;
            }
            case Closing: {
                if (this.irisPhase > 0) {
                    --this.irisPhase;
                    break;
                }
                this.enterIrisState(IrisState.Closed);
            }
        }
    }

    void enterIrisState(IrisState newState) {
        if (this.irisState != newState) {
            String oldDesc = SGBaseTE.irisStateDescription(this.irisState);
            String newDesc = SGBaseTE.irisStateDescription(newState);
            this.irisState = newState;
            this.markChanged();
            if (!oldDesc.equals(newDesc)) {
                this.postEvent("sgIrisStateChange", newDesc, oldDesc);
            }
        }
    }

    public void openIris() {
        if (this.isMerged && this.hasIrisUpgrade && this.irisState != IrisState.Open) {
            this.enterIrisState(IrisState.Opening);
        }
    }

    public void closeIris() {
        if (this.isMerged && this.hasIrisUpgrade && this.irisState != IrisState.Closed) {
            this.enterIrisState(IrisState.Closing);
        }
    }

    public Collection<TileEntity> adjacentTiles() {
        ArrayList<TileEntity> result = new ArrayList<TileEntity>();
        Trans3 t = this.localToGlobalTransformation();
        for (int i = -2; i <= 2; ++i) {
            BlockPos bp = t.p(i, -1.0, 0.0).blockPos();
            TileEntity te = BaseBlockUtils.getWorldTileEntity((IBlockAccess)this.field_145850_b, bp);
            if (te == null) continue;
            result.add(te);
        }
        return result;
    }

    public void forwardNetworkPacket(Object packet) {
        SGBaseTE dte = this.getConnectedStargateTE();
        if (dte != null) {
            dte.rebroadcastNetworkPacket(packet);
        }
    }

    void rebroadcastNetworkPacket(Object packet) {
        for (TileEntity te : this.adjacentTiles()) {
            if (!(te instanceof SGInterfaceTE)) continue;
            ((SGInterfaceTE)te).rebroadcastNetworkPacket(packet);
        }
    }

    public String sendMessage(Object[] args) {
        SGBaseTE dte = this.getConnectedStargateTE();
        if (dte != null) {
            dte.postEvent("sgMessageReceived", args);
            return null;
        }
        return "Stargate not connected";
    }

    void postEvent(String name, Object ... args) {
        for (TileEntity te : this.adjacentTiles()) {
            if (!(te instanceof IComputerInterface)) continue;
            ((IComputerInterface)te).postEvent(this, name, args);
        }
        this.debugCCInterface = false;
    }

    public String sgStateDescription() {
        return this.sgStateDescription(this.state);
    }

    String sgStateDescription(SGState state) {
        switch (state) {
            case Idle: {
                return "Idle";
            }
            case Dialling: 
            case InterDialling: 
            case attemptToDial: {
                return "Dialling";
            }
            case Transient: 
            case EstablishingConnection: 
            case SyncAwait: {
                return "Opening";
            }
            case Connected: {
                return "Connected";
            }
            case Disconnecting: {
                return "Closing";
            }
        }
        return "Unknown";
    }

    public String irisStateDescription() {
        return SGBaseTE.irisStateDescription(this.irisState);
    }

    static String irisStateDescription(IrisState state) {
        return state.toString();
    }

    public static SGBaseTE getBaseTE(SGInterfaceTE ite) {
        return SGBaseTE.get((IBlockAccess)ite.func_145831_w(), ite.func_174877_v().func_177982_a(0, 1, 0));
    }

    public double getMaxEnergyBuffer() {
        return this.maxEnergyBuffer;
    }

    public double getBaseMaxEnergyBuffer() {
        return this.maxEnergyBuffer;
    }

    static {
        numRingSymbols = SGAddressing.numSymbols;
        ringSymbolAngle = 360.0 / (double)numRingSymbols;
        irisDamageSource = new DamageSource("sgcraft:iris");
        minutesOpenPerFuelItem = 80;
        firstCamouflageSlot = 0;
        numInventorySlots = numCamouflageSlots = 5;
        defaultChevronAngle = 40.0f;
        chevronAngles = new float[][]{{45.0f, 45.0f, 40.0f}, {36.0f, 33.0f, 30.0f}};
        chunkLoadingRange = 1;
        logStargateEvents = false;
        soundVolume = 1.0f;
        variableChevronPositions = true;
        random = new Random();
        transientDamageSource = new DamageSource("sgcraft:transient");
        messagesQueue = Sets.newHashSet();
        rdx = new int[]{1, 0, -1, 0};
        rdz = new int[]{0, -1, 0, 1};
    }

    class TrackedEntity {
        public Entity entity;
        public Vector3 lastPos;

        public TrackedEntity(Entity entity) {
            this.entity = entity;
            this.lastPos = new Vector3(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        }
    }
}

