/*
 * Decompiled with CFR 0.152.
 */
package readonly.api.config.values;

import readonly.api.config.Range;
import readonly.api.config.def.Category;
import readonly.api.config.def.Comment;
import readonly.api.config.def.Key;
import readonly.api.config.values.OptValue;

public class OptDouble
extends OptValue {
    private Range<Double> range;
    private double valueDouble;
    private boolean hasRange;

    public OptDouble(Key key, Category category, Comment comment, double defaultValue) {
        super(OptValue.Type.DOUBLE, key, category, comment);
        this.valueDouble = defaultValue;
        this.hasRange = false;
        this.formatDescription(String.valueOf(defaultValue));
    }

    public OptDouble(Key key, Category category, Comment comment, double defaultValue, double minValueDouble, double maxValueDouble) {
        super(OptValue.Type.DOUBLE, key, category, comment);
        this.range = Range.of(minValueDouble, minValueDouble);
        this.hasRange = true;
        this.valueDouble = defaultValue;
        this.formatDescription(Range.of(minValueDouble, minValueDouble).commentAddl(defaultValue));
    }

    public boolean hasRange() {
        return this.hasRange;
    }

    public double min() {
        return this.range.min();
    }

    public double max() {
        return this.range.max();
    }

    public double get() {
        return this.valueDouble;
    }

    public void set(double value) {
        this.valueDouble = value;
    }
}

